/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import ksp.org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import ksp.org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import ksp.org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/psi2ir/generators/LocalClassGenerator;", "Lksp/org/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lksp/org/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateLocalClass", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "ktClassOrObject", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "generateObjectLiteral", "ktObjectLiteral", "Lksp/org/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "ir.psi2ir"})
public final class LocalClassGenerator
extends StatementGeneratorExtension {
    public LocalClassGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter(statementGenerator, "statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public final IrStatement generateObjectLiteral(@NotNull KtObjectLiteralExpression ktObjectLiteral) {
        boolean bl;
        Intrinsics.checkNotNullParameter(ktObjectLiteral, "ktObjectLiteral");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktObjectLiteral);
        int endOffset = PsiUtilsKt.getEndOffset(ktObjectLiteral);
        IrType objectLiteralType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, ktObjectLiteral));
        IrBlockImpl irBlock = new IrBlockImpl(startOffset, endOffset, objectLiteralType, IrStatementOrigin.Companion.getOBJECT_LITERAL());
        DeclarationGenerator declarationGenerator = new DeclarationGenerator(this.getStatementGenerator().getContext());
        KtObjectDeclaration ktObjectDeclaration = ktObjectLiteral.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
        IrClass irClass = declarationGenerator.generateClassOrObjectDeclaration(ktObjectDeclaration);
        irBlock.getStatements().add(irClass);
        ClassConstructorDescriptor classConstructorDescriptor = irClass.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw new AssertionError((Object)("Object literal should have a primary constructor: " + irClass.getDescriptor()));
        }
        ClassConstructorDescriptor objectConstructor = classConstructorDescriptor;
        boolean bl2 = bl = objectConstructor.getDispatchReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = "Object literal constructor should have no dispatch receiver parameter: " + objectConstructor;
            throw new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$42);
        }
        boolean bl3 = bl = objectConstructor.getExtensionReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = "Object literal constructor should have no extension receiver parameter: " + objectConstructor;
            throw new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$52);
        }
        boolean bl4 = bl = objectConstructor.getValueParameters().size() == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string2 = "Object literal constructor should have no value parameters: " + objectConstructor;
            throw new AssertionError((Object)string2);
        }
        irBlock.getStatements().add(IrConstructorCallImpl.Companion.fromSymbolDescriptor(startOffset, endOffset, objectLiteralType, this.getContext().getSymbolTable().getDescriptorExtension().referenceConstructor(objectConstructor), IrStatementOrigin.Companion.getOBJECT_LITERAL()));
        return irBlock;
    }

    @NotNull
    public final IrStatement generateLocalClass(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkNotNullParameter(ktClassOrObject, "ktClassOrObject");
        return new DeclarationGenerator(this.getStatementGenerator().getContext()).generateClassOrObjectDeclaration(ktClassOrObject);
    }
}

