/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;
import ksp.org.jetbrains.kotlin.psi.stubs.StubUtils;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0014H\u0016\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtTypeAliasElementType;", "Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "Lksp/org/jetbrains/kotlin/psi/KtTypeAlias;", "debugName", "", "(Ljava/lang/String;)V", "createStub", "psi", "parentStub", "Lksp/com/intellij/psi/stubs/StubElement;", "deserialize", "dataStream", "Lksp/com/intellij/psi/stubs/StubInputStream;", "indexStub", "", "stub", "sink", "Lksp/com/intellij/psi/stubs/IndexSink;", "serialize", "Lksp/com/intellij/psi/stubs/StubOutputStream;"})
public final class KtTypeAliasElementType
extends KtStubElementType<KotlinTypeAliasStub, KtTypeAlias> {
    public KtTypeAliasElementType(@NotNull String debugName) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        super(debugName, KtTypeAlias.class, KotlinTypeAliasStub.class);
    }

    @Override
    @NotNull
    public KotlinTypeAliasStub createStub(@NotNull KtTypeAlias psi2, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi2, "psi");
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        StringRef name2 = StringRef.fromString(psi2.getName());
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi2);
        StringRef fqName3 = StringRef.fromString(fqName2 != null ? fqName2.asString() : null);
        ClassId classId = StubUtils.createNestedClassId(parentStub, psi2);
        boolean isTopLevel2 = psi2.isTopLevel();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName3, classId, isTopLevel2);
    }

    @Override
    public void serialize(@NotNull KotlinTypeAliasStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        StubUtils.serializeClassId(dataStream, stub.getClassId());
        dataStream.writeBoolean(stub.isTopLevel());
    }

    @Override
    @NotNull
    public KotlinTypeAliasStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef name2 = dataStream.readName();
        StringRef fqName2 = dataStream.readName();
        ClassId classId = StubUtils.deserializeClassId(dataStream);
        boolean isTopLevel2 = dataStream.readBoolean();
        return new KotlinTypeAliasStubImpl(parentStub, name2, fqName2, classId, isTopLevel2);
    }

    @Override
    public void indexStub(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        Intrinsics.checkNotNullParameter(sink, "sink");
        StubIndexService.Companion.getInstance().indexTypeAlias(stub, sink);
    }
}

