/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.kotlin.constant.ConstantValue;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinStubOrigin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class KtPropertyElementType
extends KtStubElementType<KotlinPropertyStub, KtProperty> {
    public KtPropertyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtPropertyElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtProperty.class, KotlinPropertyStub.class);
    }

    @Override
    @NotNull
    public KotlinPropertyStub createStub(@NotNull KtProperty psi2, StubElement parentStub) {
        if (psi2 == null) {
            KtPropertyElementType.$$$reportNull$$$0(1);
        }
        assert (!psi2.isLocal()) : String.format("Should not store local property: %s, parent %s", psi2.getText(), psi2.getParent() != null ? psi2.getParent().getText() : "<no parent>");
        return new KotlinPropertyStubImpl(parentStub, StringRef.fromString(psi2.getName()), psi2.isVar(), psi2.isTopLevel(), psi2.hasDelegate(), psi2.hasDelegateExpression(), psi2.hasInitializer(), psi2.getReceiverTypeReference() != null, psi2.getTypeReference() != null, KtPsiUtilKt.safeFqNameForLazyResolve(psi2), null, null);
    }

    @Override
    public void serialize(@NotNull KotlinPropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtPropertyElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isVar());
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.hasDelegate());
        dataStream.writeBoolean(stub.hasDelegateExpression());
        dataStream.writeBoolean(stub.hasInitializer());
        dataStream.writeBoolean(stub.isExtension());
        dataStream.writeBoolean(stub.hasReturnTypeRef());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        if (stub instanceof KotlinPropertyStubImpl) {
            KotlinPropertyStubImpl stubImpl = (KotlinPropertyStubImpl)stub;
            ConstantValue<?> constantInitializer = ((KotlinPropertyStubImpl)stub).getConstantInitializer();
            if (constantInitializer != null) {
                KotlinConstantValueKt.serialize(constantInitializer, dataStream);
            } else {
                dataStream.writeInt(-1);
            }
            KotlinStubOrigin.serialize(stubImpl.getOrigin(), dataStream);
        }
    }

    @Override
    @NotNull
    public KotlinPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtPropertyElementType.$$$reportNull$$$0(4);
        }
        StringRef name2 = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel2 = dataStream.readBoolean();
        boolean hasDelegate = dataStream.readBoolean();
        boolean hasDelegateExpression = dataStream.readBoolean();
        boolean hasInitializer = dataStream.readBoolean();
        boolean hasReceiverTypeRef = dataStream.readBoolean();
        boolean hasReturnTypeRef = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        return new KotlinPropertyStubImpl(parentStub, name2, isVar, isTopLevel2, hasDelegate, hasDelegateExpression, hasInitializer, hasReceiverTypeRef, hasReturnTypeRef, fqName2, KotlinConstantValueKt.createConstantValue(dataStream), KotlinStubOrigin.deserialize(dataStream));
    }

    @Override
    public void indexStub(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            KtPropertyElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            KtPropertyElementType.$$$reportNull$$$0(6);
        }
        StubIndexService.getInstance().indexProperty(stub, sink);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

