/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtEnumEntry;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinClassifierStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/StubUtils;", "", "()V", "createNestedClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "parentStub", "Lksp/com/intellij/psi/stubs/StubElement;", "currentDeclaration", "Lksp/org/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "deserializeClassId", "dataStream", "Lksp/com/intellij/psi/stubs/StubInputStream;", "serializeClassId", "", "Lksp/com/intellij/psi/stubs/StubOutputStream;", "classId", "psi"})
public final class StubUtils {
    @NotNull
    public static final StubUtils INSTANCE = new StubUtils();

    private StubUtils() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId deserializeClassId(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        StringRef stringRef = dataStream.readName();
        if (stringRef == null) {
            return null;
        }
        StringRef classId = stringRef;
        String string2 = classId.getString();
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        return ClassId.Companion.fromString$default(ClassId.Companion, string2, false, 2, null);
    }

    @JvmStatic
    public static final void serializeClassId(@NotNull StubOutputStream dataStream, @Nullable ClassId classId) {
        Intrinsics.checkNotNullParameter(dataStream, "dataStream");
        ClassId classId2 = classId;
        dataStream.writeName(classId2 != null ? classId2.asString() : null);
    }

    @JvmStatic
    @Nullable
    public static final ClassId createNestedClassId(@NotNull StubElement<?> parentStub, @NotNull KtClassLikeDeclaration currentDeclaration) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(currentDeclaration, "currentDeclaration");
        if (parentStub instanceof KotlinFileStub) {
            FqName fqName2 = ((KotlinFileStub)parentStub).getPackageFqName();
            Name name2 = currentDeclaration.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue(name2, "getNameAsSafeName(...)");
            classId = new ClassId(fqName2, name2);
        } else if (parentStub instanceof KotlinScriptStub) {
            StubElement stubElement = ((KotlinScriptStub)parentStub).getParentStub();
            Intrinsics.checkNotNullExpressionValue(stubElement, "getParentStub(...)");
            classId = StubUtils.createNestedClassId(stubElement, currentDeclaration);
        } else if (parentStub instanceof KotlinPlaceHolderStub && Intrinsics.areEqual(((KotlinPlaceHolderStub)parentStub).getStubType(), KtStubElementTypes.CLASS_BODY)) {
            KotlinClassifierStub containingClassStub;
            StubElement stubElement = ((KotlinPlaceHolderStub)parentStub).getParentStub();
            KotlinClassifierStub kotlinClassifierStub = containingClassStub = stubElement instanceof KotlinClassifierStub ? (KotlinClassifierStub)((Object)stubElement) : null;
            if (containingClassStub != null && !(currentDeclaration instanceof KtEnumEntry)) {
                ClassId classId2 = containingClassStub.getClassId();
                if (classId2 != null) {
                    Name name3 = currentDeclaration.getNameAsSafeName();
                    Intrinsics.checkNotNullExpressionValue(name3, "getNameAsSafeName(...)");
                    classId = classId2.createNestedClassId(name3);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }
}

