/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiWhiteSpace;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactory;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtPrimaryConstructorElementType;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J=\u0010\b\u001a\n \n*\u0004\u0018\u0001H\tH\t\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u001c\u001a\u00020\u0014\u00a8\u0006\u001d"}, d2={"Lksp/org/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lksp/org/jetbrains/kotlin/psi/KtConstructor;", "node", "Lksp/com/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lksp/org/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "addAnnotationEntry", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "addModifier", "", "modifier", "Lksp/org/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getContainingClassOrObject", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "getOrCreateConstructorKeyword", "Lksp/com/intellij/psi/PsiElement;", "removeModifier", "removeRedundantConstructorKeywordAndSpace", "psi"})
public final class KtPrimaryConstructor
extends KtConstructor<KtPrimaryConstructor> {
    public KtPrimaryConstructor(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtPrimaryConstructor(@NotNull KotlinConstructorStub<KtPrimaryConstructor> stub) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        KtPrimaryConstructorElementType ktPrimaryConstructorElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
        Intrinsics.checkNotNullExpressionValue(ktPrimaryConstructorElementType, "PRIMARY_CONSTRUCTOR");
        super(stub, ktPrimaryConstructorElementType);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitPrimaryConstructor(this, data2);
    }

    @Override
    @NotNull
    public KtClassOrObject getContainingClassOrObject() {
        PsiElement psiElement = this.getParent();
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
        return (KtClassOrObject)psiElement;
    }

    private final PsiElement getOrCreateConstructorKeyword() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            PsiElement psiElement2 = new KtPsiFactory(project, false, 2, null).createConstructorKeyword();
            KtParameterList ktParameterList = this.getValueParameterList();
            Intrinsics.checkNotNull(ktParameterList);
            PsiElement psiElement3 = this.addBefore(psiElement2, ktParameterList);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue(psiElement3, "addBefore(...)");
        }
        return psiElement;
    }

    public final void removeRedundantConstructorKeywordAndSpace() {
        PsiElement psiElement = this.getConstructorKeyword();
        if (psiElement != null) {
            psiElement.delete();
        }
        if (this.getPrevSibling() instanceof PsiWhiteSpace) {
            this.getPrevSibling().delete();
        }
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            AddRemoveModifierKt.addModifier(modifierList2, modifier);
            if (this.getModifierList() == null) {
                PsiElement psiElement = this.getConstructorKeyword();
                if (psiElement != null) {
                    psiElement.delete();
                }
            }
        } else {
            if (Intrinsics.areEqual(modifier, KtTokens.PUBLIC_KEYWORD)) {
                return;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            KtModifierList newModifierList = new KtPsiFactory(project, false, 2, null).createModifierList(modifier);
            this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
        }
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        super.removeModifier(modifier);
        if (this.getModifierList() == null) {
            this.removeRedundantConstructorKeywordAndSpace();
        }
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(annotationEntry2, "annotationEntry");
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null) {
            PsiElement psiElement = modifierList2.addBefore(annotationEntry2, modifierList2.getFirstChild());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            ktAnnotationEntry = (KtAnnotationEntry)psiElement;
        } else {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string2 = annotationEntry2.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            KtModifierList newModifierList = ktPsiFactory.createModifierList(string2);
            PsiElement psiElement = this.addBefore(newModifierList, this.getOrCreateConstructorKeyword());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtModifierList");
            List<KtAnnotationEntry> list2 = ((KtModifierList)psiElement).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
            KtAnnotationEntry ktAnnotationEntry2 = CollectionsKt.first(list2);
            Intrinsics.checkNotNull(ktAnnotationEntry2);
            ktAnnotationEntry = ktAnnotationEntry2;
        }
        return ktAnnotationEntry;
    }
}

