/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.operation;

import java.util.Arrays;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBlock;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.operation.DynamicIncrementTranslator;
import ksp.org.jetbrains.kotlin.js.translate.operation.IntrinsicIncrementTranslator;
import ksp.org.jetbrains.kotlin.js.translate.operation.OverloadedIncrementTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtUnaryExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import ksp.org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.annotations.NotNull;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtUnaryExpression expression;
    @NotNull
    protected final AccessTranslator accessTranslator;
    @NotNull
    private final JsBlock accessBlock;

    public static boolean isIncrement(IElementType operationToken) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            IncrementTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            IncrementTranslator.$$$reportNull$$$0(1);
        }
        if (IncrementTranslator.isDynamic(context2, expression2)) {
            JsExpression jsExpression = DynamicIncrementTranslator.doTranslate(expression2, context2);
            if (jsExpression == null) {
                IncrementTranslator.$$$reportNull$$$0(2);
            }
            return jsExpression;
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context2, expression2)) {
            JsExpression jsExpression = new IntrinsicIncrementTranslator(expression2, context2).translateIncrementExpression();
            if (jsExpression == null) {
                IncrementTranslator.$$$reportNull$$$0(3);
            }
            return jsExpression;
        }
        JsExpression jsExpression = new OverloadedIncrementTranslator(expression2, context2).translateIncrementExpression();
        if (jsExpression == null) {
            IncrementTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    protected IncrementTranslator(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            IncrementTranslator.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            IncrementTranslator.$$$reportNull$$$0(6);
        }
        super(context2);
        this.accessBlock = new JsBlock();
        this.expression = expression2;
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression2);
        this.accessTranslator = AccessTranslationUtils.getAccessTranslator(baseExpression, this.context().innerBlock(this.accessBlock)).getCached();
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            return this.asPrefix();
        }
        return this.asPostfix();
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression result2;
        JsExpression getExpression = this.accessTranslator.translateAsGet().source(this.expression);
        JsExpression reassignment = this.variableReassignment(this.context().innerBlock(this.accessBlock), getExpression).source(this.expression);
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(reassignment));
        JsExpression getNewValue = this.accessTranslator.translateAsGet().source(this.expression);
        if (this.accessBlock.getStatements().size() == 1) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, reassignment, getNewValue);
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = getNewValue;
        }
        MetadataProperties.setSynthetic(result2, true);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            IncrementTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression asPostfix() {
        JsExpression result2;
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet().source(this.expression), this.expression);
        this.accessBlock.getStatements().add(t1.assignmentStatement());
        JsExpression variableReassignment = this.variableReassignment(this.context().innerBlock(this.accessBlock), t1.reference()).source(this.expression);
        this.accessBlock.getStatements().add(JsAstUtils.asSyntheticStatement(variableReassignment.source(this.expression)));
        if (this.accessBlock.getStatements().size() == 2) {
            result2 = JsAstUtils.newSequence(Arrays.asList(t1.assignmentExpression(), variableReassignment, t1.reference()));
        } else {
            this.context().getCurrentBlock().getStatements().addAll(this.accessBlock.getStatements());
            result2 = t1.reference();
        }
        MetadataProperties.setSynthetic(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            IncrementTranslator.$$$reportNull$$$0(8);
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull TranslationContext context2, @NotNull JsExpression toCallMethodUpon) {
        if (context2 == null) {
            IncrementTranslator.$$$reportNull$$$0(9);
        }
        if (toCallMethodUpon == null) {
            IncrementTranslator.$$$reportNull$$$0(10);
        }
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(context2, toCallMethodUpon);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
        if (jsExpression == null) {
            IncrementTranslator.$$$reportNull$$$0(11);
        }
        return jsExpression;
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull TranslationContext var1, @NotNull JsExpression var2);

    private static boolean isDynamic(TranslationContext context2, KtUnaryExpression expression2) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression2);
        assert (operationDescriptor != null);
        return DynamicCallsKt.isDynamic(operationDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/operation/IncrementTranslator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCallMethodUpon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/operation/IncrementTranslator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asPostfix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "variableReassignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "variableReassignment";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

