/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.expression;

import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsConditional;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import ksp.org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.js.patterns.NamePredicate;
import ksp.org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import ksp.org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import ksp.org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import ksp.org.jetbrains.kotlin.psi.KtVisitorVoid;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringTemplateTranslator
extends AbstractTranslator {
    private final KtStringTemplateEntry[] expressionEntries;

    @NotNull
    public static JsExpression translate(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            StringTemplateTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            StringTemplateTranslator.$$$reportNull$$$0(1);
        }
        return new StringTemplateTranslator(expression2, context2).translate();
    }

    private StringTemplateTranslator(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            StringTemplateTranslator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            StringTemplateTranslator.$$$reportNull$$$0(3);
        }
        super(context2);
        this.expressionEntries = expression2.getEntries();
        assert (this.expressionEntries.length != 0) : ErrorReportingUtils.message(expression2, "String template must have one or more entries.");
    }

    @NotNull
    private JsExpression translate() {
        EntryVisitor entryVisitor = new EntryVisitor();
        for (KtStringTemplateEntry entry : this.expressionEntries) {
            entry.accept(entryVisitor);
        }
        JsExpression jsExpression = entryVisitor.getResultingExpression();
        if (jsExpression == null) {
            StringTemplateTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class EntryVisitor
    extends KtVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression2) {
            if (expression2 == null) {
                EntryVisitor.$$$reportNull$$$0(0);
            }
            this.resultingExpression = this.resultingExpression == null ? expression2 : JsAstUtils.sum(this.resultingExpression, expression2);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(1);
            }
            KtExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "KtStringTemplateEntryWithExpression must have not null entry expression.";
            JsExpression translatedExpression = Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context());
            KotlinType type2 = StringTemplateTranslator.this.context().bindingContext().getType(entryExpression);
            if (type2 != null && KotlinBuiltIns.isCharOrNullableChar(type2)) {
                if (type2.isMarkedNullable()) {
                    TemporaryVariable tmp = StringTemplateTranslator.this.context().declareTemporary(translatedExpression, entry);
                    this.append(new JsConditional(JsAstUtils.equality(tmp.assignmentExpression(), new JsNullLiteral()), new JsNullLiteral(), JsAstUtils.charToString(tmp.reference())));
                } else {
                    this.append(JsAstUtils.charToString(translatedExpression));
                }
            } else if (translatedExpression instanceof JsNumberLiteral) {
                this.append(new JsStringLiteral(translatedExpression.toString()));
            } else if (type2 == null || type2.isMarkedNullable()) {
                this.append(TopLevelFIF.TO_STRING.apply((JsExpression)null, new SmartList<JsExpression>(translatedExpression), StringTemplateTranslator.this.context()));
            } else if (this.mustCallToString(type2)) {
                this.append(new JsInvocation((JsExpression)new JsNameRef("toString", translatedExpression), new JsExpression[0]));
            } else {
                this.append(translatedExpression);
            }
        }

        private boolean mustCallToString(@NotNull KotlinType type2) {
            if (type2 == null) {
                EntryVisitor.$$$reportNull$$$0(2);
            }
            Name typeName = DescriptorUtilsKt.getNameIfStandardType(type2);
            if (KotlinBuiltIns.isAny(type2) || KotlinBuiltIns.isComparable(type2) || KotlinBuiltIns.isNumber(type2) || KotlinBuiltIns.isLong(type2)) {
                return true;
            }
            if (typeName != null && NamePredicate.STRING.test(typeName)) {
                return false;
            }
            return this.resultingExpression == null;
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(3);
            }
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
            if (entry == null) {
                EntryVisitor.$$$reportNull$$$0(4);
            }
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text) {
            if (text == null) {
                EntryVisitor.$$$reportNull$$$0(5);
            }
            this.append(new JsStringLiteral(text));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            JsExpression jsExpression = this.resultingExpression;
            if (jsExpression == null) {
                EntryVisitor.$$$reportNull$$$0(6);
            }
            return jsExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/expression/StringTemplateTranslator$EntryVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultingExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitStringTemplateEntryWithExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "mustCallToString";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLiteralStringTemplateEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEscapeStringTemplateEntry";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

