/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.extapi.psi.ASTDelegatePsiElement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.impl.source.tree.LeafPsiElement;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsFunction;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNode;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsParameter;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVars;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.context.UsageTracker;
import ksp.org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import ksp.org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import ksp.org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import ksp.org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import ksp.org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lksp/org/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsVars;", "Lksp/org/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nLiteralFunctionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiteralFunctionTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1853#2,2:265\n*S KotlinDebug\n*F\n+ 1 LiteralFunctionTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator\n*L\n59#1:265,2\n*E\n"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    public LiteralFunctionTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
    }

    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration2);
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue(translationContext, "context(...)");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration2);
        Intrinsics.checkNotNullExpressionValue(functionDescriptor, "getFunctionDescriptor(...)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsFunction, "getFunctionObject(...)");
        JsFunction lambda2 = jsFunction;
        TranslationContext translationContext2 = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        Intrinsics.checkNotNullExpressionValue(translationContext2, "newFunctionBodyWithUsageTracker(...)");
        List<JsParameter> list2 = lambda2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getParameters(...)");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor2, list2);
        List<ValueParameterDescriptor> list3 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            lambda2.getBody().getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        List<JsStatement> list4 = lambda2.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list4, "getStatements(...)");
        Collection $i$f$forEach22 = list4;
        List<JsStatement> list5 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkNotNullExpressionValue(list5, "setDefaultValueForArguments(...)");
        CollectionsKt.addAll($i$f$forEach22, (Iterable)list5);
        List<JsStatement> list6 = lambda2.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list6, "getStatements(...)");
        $i$f$forEach22 = list6;
        $i$f$forEach22.add(FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration2, functionContext));
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        lambda2.setSource(declaration2);
        lambda2.getBody().setSource(finalElement instanceof LeafPsiElement ? (LeafPsiElement)finalElement : null);
        UsageTracker usageTracker = functionContext.usageTracker();
        Intrinsics.checkNotNull(usageTracker);
        UsageTracker tracker = usageTracker;
        JsName jsName = invokingContext.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkNotNullExpressionValue(jsName, "getInnerNameForDescriptor(...)");
        JsName name2 = jsName;
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction jsFunction2 = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2.source(declaration2));
            Intrinsics.checkNotNullExpressionValue(jsFunction2, "simpleReturnFunction(...)");
            JsFunction lambdaCreator = jsFunction2;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (tracker.getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2));
            }
            MetadataProperties.setStaticRef(name2, lambdaCreator);
            this.fillCoroutineMetadata(lambdaCreator, invokingContext, descriptor2);
            lambdaCreator.setSource(declaration2);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, name2, invokingContext, declaration2);
        }
        if (tracker.getCapturedDescriptors().contains(descriptor2)) {
            JsName jsName2 = UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2);
            Intrinsics.checkNotNull(jsName2);
            JsName capturedName = jsName2;
            JsName jsName3 = invokingContext.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkNotNullExpressionValue(jsName3, "getInnerNameForDescriptor(...)");
            JsName globalName = jsName3;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf(TuplesKt.to(capturedName, JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, name2, lambda2, declaration2);
        this.fillCoroutineMetadata(lambda2, invokingContext, descriptor2);
        MetadataProperties.setStaticRef(name2, lambda2);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name2, null);
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "pureFqn(...)");
        return jsNameRef;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context2, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter($this$fillCoroutineMetadata, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($this$fillCoroutineMetadata, context2, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($this$fillCoroutineMetadata, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $this$translate, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter($this$translate, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($this$translate);
        ASTDelegatePsiElement aSTDelegatePsiElement = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
        if (aSTDelegatePsiElement == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            throw new IllegalStateException(("Destructuring declaration for descriptor " + $this$translate + " not found").toString());
        }
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference($this$translate, context2);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsValueReference(...)");
        JsExpression parameterRef = jsExpression;
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, parameterRef, context2);
        Intrinsics.checkNotNullExpressionValue(jsVars, "translate(...)");
        return jsVars;
    }
}

