/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import ksp.org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0014J\f\u0010\t\u001a\u00020\b*\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/callTranslator/InvokeIntrinsic;", "Lksp/org/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "canApply", "", "callInfo", "Lksp/org/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "bothReceivers", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "dispatchReceiver", "js.translator"})
public final class InvokeIntrinsic
extends FunctionCallCase {
    @NotNull
    public static final InvokeIntrinsic INSTANCE = new InvokeIntrinsic();

    private InvokeIntrinsic() {
    }

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor(callInfo);
        if (callableDescriptor instanceof FunctionInvokeDescriptor) {
            return true;
        }
        if (!Intrinsics.areEqual(callableDescriptor.getName(), OperatorNameConventions.INVOKE) || callableDescriptor.getExtensionReceiverParameter() == null) {
            return false;
        }
        int parameterCount = callableDescriptor.getValueParameters().size() + 1;
        DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor funDeclaration = declarationDescriptor;
        return Intrinsics.areEqual(funDeclaration, DescriptorUtilsKt.getBuiltIns(callableDescriptor).getFunction(parameterCount));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$dispatchReceiver, "<this>");
        JsExpression jsExpression = $this$dispatchReceiver.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        return new JsInvocation(jsExpression, $this$dispatchReceiver.getArgumentsInfo().getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $this$bothReceivers) {
        Intrinsics.checkNotNullParameter($this$bothReceivers, "<this>");
        JsExpression jsExpression = $this$bothReceivers.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$bothReceivers.getArgumentsInfo();
        JsExpression jsExpression2 = $this$bothReceivers.getExtensionReceiver();
        Intrinsics.checkNotNull(jsExpression2);
        return new JsInvocation(jsExpression, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression2));
    }
}

