/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import ksp.org.jetbrains.kotlin.js.translate.context.Namer;
import ksp.org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ.\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0014H\u0014\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/callTranslator/DefaultFunctionCallCase;", "Lksp/org/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "buildDefaultCallWithDispatchReceiver", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "argumentsInfo", "Lksp/org/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "dispatchReceiver", "functionName", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsName;", "isNative", "", "hasSpreadOperator", "buildDefaultCallWithoutReceiver", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "callableDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "nativeSpreadFunWithDispatchOrExtensionReceiver", "bothReceivers", "Lksp/org/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "extensionReceiver", "noReceivers", "js.translator"})
public final class DefaultFunctionCallCase
extends FunctionCallCase {
    @NotNull
    public static final DefaultFunctionCallCase INSTANCE = new DefaultFunctionCallCase();

    private DefaultFunctionCallCase() {
    }

    private final JsExpression nativeSpreadFunWithDispatchOrExtensionReceiver(CallArgumentTranslator.ArgumentsInfo argumentsInfo, JsName functionName) {
        TemporaryConstVariable temporaryConstVariable = argumentsInfo.getCachedReceiver();
        Intrinsics.checkNotNull(temporaryConstVariable);
        TemporaryConstVariable cachedReceiver = temporaryConstVariable;
        JsNameRef jsNameRef = Namer.getFunctionApplyRef(new JsNameRef(functionName, cachedReceiver.assignmentExpression()));
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "getFunctionApplyRef(...)");
        JsNameRef functionCallRef = jsNameRef;
        return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithDispatchReceiver(@NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull JsExpression dispatchReceiver, @NotNull JsName functionName, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkNotNullParameter(argumentsInfo, "argumentsInfo");
        Intrinsics.checkNotNullParameter(dispatchReceiver, "dispatchReceiver");
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        if (isNative && hasSpreadOperator) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver(argumentsInfo, functionName);
        }
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(functionName, dispatchReceiver), argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithoutReceiver(@NotNull TranslationContext context2, @NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull CallableDescriptor callableDescriptor, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(argumentsInfo, "argumentsInfo");
        Intrinsics.checkNotNullParameter(callableDescriptor, "callableDescriptor");
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(callableDescriptor, context2);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsValueReference(...)");
        JsExpression functionRef = jsExpression;
        if (isNative && hasSpreadOperator) {
            JsNameRef jsNameRef = Namer.getFunctionApplyRef(functionRef);
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "getFunctionApplyRef(...)");
            JsNameRef functionCallRef = jsNameRef;
            return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
        }
        return new JsInvocation(functionRef, argumentsInfo.getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression noReceivers(@NotNull FunctionCallInfo $this$noReceivers) {
        Intrinsics.checkNotNullParameter($this$noReceivers, "<this>");
        return this.buildDefaultCallWithoutReceiver($this$noReceivers.getContext(), $this$noReceivers.getArgumentsInfo(), CallInfoExtensionsKt.getCallableDescriptor($this$noReceivers), CallInfoExtensionsKt.isNative($this$noReceivers), CallInfoExtensionsKt.hasSpreadOperator($this$noReceivers));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$dispatchReceiver, "<this>");
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$dispatchReceiver.getArgumentsInfo();
        JsExpression jsExpression = $this$dispatchReceiver.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        return this.buildDefaultCallWithDispatchReceiver(argumentsInfo, jsExpression, CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver), CallInfoExtensionsKt.isNative($this$dispatchReceiver), CallInfoExtensionsKt.hasSpreadOperator($this$dispatchReceiver));
    }

    @Override
    @NotNull
    protected JsExpression extensionReceiver(@NotNull FunctionCallInfo $this$extensionReceiver) {
        Intrinsics.checkNotNullParameter($this$extensionReceiver, "<this>");
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver) && CallInfoExtensionsKt.hasSpreadOperator($this$extensionReceiver)) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver($this$extensionReceiver.getArgumentsInfo(), CallInfoExtensionsKt.getFunctionName($this$extensionReceiver));
        }
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver)) {
            return new JsInvocation((JsExpression)new JsNameRef(CallInfoExtensionsKt.getFunctionName($this$extensionReceiver), $this$extensionReceiver.getExtensionReceiver()), $this$extensionReceiver.getArgumentsInfo().getTranslateArguments());
        }
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(CallInfoExtensionsKt.getCallableDescriptor($this$extensionReceiver), $this$extensionReceiver.getContext());
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsValueReference(...)");
        JsExpression functionRef = jsExpression;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$extensionReceiver.getArgumentsInfo();
        JsExpression jsExpression2 = $this$extensionReceiver.getExtensionReceiver();
        Intrinsics.checkNotNull(jsExpression2);
        return new JsInvocation(functionRef, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression2));
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $this$bothReceivers) {
        Intrinsics.checkNotNullParameter($this$bothReceivers, "<this>");
        JsName jsName = CallInfoExtensionsKt.getFunctionName($this$bothReceivers);
        JsExpression jsExpression = $this$bothReceivers.getDispatchReceiver();
        Intrinsics.checkNotNull(jsExpression);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(jsName, jsExpression);
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "pureFqn(...)");
        JsNameRef functionRef = jsNameRef;
        JsExpression jsExpression2 = functionRef;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$bothReceivers.getArgumentsInfo();
        JsExpression jsExpression3 = $this$bothReceivers.getExtensionReceiver();
        Intrinsics.checkNotNull(jsExpression3);
        return new JsInvocation(jsExpression2, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression3));
    }
}

