/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtValueArgument;
import ksp.org.jetbrains.kotlin.psi.KtValueArgumentList;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.types.DynamicTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\bH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002J$\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J$\u0010\u001b\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsExportDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "validateDeclarationOnConsumableName", "declarationDescriptor", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "getIdentifier", "Lksp/com/intellij/psi/PsiElement;", "getJsNameArgument", "getKotlinOrJsName", "", "isExportable", "", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "currentlyProcessed", "", "isExportableReturn", "js.frontend"})
public final class JsExportDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExportDeclarationChecker INSTANCE = new JsExportDeclarationChecker();

    private JsExportDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean hasJsName;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        BindingTrace trace = context2.getTrace();
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (!AnnotationsUtils.isExportedObject(descriptor2, bindingContext2)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = hasJsName = AnnotationsUtils.getJsNameAnnotation(descriptor2) != null;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "expect");
        }
        this.validateDeclarationOnConsumableName(declaration2, descriptor2, trace);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            for (TypeParameterDescriptor typeParameter : ((FunctionDescriptor)descriptor2).getTypeParameters()) {
                Intrinsics.checkNotNull(typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(bindingContext2, trace, typeParameter);
            }
            if (InlineOnlyKt.isInlineWithReified((MemberDescriptor)descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "inline function with reified type parameters");
                return;
            }
            if (((FunctionDescriptor)descriptor2).isSuspend()) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "suspend function");
                return;
            }
            if (descriptor2 instanceof ConstructorDescriptor && !((ConstructorDescriptor)descriptor2).isPrimary() && !hasJsName) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "secondary constructor without @JsName");
            }
            if (!(descriptor2 instanceof PropertyAccessorDescriptor)) {
                for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)descriptor2).getValueParameters()) {
                    Intrinsics.checkNotNull(parameter2);
                    JsExportDeclarationChecker.check$checkValueParameter(bindingContext2, trace, parameter2);
                }
                KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
                if (kotlinType != null) {
                    KotlinType returnType2 = kotlinType;
                    boolean bl2 = false;
                    if (!JsExportDeclarationChecker.isExportableReturn$default(INSTANCE, returnType2, bindingContext2, null, 2, null)) {
                        trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "return", returnType2));
                    }
                }
            }
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            if (declaration2 instanceof KtParameter) {
                return;
            }
            if (DescriptorUtilsKt.isExtensionProperty(descriptor2)) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, "extension property");
                return;
            }
            KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (!JsExportDeclarationChecker.isExportable$default(this, kotlinType, bindingContext2, null, 2, null)) {
                trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(declaration2, "property", ((PropertyDescriptor)descriptor2).getType()));
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            String wrongDeclaration;
            for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)descriptor2).getDeclaredTypeParameters()) {
                Intrinsics.checkNotNull(typeParameter);
                JsExportDeclarationChecker.check$checkTypeParameter(bindingContext2, trace, typeParameter);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((ClassDescriptor)descriptor2).getKind().ordinal()]) {
                case 1: {
                    String string2 = "annotation class";
                    break;
                }
                case 2: {
                    String string2;
                    if (DescriptorUtilsKt.isInsideInterface(descriptor2)) {
                        string2 = "nested class inside exported interface";
                        break;
                    }
                    if (InlineClassesUtilsKt.isInlineClass(descriptor2)) {
                        string2 = (((ClassDescriptor)descriptor2).isInline() ? "inline " : "") + (((ClassDescriptor)descriptor2).isValue() ? "value " : "") + "class";
                        break;
                    }
                    string2 = null;
                    break;
                }
                default: {
                    String string2 = DescriptorUtilsKt.isInsideInterface(descriptor2) ? (((ClassDescriptor)descriptor2).isCompanionObject() ? "companion object" : "nested/inner declaration") + " inside exported interface" : (wrongDeclaration = null);
                }
            }
            if (wrongDeclaration != null) {
                JsExportDeclarationChecker.check$reportWrongExportedDeclaration(trace, declaration2, wrongDeclaration);
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
        }
    }

    private final boolean isExportableReturn(KotlinType $this$isExportableReturn, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        return TypeUtilsKt.isUnit($this$isExportableReturn) || this.isExportable($this$isExportableReturn, bindingContext, currentlyProcessed);
    }

    static /* synthetic */ boolean isExportableReturn$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportableReturn(kotlinType, bindingContext, set);
    }

    private final boolean isExportable(KotlinType $this$isExportable, BindingContext bindingContext, Set<KotlinType> currentlyProcessed) {
        boolean isPrimitiveExportableType;
        if (!currentlyProcessed.add($this$isExportable)) {
            return true;
        }
        currentlyProcessed.add($this$isExportable);
        if (FunctionTypesKt.isFunctionType($this$isExportable)) {
            int n = CollectionsKt.getLastIndex($this$isExportable.getArguments());
            for (int i = 0; i < n; ++i) {
                KotlinType kotlinType = $this$isExportable.getArguments().get(i).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
                currentlyProcessed.remove($this$isExportable);
                return false;
            }
            currentlyProcessed.remove($this$isExportable);
            KotlinType kotlinType = CollectionsKt.last($this$isExportable.getArguments()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            return this.isExportableReturn(kotlinType, bindingContext, currentlyProcessed);
        }
        for (TypeProjection argument2 : $this$isExportable.getArguments()) {
            KotlinType kotlinType = argument2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (this.isExportable(kotlinType, bindingContext, currentlyProcessed)) continue;
            currentlyProcessed.remove($this$isExportable);
            return false;
        }
        currentlyProcessed.remove($this$isExportable);
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable($this$isExportable);
        boolean bl = isPrimitiveExportableType = TypeUtilsKt.isAnyOrNullableAny(nonNullable) || TypeUtilsKt.isTypeParameter(nonNullable) || DynamicTypesKt.isDynamic(nonNullable) || TypeUtilsKt.isBoolean(nonNullable) || KotlinBuiltIns.isThrowableOrNullableThrowable(nonNullable) || KotlinBuiltIns.isString(nonNullable) || TypeUtilsKt.isPrimitiveNumberOrNullableType(nonNullable) && !TypeUtilsKt.isLong(nonNullable) || TypeUtilsKt.isNothingOrNullableNothing(nonNullable) || KotlinBuiltIns.isArray($this$isExportable) || KotlinBuiltIns.isPrimitiveArray($this$isExportable);
        if (isPrimitiveExportableType) {
            return true;
        }
        ClassifierDescriptor descriptor2 = $this$isExportable.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return false;
        }
        if (KotlinBuiltIns.isEnum($this$isExportable)) {
            return true;
        }
        return DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)descriptor2)) || AnnotationsUtils.isExportedObject(descriptor2, bindingContext);
    }

    static /* synthetic */ boolean isExportable$default(JsExportDeclarationChecker jsExportDeclarationChecker, KotlinType kotlinType, BindingContext bindingContext, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return jsExportDeclarationChecker.isExportable(kotlinType, bindingContext, set);
    }

    private final void validateDeclarationOnConsumableName(KtDeclaration declaration2, DeclarationDescriptor declarationDescriptor, BindingTrace trace) {
        if (!DescriptorUtilKt.isTopLevelInPackage(declarationDescriptor) || declarationDescriptor.getName().isSpecial()) {
            return;
        }
        String name2 = this.getKotlinOrJsName(declarationDescriptor);
        if (IdentifierPolicyKt.getSPECIAL_KEYWORDS().contains(name2) || !IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(name2) && Intrinsics.areEqual(NameSuggestion.Companion.sanitizeName(name2), name2)) {
            return;
        }
        PsiElement psiElement = this.getJsNameArgument(declarationDescriptor);
        if (psiElement == null) {
            psiElement = this.getIdentifier(declaration2);
        }
        PsiElement reportTarget = psiElement;
        trace.report(ErrorsJs.NON_CONSUMABLE_EXPORTED_IDENTIFIER.on(reportTarget, name2));
    }

    private final String getKotlinOrJsName(DeclarationDescriptor $this$getKotlinOrJsName) {
        String string2 = AnnotationsUtils.getJsName($this$getKotlinOrJsName);
        if (string2 == null) {
            String string3 = $this$getKotlinOrJsName.getName().getIdentifier();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getIdentifier(...)");
        }
        return string2;
    }

    private final PsiElement getIdentifier(KtDeclaration $this$getIdentifier) {
        Intrinsics.checkNotNull($this$getIdentifier, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
        PsiElement psiElement = ((KtNamedDeclaration)$this$getIdentifier).getNameIdentifier();
        Intrinsics.checkNotNull(psiElement);
        return psiElement;
    }

    private final PsiElement getJsNameArgument(DeclarationDescriptor $this$getJsNameArgument) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getJsNameAnnotation($this$getJsNameArgument);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor jsNameAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(jsNameAnnotation.getSource());
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
        Object object = ((KtAnnotationEntry)psiElement).getValueArgumentList();
        return object != null && (object = ((KtValueArgumentList)object).getArguments()) != null ? (KtValueArgument)CollectionsKt.first(object) : null;
    }

    private static final void check$checkTypeParameter(BindingContext bindingContext, BindingTrace trace, TypeParameterDescriptor descriptor2) {
        for (KotlinType upperBound : descriptor2.getUpperBounds()) {
            PsiElement typeParameterDeclaration;
            Intrinsics.checkNotNull(upperBound);
            if (JsExportDeclarationChecker.isExportable$default(INSTANCE, upperBound, bindingContext, null, 2, null)) continue;
            Intrinsics.checkNotNull(DescriptorToSourceUtils.descriptorToDeclaration(descriptor2));
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(typeParameterDeclaration, "upper bound", upperBound));
        }
    }

    private static final void check$checkValueParameter(BindingContext bindingContext, BindingTrace trace, ValueParameterDescriptor descriptor2) {
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        if (!JsExportDeclarationChecker.isExportable$default(INSTANCE, kotlinType, bindingContext, null, 2, null)) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            Intrinsics.checkNotNull(psiElement);
            PsiElement valueParameterDeclaration2 = psiElement;
            trace.report(ErrorsJs.NON_EXPORTABLE_TYPE.on(valueParameterDeclaration2, "parameter", descriptor2.getType()));
        }
    }

    private static final void check$reportWrongExportedDeclaration(BindingTrace trace, KtDeclaration $declaration, String kind) {
        trace.report(ErrorsJs.WRONG_EXPORTED_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

