/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.inline.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.js.backend.ast.HasName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsName;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNode;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"transitiveStaticRef", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "getTransitiveStaticRef", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCallerQualifier", "invocation", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsInvocation;", "getCallerQualifierImpl", "getSimpleIdent", "", "call", "getSimpleName", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsName;", "hasCallerQualifier", "", "isCallInvocation", "js.translator"})
public final class InvocationUtilsKt {
    @Nullable
    public static final JsName getSimpleName(@NotNull JsInvocation call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        JsExpression jsExpression = call2.getQualifier();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
        JsExpression qualifier2 = jsExpression;
        JsNameRef jsNameRef = qualifier2 instanceof JsNameRef ? (JsNameRef)qualifier2 : null;
        return jsNameRef != null ? jsNameRef.getName() : null;
    }

    @Nullable
    public static final String getSimpleIdent(@NotNull JsInvocation call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        JsExpression qualifier2 = call2.getQualifier();
        while (qualifier2 != null) {
            JsExpression jsExpression = qualifier2;
            if (jsExpression instanceof JsInvocation) {
                JsExpression callableQualifier = qualifier2;
                qualifier2 = ((JsInvocation)callableQualifier).getQualifier();
                if (!InvocationUtilsKt.isCallInvocation((JsInvocation)callableQualifier)) continue;
                JsExpression jsExpression2 = qualifier2;
                JsNameRef jsNameRef = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                qualifier2 = jsNameRef != null ? jsNameRef.getQualifier() : null;
                continue;
            }
            if (!(jsExpression instanceof HasName)) break;
            JsName jsName = ((HasName)((Object)qualifier2)).getName();
            return jsName != null ? jsName.getIdent() : null;
        }
        return null;
    }

    public static final boolean isCallInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        JsExpression jsExpression = invocation.getQualifier();
        JsNameRef qualifier2 = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        List<JsExpression> list2 = invocation.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
        List<JsExpression> arguments2 = list2;
        JsName jsName = InlineUtils.getName(qualifier2);
        if ((jsName != null ? MetadataProperties.getDescriptor(jsName) : null) != null) {
            return false;
        }
        JsNameRef jsNameRef = qualifier2;
        return Intrinsics.areEqual(jsNameRef != null ? jsNameRef.getIdent() : null, "call") && !((Collection)arguments2).isEmpty() && qualifier2.getQualifier() != null;
    }

    public static final boolean hasCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        return InvocationUtilsKt.getCallerQualifierImpl(invocation) != null;
    }

    @NotNull
    public static final JsExpression getCallerQualifier(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        JsExpression jsExpression = InvocationUtilsKt.getCallerQualifierImpl(invocation);
        if (jsExpression == null) {
            throw new AssertionError((Object)"must check hasQualifier() before calling getQualifier");
        }
        return jsExpression;
    }

    private static final JsExpression getCallerQualifierImpl(JsInvocation invocation) {
        JsExpression jsExpression = invocation.getQualifier();
        JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        return jsNameRef != null ? jsNameRef.getQualifier() : null;
    }

    @NotNull
    public static final JsExpression getTransitiveStaticRef(@NotNull JsExpression $this$transitiveStaticRef) {
        Intrinsics.checkNotNullParameter($this$transitiveStaticRef, "<this>");
        JsExpression qualifier2 = $this$transitiveStaticRef;
        while (true) {
            JsExpression jsExpression;
            JsNode jsNode;
            JsExpression jsExpression2;
            if ((jsExpression2 = qualifier2) instanceof JsNameRef) {
                JsName jsName = ((JsNameRef)qualifier2).getName();
                jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                jsExpression = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
                if (jsExpression == null) {
                    break;
                }
            } else {
                if (!(jsExpression2 instanceof JsInvocation)) break;
                JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier2);
                jsNode = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
                jsExpression = jsNode instanceof JsExpression ? (JsExpression)jsNode : null;
                if (jsExpression == null) break;
            }
            qualifier2 = jsExpression;
        }
        return qualifier2;
    }
}

