/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.config;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeys;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration;
import ksp.org.jetbrains.kotlin.config.LanguageVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import ksp.org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import ksp.org.jetbrains.kotlin.incremental.components.LookupTracker;
import ksp.org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import ksp.org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import ksp.org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import ksp.org.jetbrains.kotlin.resolve.TargetEnvironment;
import ksp.org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinJavaScriptLibraryParts;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragmentProviderKt;
import ksp.org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import ksp.org.jetbrains.kotlin.serialization.js.ModuleKind;
import ksp.org.jetbrains.kotlin.storage.LockBasedStorageManager;
import ksp.org.jetbrains.kotlin.utils.JsMetadataVersion;
import ksp.org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import ksp.org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import ksp.org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsConfig {
    public static final List<String> JS_STDLIB = Collections.singletonList(PathUtil.getKotlinPathsForDistDirectory().getJsStdLibKlibPath().getAbsolutePath());
    public static final List<String> JS_KOTLIN_TEST = Collections.singletonList(PathUtil.getKotlinPathsForDistDirectory().getJsKotlinTestKlibPath().getAbsolutePath());
    public static final String UNKNOWN_EXTERNAL_MODULE_NAME = "<unknown>";
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager;
    private final List<KotlinJavascriptMetadata> metadata;
    private final List<KotlinJavascriptMetadata> friends;
    private List<ModuleDescriptorImpl> moduleDescriptors;
    private List<ModuleDescriptorImpl> friendModuleDescriptors;
    private boolean initialized;
    @Nullable
    private final List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> metadataCache;
    @Nullable
    private final Set<String> librariesToSkip;
    public final TargetEnvironment targetEnvironment;
    private final IdentityHashMap<KotlinJavascriptMetadata, ModuleDescriptorImpl> factoryMap;

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull TargetEnvironment targetEnvironment) {
        if (project == null) {
            JsConfig.$$$reportNull$$$0(0);
        }
        if (configuration2 == null) {
            JsConfig.$$$reportNull$$$0(1);
        }
        if (targetEnvironment == null) {
            JsConfig.$$$reportNull$$$0(2);
        }
        this(project, configuration2, targetEnvironment, null, null);
    }

    public JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull TargetEnvironment targetEnvironment, @Nullable List<JsModuleDescriptor<KotlinJavaScriptLibraryParts>> metadataCache, @Nullable Set<String> librariesToSkip) {
        if (project == null) {
            JsConfig.$$$reportNull$$$0(3);
        }
        if (configuration2 == null) {
            JsConfig.$$$reportNull$$$0(4);
        }
        if (targetEnvironment == null) {
            JsConfig.$$$reportNull$$$0(5);
        }
        this.storageManager = new LockBasedStorageManager("JsConfig");
        this.metadata = new SmartList<KotlinJavascriptMetadata>();
        this.friends = new SmartList<KotlinJavascriptMetadata>();
        this.initialized = false;
        this.factoryMap = new IdentityHashMap();
        this.project = project;
        this.configuration = configuration2.copy();
        this.targetEnvironment = targetEnvironment;
        this.metadataCache = metadataCache;
        this.librariesToSkip = librariesToSkip;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            JsConfig.$$$reportNull$$$0(6);
        }
        return compilerConfiguration;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            JsConfig.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string2 = this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
        if (string2 == null) {
            JsConfig.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        if (moduleKind == null) {
            JsConfig.$$$reportNull$$$0(9);
        }
        return moduleKind;
    }

    @NotNull
    public List<String> getLibraries() {
        List<String> list2 = this.getConfiguration().getList(JSConfigurationKeys.LIBRARIES);
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public String getSourceMapPrefix() {
        String string2 = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_PREFIX, "");
        if (string2 == null) {
            JsConfig.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public List<String> getSourceMapRoots() {
        List<String> list2 = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, Collections.emptyList());
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public boolean shouldGenerateRelativePathsInSourceMap() {
        return this.getSourceMapPrefix().isEmpty() && this.getSourceMapRoots().isEmpty();
    }

    @NotNull
    public SourceMapSourceEmbedding getSourceMapContentEmbedding() {
        SourceMapSourceEmbedding sourceMapSourceEmbedding = this.configuration.get(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, SourceMapSourceEmbedding.INLINING);
        if (sourceMapSourceEmbedding == null) {
            JsConfig.$$$reportNull$$$0(13);
        }
        return sourceMapSourceEmbedding;
    }

    @NotNull
    public List<String> getFriends() {
        if (this.getConfiguration().getBoolean(JSConfigurationKeys.FRIEND_PATHS_DISABLED)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JsConfig.$$$reportNull$$$0(14);
            }
            return list2;
        }
        List<String> list3 = this.getConfiguration().getList(JSConfigurationKeys.FRIEND_PATHS);
        if (list3 == null) {
            JsConfig.$$$reportNull$$$0(15);
        }
        return list3;
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
        if (languageVersionSettings2 == null) {
            JsConfig.$$$reportNull$$$0(16);
        }
        return languageVersionSettings2;
    }

    public boolean isAtLeast(@NotNull LanguageVersion expected) {
        LanguageVersion actual;
        if (expected == null) {
            JsConfig.$$$reportNull$$$0(17);
        }
        return (actual = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration).getLanguageVersion()).getMajor() > expected.getMajor() || actual.getMajor() == expected.getMajor() && actual.getMinor() >= expected.getMinor();
    }

    public boolean checkLibFilesAndReportErrors(@NotNull Reporter report2) {
        if (report2 == null) {
            JsConfig.$$$reportNull$$$0(18);
        }
        return this.checkLibFilesAndReportErrors(this.getLibraries(), report2);
    }

    private boolean checkLibFilesAndReportErrors(@NotNull Collection<String> libraries, @NotNull Reporter report2) {
        if (libraries == null) {
            JsConfig.$$$reportNull$$$0(19);
        }
        if (report2 == null) {
            JsConfig.$$$reportNull$$$0(20);
        }
        if (libraries.isEmpty()) {
            return false;
        }
        HashSet<String> modules = new HashSet<String>();
        boolean skipMetadataVersionCheck2 = this.getLanguageVersionSettings().getFlag(AnalysisFlags.getSkipMetadataVersionCheck());
        for (String path : libraries) {
            if (this.librariesToSkip != null && this.librariesToSkip.contains(path)) continue;
            File filePath2 = new File(path);
            if (!filePath2.exists()) {
                report2.error("Path '" + path + "' does not exist");
                return true;
            }
            List<KotlinJavascriptMetadata> metadataList = KotlinJavascriptMetadataUtils.loadMetadata(path);
            if (metadataList.isEmpty()) {
                report2.warning("'" + path + "' is not a valid Kotlin Javascript library");
                continue;
            }
            LinkedHashSet<String> moduleNames = new LinkedHashSet<String>();
            for (KotlinJavascriptMetadata metadata : metadataList) {
                if (!metadata.getVersion().isCompatibleWithCurrentCompilerVersion() && !skipMetadataVersionCheck2) {
                    report2.error("File '" + path + "' was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + metadata.getVersion() + ", expected version is " + JsMetadataVersion.INSTANCE);
                    return true;
                }
                moduleNames.add(metadata.getModuleName());
            }
            for (String moduleName : moduleNames) {
                if (modules.add(moduleName)) continue;
                report2.warning("Module \"" + moduleName + "\" is defined in more than one file");
            }
            if (modules.contains(this.getModuleId())) {
                report2.warning("Module \"" + this.getModuleId() + "\" depends on module with the same name");
            }
            HashSet<String> friendLibsSet = new HashSet<String>(this.getFriends());
            this.metadata.addAll(metadataList);
            if (!friendLibsSet.contains(path)) continue;
            this.friends.addAll(metadataList);
        }
        this.initialized = true;
        return false;
    }

    @NotNull
    public List<ModuleDescriptorImpl> getModuleDescriptors() {
        this.init();
        List<ModuleDescriptorImpl> list2 = this.moduleDescriptors;
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private List<ModuleDescriptorImpl> createModuleDescriptors() {
        SmartList<ModuleDescriptorImpl> moduleDescriptors = new SmartList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            moduleDescriptors.add(this.createModuleDescriptor(kotlinJavascriptMetadata));
        }
        if (this.metadataCache != null) {
            LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
            for (JsModuleDescriptor<KotlinJavaScriptLibraryParts> jsModuleDescriptor : this.metadataCache) {
                ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + jsModuleDescriptor.getName() + ">"), this.storageManager, JsPlatformAnalyzerServices.INSTANCE.getBuiltIns());
                KotlinJavaScriptLibraryParts parts2 = jsModuleDescriptor.getData();
                PackageFragmentProvider provider2 = KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(this.storageManager, moduleDescriptor, parts2.getHeader(), parts2.getBody(), parts2.getMetadataVersion(), new CompilerDeserializationConfiguration(languageVersionSettings2), LookupTracker.DO_NOTHING.INSTANCE);
                moduleDescriptor.initialize(provider2);
                moduleDescriptors.add(moduleDescriptor);
            }
        }
        for (ModuleDescriptorImpl moduleDescriptorImpl : moduleDescriptors) {
            JsConfig.setDependencies(moduleDescriptorImpl, moduleDescriptors);
        }
        List<ModuleDescriptorImpl> list2 = Collections.unmodifiableList(moduleDescriptors);
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    public List<ModuleDescriptorImpl> getFriendModuleDescriptors() {
        this.init();
        List<ModuleDescriptorImpl> list2 = this.friendModuleDescriptors;
        if (list2 == null) {
            JsConfig.$$$reportNull$$$0(23);
        }
        return list2;
    }

    public void init() {
        if (!this.initialized) {
            Reporter reporter = new Reporter(){

                @Override
                public void error(@NotNull String message2) {
                    if (message2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    throw new IllegalStateException(message2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "ksp/org/jetbrains/kotlin/js/config/JsConfig$1", "error"));
                }
            };
            this.checkLibFilesAndReportErrors(reporter);
        }
        if (this.moduleDescriptors == null) {
            this.moduleDescriptors = this.createModuleDescriptors();
        }
        if (this.friendModuleDescriptors == null) {
            this.friendModuleDescriptors = CollectionsKt.map(this.friends, this::createModuleDescriptor);
        }
    }

    private ModuleDescriptorImpl createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        return this.factoryMap.computeIfAbsent(metadata, m -> {
            LanguageVersionSettings languageVersionSettings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration);
            assert (m.getVersion().isCompatibleWithCurrentCompilerVersion() || languageVersionSettings2.getFlag(AnalysisFlags.getSkipMetadataVersionCheck()).booleanValue()) : "Expected JS metadata version " + JsMetadataVersion.INSTANCE + ", but actual metadata version is " + m.getVersion();
            ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + m.getModuleName() + ">"), this.storageManager, JsPlatformAnalyzerServices.INSTANCE.getBuiltIns());
            LookupTracker lookupTracker = this.configuration.get(CommonConfigurationKeys.LOOKUP_TRACKER, LookupTracker.DO_NOTHING.INSTANCE);
            KotlinJavaScriptLibraryParts parts2 = KotlinJavascriptSerializationUtil.readModuleAsProto(m.getBody(), m.getVersion());
            PackageFragmentProvider provider2 = KotlinJavascriptPackageFragmentProviderKt.createKotlinJavascriptPackageFragmentProvider(this.storageManager, moduleDescriptor, parts2.getHeader(), parts2.getBody(), m.getVersion(), new CompilerDeserializationConfiguration(languageVersionSettings2), lookupTracker);
            moduleDescriptor.initialize(provider2);
            return moduleDescriptor;
        });
    }

    private static void setDependencies(ModuleDescriptorImpl module2, List<ModuleDescriptorImpl> modules) {
        module2.setDependencies(CollectionsKt.plus(modules, JsPlatformAnalyzerServices.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/config/JsConfig";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/config/JsConfig";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapPrefix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapContentEmbedding";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFriends";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageVersionSettings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDescriptors";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleDescriptors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFriendModuleDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkLibFilesAndReportErrors";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Reporter {
        public void error(@NotNull String message2) {
            if (message2 == null) {
                Reporter.$$$reportNull$$$0(0);
            }
        }

        public void warning(@NotNull String message2) {
            if (message2 == null) {
                Reporter.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "ksp/org/jetbrains/kotlin/js/config/JsConfig$Reporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warning";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

