/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.backend;

import ksp.org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsConditional;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsFunction;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNew;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNode;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.annotations.NotNull;

class JsPrecedenceVisitor
extends JsVisitor {
    static final int PRECEDENCE_NEW = 15;
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression2) {
        JsPrecedenceVisitor visitor2 = new JsPrecedenceVisitor();
        visitor2.accept(expression2);
        if (visitor2.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor2.answer;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(0);
        }
        this.answer = 16;
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(1);
        }
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(2);
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(@NotNull JsBooleanLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(3);
        }
        this.answer = 17;
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(4);
        }
        this.answer = 3;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(5);
        }
        this.answer = 17;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(6);
        }
        this.answer = 16;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(7);
        }
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(8);
        }
        this.answer = 15;
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(9);
        }
        this.answer = 17;
    }

    @Override
    public void visitInt(@NotNull JsIntLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(10);
        }
        this.answer = 17;
    }

    @Override
    public void visitDouble(@NotNull JsDoubleLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(11);
        }
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(12);
        }
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(13);
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(14);
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(15);
        }
        this.answer = 17;
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(16);
        }
        this.answer = 17;
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(17);
        }
        this.answer = 17;
    }

    @Override
    public void visitThis(@NotNull JsThisRef x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(18);
        }
        this.answer = 17;
    }

    @Override
    public void visitSuper(@NotNull JsSuperRef x) {
        if (x == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(19);
        }
        this.answer = 17;
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        if (node == null) {
            JsPrecedenceVisitor.$$$reportNull$$$0(20);
        }
        throw new RuntimeException("Only expressions have precedence.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "ksp/org/jetbrains/kotlin/js/backend/JsPrecedenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBoolean";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditional";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameRef";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNew";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNull";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInt";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDouble";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectLiteral";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixOperation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixOperation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPropertyInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRegExp";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThis";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuper";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

