/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.interpreter.Instruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import ksp.org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.Complex;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.State;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf;", "Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnumClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "getEnumEntryByName", "Lksp/org/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "getListOfAcceptableFunctions", "", "", "unwind", "Lksp/org/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIntrinsicImplementations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrinsicImplementations.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n798#2,11:370\n659#2,11:381\n*S KotlinDebug\n*F\n+ 1 IntrinsicImplementations.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf\n*L\n132#1:370,11\n132#1:381,11\n*E\n"})
public final class EnumValueOf
extends IntrinsicBase {
    @NotNull
    public static final EnumValueOf INSTANCE = new EnumValueOf();

    private EnumValueOf() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf("kotlin.enumValueOf");
    }

    private final IrClass getEnumClass(IrFunction irFunction, IrInterpreterEnvironment environment) {
        IrClass irClass;
        if (Intrinsics.areEqual(UtilsKt.getFqName(irFunction), "kotlin.enumValueOf")) {
            State state = environment.getCallStack$ir_interpreter().loadState(CollectionsKt.first(irFunction.getTypeParameters()).getSymbol());
            Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kType = (KTypeState)state;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull(irClassSymbol);
            irClass = (IrClass)irClassSymbol.getOwner();
        } else {
            IrDeclarationParent irDeclarationParent = irFunction.getParent();
            Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            irClass = (IrClass)irDeclarationParent;
        }
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrEnumEntry getEnumEntryByName(IrFunction irFunction, IrInterpreterEnvironment environment) {
        Object v0;
        String enumEntryName;
        IrClass enumClass2;
        block4: {
            void $this$singleOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            enumClass2 = this.getEnumClass(irFunction, environment);
            enumEntryName = StateKt.asString(environment.getCallStack$ir_interpreter().loadState(CollectionsKt.first(irFunction.getValueParameters()).getSymbol()));
            Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrEnumEntry it = (IrEnumEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), enumEntryName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrEnumEntry enumEntry = v0;
        if (enumEntry == null) {
            ExceptionUtilsKt.handleUserException(new IllegalArgumentException("No enum constant " + UtilsKt.getFqName(enumClass2) + '.' + enumEntryName), environment);
        }
        return enumEntry;
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        IrEnumEntry irEnumEntry = this.getEnumEntryByName(irFunction, environment);
        if (irEnumEntry == null) {
            return CollectionsKt.emptyList();
        }
        IrEnumEntry enumEntry = irEnumEntry;
        return CollectionsKt.plus((Collection)super.unwind(irFunction, environment), new SimpleInstruction(enumEntry));
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        IrEnumEntry irEnumEntry = this.getEnumEntryByName(irFunction, environment);
        Intrinsics.checkNotNull(irEnumEntry);
        IrEnumEntry enumEntry = irEnumEntry;
        CallStack callStack = environment.getCallStack$ir_interpreter();
        Complex complex = environment.getMapOfEnums$ir_interpreter().get(enumEntry.getSymbol());
        Intrinsics.checkNotNull(complex);
        callStack.pushState(complex);
    }
}

