/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.Instruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.State;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/AssertIntrinsic;", "Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "", "unwind", "Lksp/org/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class AssertIntrinsic
extends IntrinsicBase {
    @NotNull
    public static final AssertIntrinsic INSTANCE = new AssertIntrinsic();

    private AssertIntrinsic() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf("kotlin.PreconditionsKt.assert");
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        if (irFunction.getValueParameters().size() == 1) {
            return super.unwind(irFunction, environment);
        }
        IrValueParameter lambdaParameter = CollectionsKt.last(irFunction.getValueParameters());
        State state = environment.getCallStack$ir_interpreter().loadState(lambdaParameter.getSymbol());
        Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState");
        KFunctionState lambdaState = (KFunctionState)state;
        IrFunction irFunction2 = lambdaState.getInvokeSymbol().getOwner();
        Intrinsics.checkNotNull(irFunction2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        IrCall call2 = IrTreeBuildUtilsKt.createCall$default((IrSimpleFunction)irFunction2, null, 1, null);
        call2.setDispatchReceiver(IrTreeBuildUtilsKt.createGetValue(lambdaParameter));
        return CollectionsKt.plus((Collection)super.unwind(irFunction, environment), new CompoundInstruction(call2));
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(environment, "environment");
        boolean value2 = StateKt.asBoolean(environment.getCallStack$ir_interpreter().loadState(CollectionsKt.first(irFunction.getValueParameters()).getSymbol()));
        if (value2) {
            return;
        }
        switch (irFunction.getValueParameters().size()) {
            case 1: {
                ExceptionUtilsKt.handleUserException((Throwable)((Object)new AssertionError((Object)"Assertion failed")), environment);
                break;
            }
            case 2: {
                ExceptionUtilsKt.handleUserException((Throwable)((Object)new AssertionError((Object)StateKt.asString(environment.getCallStack$ir_interpreter().popState()))), environment);
            }
        }
    }
}

