/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.kotlin.builtins.PrimitiveType;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.Common;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.State;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import ksp.org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import ksp.org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import ksp.org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.ir.util.SymbolRemapper;
import ksp.org.jetbrains.kotlin.ir.util.TypeRemapper;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.FqNameUnsafe;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0086\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0013H\u0000\u001a\f\u0010 \u001a\u00020\u0013*\u00020!H\u0000\u001a\u0016\u0010\"\u001a\u00020\u0013*\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020$H\u0000\u001a\f\u0010%\u001a\u00020\u000e*\u00020\u001eH\u0000\u001a\u0012\u0010&\u001a\u00020'*\u00020(2\u0006\u0010)\u001a\u00020\u0001\u001a2\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010,0+*\u00020\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020+H\u0000\u001a\f\u00103\u001a\u00020\u000e*\u00020\u0019H\u0000\u001a&\u00104\u001a\u0004\u0018\u000105*\u0002062\u0006\u00107\u001a\u00020\u00192\u000e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090+H\u0000\u001a\u000e\u0010:\u001a\u0004\u0018\u00010;*\u00020\u0019H\u0000\u001a\u000e\u0010<\u001a\u0004\u0018\u00010\u000e*\u00020(H\u0000\u001a\u000e\u0010=\u001a\u0004\u0018\u00010;*\u00020\u0019H\u0000\u001a\n\u0010>\u001a\u00020\u0019*\u00020\u0019\u001a\f\u0010?\u001a\u00020\u0019*\u00020@H\u0000\u001a\n\u0010A\u001a\u00020\u0019*\u00020\u0019\u001a\f\u0010B\u001a\u00020\u000e*\u00020\u001eH\u0000\u001a\u0014\u0010C\u001a\u00020\t*\u00020D2\u0006\u0010E\u001a\u00020\u000eH\u0000\u001a\u000e\u0010F\u001a\u0004\u0018\u00010G*\u00020\u0019H\u0000\u001a\f\u0010H\u001a\u00020\u0019*\u00020DH\u0000\u001a\f\u0010I\u001a\u00020J*\u00020@H\u0000\u001a \u0010K\u001a\u00020\u001e*\u00020\u001e2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020\u001e0MH\u0000\u001a\u0014\u0010K\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010O\u001a\u00020PH\u0000\u001a\u0014\u0010Q\u001a\u0004\u0018\u00010\u001e*\u00020@2\u0006\u0010R\u001a\u00020S\u001a\u0014\u0010T\u001a\u00020\u0013*\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0001\u001a\f\u0010U\u001a\u00020\u0013*\u00020\u0019H\u0000\u001a\f\u0010V\u001a\u00020\u000e*\u00020DH\u0000\u001a\u000e\u0010W\u001a\u00020\u0013*\u0004\u0018\u000105H\u0000\u001a\f\u0010X\u001a\u00020\u0013*\u00020\u0019H\u0000\u001a\f\u0010Y\u001a\u00020\u0013*\u00020\u001eH\u0000\u001a\f\u0010Z\u001a\u00020\u0013*\u00020DH\u0000\u001a\f\u0010[\u001a\u00020\u0013*\u00020\u001eH\u0000\u001a \u0010\\\u001a\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020_0]*\u00020$2\u0006\u0010`\u001a\u00020@H\u0000\u001a\u000e\u0010a\u001a\u00020\u000e*\u0004\u0018\u00010,H\u0000\u001a\u001e\u0010b\u001a\b\u0012\u0004\u0012\u0002Hd0c\"\u0004\b\u0000\u0010d*\b\u0012\u0004\u0012\u0002Hd0eH\u0000\u001a \u0010f\u001a\u0006\u0012\u0002\b\u00030c*\n\u0012\u0006\u0012\u0004\u0018\u00010,0+2\u0006\u0010g\u001a\u00020\u001eH\u0000\u001a\u0014\u0010h\u001a\u00020i*\u00020j2\u0006\u0010k\u001a\u00020lH\u0000\u001a\f\u0010m\u001a\u00020\u000e*\u000202H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u001a\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t*\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t*\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u001a\u00a8\u0006n"}, d2={"compileTimeAnnotation", "Lksp/org/jetbrains/kotlin/name/FqName;", "getCompileTimeAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "evaluateIntrinsicAnnotation", "getEvaluateIntrinsicAnnotation", "intrinsicConstEvaluationAnnotation", "getIntrinsicConstEvaluationAnnotation", "correspondingProperty", "Lksp/org/jetbrains/kotlin/ir/declarations/IrProperty;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "getCorrespondingProperty", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "fqName", "", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "getFqName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "isConst", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "property", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "getProperty", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "asObject", "accessesTopLevelOrObjectField", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "checkCast", "environment", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "fqNameWithNullability", "getAnnotation", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "getArgsForMethodInvocation", "", "", "callInterceptor", "Lksp/org/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "methodType", "Ljava/lang/invoke/MethodType;", "args", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/State;", "getCapitalizedFileName", "getDefaultWithActualParameters", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "newParent", "actualParameters", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getDispatchReceiver", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getEvaluateIntrinsicValue", "getExtensionReceiver", "getFirstNonInterfaceOverridden", "getFunctionThatContainsDefaults", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getLastOverridden", "getOnlyName", "getOriginalPropertyByName", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "name", "getReceiver", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "getSingleAbstractMethod", "getThisReceiver", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getTypeIfReified", "getType", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "callStack", "Lksp/org/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getVarargType", "index", "", "hasAnnotation", "hasFunInterfaceParent", "internalName", "isAccessToNotNullableObject", "isAccessorOfPropertyWithBackingField", "isPrimitiveArray", "isSubclassOfThrowable", "isUnsignedArray", "loadReifiedTypeArguments", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "expression", "specialToStringForJs", "toPrimitive", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConst;", "toPrimitiveStateArray", "type", "toState", "Lksp/org/jetbrains/kotlin/ir/interpreter/state/Common;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "irBuiltIns", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "unsignedToString", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrSimpleTypeImpl.kt\norg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImplKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 8 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,372:1\n1745#2,3:373\n288#2,2:376\n223#2,2:378\n223#2,2:402\n1547#2:418\n1618#2,3:419\n764#2:423\n855#2,2:424\n1547#2:426\n1618#2,3:427\n798#2,11:430\n616#2,12:441\n798#2,11:453\n798#2,11:464\n1853#2,2:475\n1547#2:477\n1618#2,3:478\n123#3,2:380\n1247#3,2:386\n1313#3,2:388\n346#3,12:390\n37#4,2:382\n1#5:384\n126#6:385\n126#6:422\n25#7,13:404\n27#8:417\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n*L\n63#1:373,3\n69#1:376,2\n70#1:378,2\n246#1:402,2\n284#1:418\n284#1:419,3\n296#1:423\n296#1:424,2\n296#1:426\n296#1:427,3\n307#1:430,11\n307#1:441,12\n346#1:453,11\n354#1:464,11\n354#1:475,2\n241#1:477\n241#1:478,3\n100#1:380,2\n145#1:386,2\n161#1:388,2\n232#1:390,12\n123#1:382,2\n131#1:385\n290#1:422\n268#1:404,13\n268#1:417\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final FqName intrinsicConstEvaluationAnnotation = new FqName("kotlin.internal.IntrinsicConstEvaluation");
    @NotNull
    private static final FqName compileTimeAnnotation = new FqName("kotlin.CompileTimeCalculation");
    @NotNull
    private static final FqName evaluateIntrinsicAnnotation = new FqName("kotlin.EvaluateIntrinsic");

    @NotNull
    public static final FqName getIntrinsicConstEvaluationAnnotation() {
        return intrinsicConstEvaluationAnnotation;
    }

    @NotNull
    public static final FqName getCompileTimeAnnotation() {
        return compileTimeAnnotation;
    }

    @NotNull
    public static final FqName getEvaluateIntrinsicAnnotation() {
        return evaluateIntrinsicAnnotation;
    }

    @NotNull
    public static final String getFqName(@NotNull IrElement $this$fqName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$fqName, "<this>");
        Object object = $this$fqName instanceof IrDeclarationWithName ? (IrDeclarationWithName)$this$fqName : null;
        if ((object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null ? ((FqName)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiver, "<this>");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter($this$getExtensionReceiver, "<this>");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter($this$getReceiver, "<this>");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol != null ? (IrSymbol)irValueParameterSymbol : (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver);
    }

    @NotNull
    public static final IrValueSymbol getThisReceiver(@NotNull IrFunctionAccessExpression $this$getThisReceiver) {
        Intrinsics.checkNotNullParameter($this$getThisReceiver, "<this>");
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)$this$getThisReceiver.getSymbol()).getOwner()).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        return irValueParameter.getSymbol();
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Primitive<Object> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitive, "<this>");
        if (IrTypePredicatesKt.isByte($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive<Object>(((Number)t).byteValue(), $this$toPrimitive.getType());
        } else if (IrTypePredicatesKt.isShort($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive<Object>(((Number)t).shortValue(), $this$toPrimitive.getType());
        } else {
            primitive = new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
        }
        return primitive;
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        if ($this$hasAnnotation == null) {
            return false;
        }
        if (!((Collection)$this$hasAnnotation.getAnnotations()).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), annotation2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation2) {
        IrConstructorCall irConstructorCall2;
        Object v0;
        IrConstructorCall it;
        block3: {
            Intrinsics.checkNotNullParameter($this$getAnnotation, "<this>");
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), annotation2)) continue;
                v0 = element$iv2;
                break block3;
            }
            v0 = null;
        }
        if ((irConstructorCall2 = (IrConstructorCall)v0) == null) {
            Object element$iv2;
            block4: {
                IrDeclarationParent irDeclarationParent = ((IrFunction)$this$getAnnotation).getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                Iterable $this$first$iv = ((IrClass)irDeclarationParent).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), annotation2)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall2 = (IrConstructorCall)element$iv2;
        }
        return irConstructorCall2;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Intrinsics.checkNotNullParameter($this$getEvaluateIntrinsicValue, "<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && StringsKt.startsWith$default(UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue)), "java", false, 2, null)) {
            return UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue));
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation)) {
            return null;
        }
        IrExpression irExpression = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation).getValueArgument(0);
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        return String.valueOf(((IrConst)irExpression).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter(irType, "irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    @NotNull
    public static final IrFunction getFirstNonInterfaceOverridden(@NotNull IrFunction $this$getFirstNonInterfaceOverridden) {
        IrFunction element$iv;
        block4: {
            Intrinsics.checkNotNullParameter($this$getFirstNonInterfaceOverridden, "<this>");
            if (!($this$getFirstNonInterfaceOverridden instanceof IrSimpleFunction)) {
                return $this$getFirstNonInterfaceOverridden;
            }
            Sequence<IrFunction> $this$first$iv = SequencesKt.flattenSequenceOfIterable(SequencesKt.generateSequence(CollectionsKt.listOf($this$getFirstNonInterfaceOverridden), (Function1)getFirstNonInterfaceOverridden.1.INSTANCE));
            boolean $i$f$first = false;
            Iterator<IrFunction> iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                element$iv = iterator2.next();
                IrSimpleFunction overriddenFunction = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                if (overriddenFunction.isFakeOverride()) {
                    bl = false;
                } else {
                    IrClass irClass = IrUtilsKt.getParentClassOrNull(overriddenFunction);
                    ClassKind kind = irClass != null ? irClass.getKind() : null;
                    bl = kind != ClassKind.INTERFACE;
                }
                if (!bl) continue;
                break block4;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return element$iv;
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter($this$getLastOverridden, "<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return SequencesKt.last(SequencesKt.flattenSequenceOfIterable(SequencesKt.generateSequence(CollectionsKt.listOf($this$getLastOverridden), (Function1)getLastOverridden.1.INSTANCE)));
    }

    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n = 0;
            int n2 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                Object object = $this$toPrimitiveStateArray.get(n3);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                byArray[n3] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n = 0;
            int n4 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n4];
            while (n < n4) {
                int n5 = n++;
                Object object = $this$toPrimitiveStateArray.get(n5);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
                cArray[n5] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n6];
            while (n < n6) {
                int n7 = n++;
                Object object = $this$toPrimitiveStateArray.get(n7);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                sArray[n7] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n = 0;
            int n8 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n8];
            while (n < n8) {
                int n9 = n++;
                Object object = $this$toPrimitiveStateArray.get(n9);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                nArray[n9] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n = 0;
            int n10 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n10];
            while (n < n10) {
                int n11 = n++;
                Object object = $this$toPrimitiveStateArray.get(n11);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                lArray[n11] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n12];
            while (n < n12) {
                int n13 = n++;
                Object object = $this$toPrimitiveStateArray.get(n13);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                fArray[n13] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n = 0;
            int n14 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n14];
            while (n < n14) {
                int n15 = n++;
                Object object = $this$toPrimitiveStateArray.get(n15);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
                dArray[n15] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n = 0;
            int n16 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n16];
            while (n < n16) {
                int n17 = n++;
                Object object = $this$toPrimitiveStateArray.get(n17);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                blArray[n17] = (Boolean)object;
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive<boolean[]>(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Primitive<Object[]> primitive2 = new Primitive<Object[]>(thisCollection$iv.toArray(new Object[0]), type2);
            primitive = primitive2;
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index2) {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType type2;
        Intrinsics.checkNotNullParameter($this$getVarargType, "<this>");
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getVarargElementType();
        if (irType == null) {
            return null;
        }
        IrType varargType = irType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(varargType);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        }
        IrType it = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        IrSimpleType irSimpleType = it instanceof IrSimpleType ? (IrSimpleType)it : null;
        if (irSimpleType == null) {
            return null;
        }
        IrSimpleType $this$buildSimpleType$iv = type2 = irSimpleType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$getVarargType_u24lambda_u245 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(varargType).getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
        IrTypeParameter typeParameter = (IrTypeParameter)irSymbolOwner;
        IrType irType2 = $this$getVarargType.getTypeArgument(typeParameter.getIndex());
        Intrinsics.checkNotNull(irType2);
        $this$getVarargType_u24lambda_u245.setArguments(CollectionsKt.listOf(IrSimpleTypeImplKt.makeTypeProjection(irType2, Variance.OUT_VARIANCE)));
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter($this$getCapitalizedFileName, "<this>");
        Object object = IrUtilsKt.getFileOrNull($this$getCapitalizedFileName);
        if (object == null || (object = IrDeclarationsKt.getName((IrFile)object)) == null || (object = StringsKt.replace$default((String)object, ".kt", "Kt", false, 4, null)) == null || (object = CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object)) == null) {
            object = "<UNKNOWN>";
        }
        return object;
    }

    public static final boolean isSubclassOfThrowable(@NotNull IrClass $this$isSubclassOfThrowable) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isSubclassOfThrowable, "<this>");
            Sequence<IrClass> $this$any$iv = SequencesKt.generateSequence($this$isSubclassOfThrowable, (Function1)isSubclassOfThrowable.1.INSTANCE);
            boolean $i$f$any = false;
            Iterator<IrClass> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                IrClass element$iv;
                IrClass it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isThrowable(IrUtilsKt.getDefaultType(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        Intrinsics.checkNotNullParameter($this$isUnsignedArray, "<this>");
        if (!($this$isUnsignedArray instanceof IrSimpleType) || !(((IrSimpleType)$this$isUnsignedArray).getClassifier() instanceof IrClassSymbol)) {
            return false;
        }
        String[] stringArray = new String[]{"kotlin.UByteArray", "kotlin.UShortArray", "kotlin.UIntArray", "kotlin.ULongArray"};
        return SetsKt.setOf(stringArray).contains(UtilsKt.getFqName(((IrSimpleType)$this$isUnsignedArray).getClassifier().getOwner()));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "<this>");
        Object object = IrTypesKt.getClass($this$isPrimitiveArray);
        if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = StandardNames.isPrimitiveArray((FqNameUnsafe)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter($this$internalName, "<this>");
        StringBuilder internalName2 = new StringBuilder($this$internalName.getName().asString());
        Sequence<IrDeclarationParent> $this$forEach$iv = SequencesKt.drop(SequencesKt.generateSequence($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null, (Function1)internalName.1.INSTANCE), 1);
        boolean $i$f$forEach = false;
        Iterator<IrDeclarationParent> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            IrDeclarationParent element$iv;
            IrDeclarationParent it = element$iv = iterator2.next();
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName2.insert(0, ((IrClass)it).getName().asString() + '$');
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String it2 = string2 = ((IrPackageFragment)it).getPackageFqName().asString();
            boolean bl2 = false;
            Intrinsics.checkNotNull(it2);
            String string3 = ((CharSequence)it2).length() > 0 ? string2 : null;
            if (string3 == null) continue;
            it2 = string3;
            boolean bl3 = false;
            internalName2.insert(0, it2 + '.');
        }
        String string4 = internalName2.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        return string4;
    }

    public static final boolean checkCast(@Nullable IrFunction $this$checkCast, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        if ($this$checkCast == null) {
            return true;
        }
        IrType actualType = $this$checkCast.getReturnType();
        if (!(IrTypesKt.getClassifierOrNull(actualType) instanceof IrTypeParameterSymbol)) {
            return true;
        }
        State state = environment.getCallStack$ir_interpreter().loadState($this$checkCast.getSymbol());
        Object object = state instanceof KTypeState ? (KTypeState)state : null;
        if (object == null || (object = ((KTypeState)object).getIrType()) == null) {
            return true;
        }
        Object expectedType = object;
        if (IrTypesKt.getClassifierOrFail((IrType)expectedType) instanceof IrTypeParameterSymbol) {
            return true;
        }
        State state2 = environment.getCallStack$ir_interpreter().peekState();
        if (state2 == null) {
            return true;
        }
        State actualState = state2;
        if (actualState instanceof Primitive && ((Primitive)actualState).getValue() == null) {
            return true;
        }
        if (!StateKt.isSubtypeOf(actualState, (IrType)expectedType)) {
            String convertibleClassName = UtilsKt.getFqName(environment.getCallStack$ir_interpreter().popState().getIrClass());
            environment.getCallStack$ir_interpreter().dropFrame();
            ExceptionUtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render$default((IrType)expectedType, null, 1, null)), environment);
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull CallInterceptor callInterceptor, @NotNull MethodType methodType, @NotNull List<? extends State> args2) {
        Intrinsics.checkNotNullParameter($this$getArgsForMethodInvocation, "<this>");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        Intrinsics.checkNotNullParameter(methodType, "methodType");
        Intrinsics.checkNotNullParameter(args2, "args");
        List<Object> argsValues = CollectionsKt.toMutableList((Collection)ProxyKt.wrap(args2, callInterceptor, $this$getArgsForMethodInvocation, methodType));
        IrValueParameter irValueParameter = CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if ((irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null) {
            Object varargValue = CollectionsKt.last(argsValues);
            argsValues.remove(argsValues.size() - 1);
            Collection collection = argsValues;
            Intrinsics.checkNotNull(varargValue, "null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            CollectionsKt.addAll(collection, (Object[])varargValue);
        }
        return argsValues;
    }

    @NotNull
    public static final String fqNameWithNullability(@NotNull IrType $this$fqNameWithNullability) {
        Intrinsics.checkNotNullParameter($this$fqNameWithNullability, "<this>");
        Object object = IrTypesKt.getClassFqName($this$fqNameWithNullability);
        if (object == null || (object = ((FqName)object).toString()) == null) {
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$fqNameWithNullability);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            Object object2 = irSymbolOwner instanceof IrDeclarationWithName ? (IrDeclarationWithName)irSymbolOwner : null;
            if ((object2 != null && (object2 = object2.getName()) != null ? ((Name)object2).asString() : (object = null)) == null) {
                object = RenderIrElementKt.render$default($this$fqNameWithNullability, null, 1, null);
            }
        }
        Object object3 = object;
        Intrinsics.checkNotNull(object3);
        Object fqName2 = object3;
        String nullability2 = $this$fqNameWithNullability instanceof IrSimpleType && ((IrSimpleType)$this$fqNameWithNullability).getNullability() == SimpleTypeNullability.MARKED_NULLABLE ? "?" : "";
        return (String)fqName2 + nullability2;
    }

    @NotNull
    public static final String getOnlyName(@NotNull IrType $this$getOnlyName) {
        String string2;
        Intrinsics.checkNotNullParameter($this$getOnlyName, "<this>");
        if (!($this$getOnlyName instanceof IrSimpleType)) {
            return RenderIrElementKt.render$default($this$getOnlyName, null, 1, null);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail($this$getOnlyName).getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        StringBuilder stringBuilder3 = stringBuilder2.append(((IrDeclarationWithName)irSymbolOwner).getName().asString());
        switch (WhenMappings.$EnumSwitchMapping$1[((IrSimpleType)$this$getOnlyName).getNullability().ordinal()]) {
            case 1: {
                string2 = "?";
                break;
            }
            case 2: {
                string2 = "";
                break;
            }
            case 3: {
                if (IrTypesKt.getClassifierOrNull($this$getOnlyName) instanceof IrTypeParameterSymbol) {
                    string2 = " & Any";
                    break;
                }
                string2 = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringBuilder3.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean accessesTopLevelOrObjectField(@NotNull IrFieldAccessExpression $this$accessesTopLevelOrObjectField) {
        Intrinsics.checkNotNullParameter($this$accessesTopLevelOrObjectField, "<this>");
        if ($this$accessesTopLevelOrObjectField.getReceiver() == null) return true;
        Object object = $this$accessesTopLevelOrObjectField.getReceiver();
        IrSymbolOwner irSymbolOwner = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassifierOrNull((IrType)object)) != null ? object.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) return false;
        IrClass irClass = (IrClass)irSymbolOwner;
        if (irClass == null) return false;
        if (!IrUtilsKt.isObject(irClass)) return false;
        return true;
    }

    @NotNull
    public static final IrProperty getOriginalPropertyByName(@NotNull IrClass $this$getOriginalPropertyByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getOriginalPropertyByName, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties($this$getOriginalPropertyByName);
        boolean $i$f$single = false;
        IrProperty single$iv = null;
        boolean found$iv = false;
        Iterator<IrProperty> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrProperty element$iv;
            IrProperty it = element$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName().asString(), name2)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrProperty property = single$iv;
        IrSimpleFunction irSimpleFunction = property.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        IrProperty irProperty = UtilsKt.getProperty(UtilsKt.getLastOverridden(irSimpleFunction));
        Intrinsics.checkNotNull(irProperty);
        return irProperty;
    }

    @NotNull
    public static final IrFunction getFunctionThatContainsDefaults(@NotNull IrFunctionAccessExpression $this$getFunctionThatContainsDefaults) {
        int element$iv;
        IrFunction irFunction;
        block2: {
            Intrinsics.checkNotNullParameter($this$getFunctionThatContainsDefaults, "<this>");
            irFunction = ((IrFunctionSymbol)$this$getFunctionThatContainsDefaults.getSymbol()).getOwner();
            Iterable $this$first$iv = RangesKt.until(0, $this$getFunctionThatContainsDefaults.getValueArgumentsCount());
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                if (!($this$getFunctionThatContainsDefaults.getValueArgument(it) == null)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int it = element$iv;
        boolean bl = false;
        IrFunction irFunction2 = UtilsKt.getFunctionThatContainsDefaults$lookup(irFunction.getValueParameters().get(it));
        if (irFunction2 == null) {
            irFunction2 = irFunction;
        }
        return irFunction2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final IrExpression getDefaultWithActualParameters(@NotNull IrValueParameter $this$getDefaultWithActualParameters, @NotNull IrFunction newParent, @NotNull List<? extends IrValueDeclaration> actualParameters) {
        DeepCopyTypeRemapper typeRemapper$iv$iv;
        void $this$deepCopyWithSymbols$iv$iv;
        IrExpression expression2;
        Intrinsics.checkNotNullParameter($this$getDefaultWithActualParameters, "<this>");
        Intrinsics.checkNotNullParameter(newParent, "newParent");
        Intrinsics.checkNotNullParameter(actualParameters, "actualParameters");
        IrExpressionBody irExpressionBody = $this$getDefaultWithActualParameters.getDefaultValue();
        IrExpression irExpression = expression2 = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (expression2 instanceof IrConst) {
            return expression2;
        }
        IrDeclarationParent irDeclarationParent = $this$getDefaultWithActualParameters.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction parameterOwner = (IrFunction)irDeclarationParent;
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(parameterOwner, newParent, actualParameters){
            final /* synthetic */ IrFunction $parameterOwner;
            final /* synthetic */ IrFunction $newParent;
            final /* synthetic */ List<IrValueDeclaration> $actualParameters;
            {
                this.$parameterOwner = $parameterOwner;
                this.$newParent = $newParent;
                this.$actualParameters = $actualParameters;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                IrValueDeclaration irValueDeclaration;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueDeclaration irValueDeclaration2 = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = irValueDeclaration2 instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration2 : null;
                if (irValueParameter == null) {
                    return super.visitGetValue(expression2);
                }
                IrValueParameter parameter2 = irValueParameter;
                if (!Intrinsics.areEqual(parameter2.getParent(), this.$parameterOwner)) {
                    return super.visitGetValue(expression2);
                }
                if (parameter2.getIndex() == -1) {
                    IrValueParameter irValueParameter2 = this.$newParent.getDispatchReceiverParameter();
                    if (irValueParameter2 == null) {
                        irValueParameter2 = this.$newParent.getExtensionReceiverParameter();
                    }
                    irValueDeclaration = irValueParameter2;
                } else {
                    irValueDeclaration = this.$actualParameters.get(parameter2.getIndex());
                }
                IrValueDeclaration newParameter = irValueDeclaration;
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrType irType = expression2.getType();
                IrValueDeclaration irValueDeclaration3 = newParameter;
                Intrinsics.checkNotNull(irValueDeclaration3);
                return new IrGetValueImpl(n, n2, irType, irValueDeclaration3.getSymbol(), null, 16, null);
            }
        };
        IrExpression irExpression2 = expression2;
        IrExpression irExpression3 = irExpression2;
        if (irExpression2 == null) return null;
        IrElement $this$deepCopyWithSymbols_u24default$iv = irExpression3;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        boolean $i$f$deepCopyWithSymbols2 = false;
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
        DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        void var15_15 = $this$deepCopyWithSymbols$iv$iv;
        boolean bl = false;
        TypeRemapper typeRemapper = deepCopyTypeRemapper;
        SymbolRemapper p0 = deepCopySymbolRemapper;
        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var15_15.transform(new DeepCopyIrTreeWithSymbols(p0, typeRemapper), null), newParent);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        IrExpression irExpression4 = (IrExpression)((IrElement)((IrExpression)irElement2));
        irExpression3 = irExpression4;
        if (irExpression4 == null) return null;
        IrElement irElement3 = irExpression3.transform((IrElementTransformer)transformer2, (Object)null);
        return irElement3;
    }

    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull CallStack callStack) {
        Intrinsics.checkNotNullParameter($this$getTypeIfReified, "<this>");
        Intrinsics.checkNotNullParameter(callStack, "callStack");
        return UtilsKt.getTypeIfReified($this$getTypeIfReified, (Function1<? super IrClassifierSymbol, ? extends IrType>)new Function1<IrClassifierSymbol, IrType>(callStack){
            final /* synthetic */ CallStack $callStack;
            {
                this.$callStack = $callStack;
                super(1);
            }

            public final IrType invoke(IrClassifierSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                State state = this.$callStack.loadState(it);
                Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
                return ((KTypeState)state).getIrType();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull Function1<? super IrClassifierSymbol, ? extends IrType> getType2) {
        void $this$mapTo$iv$iv;
        IrSymbolOwner owner;
        Intrinsics.checkNotNullParameter($this$getTypeIfReified, "<this>");
        Intrinsics.checkNotNullParameter(getType2, "getType");
        if (!($this$getTypeIfReified instanceof IrSimpleType)) {
            return $this$getTypeIfReified;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$getTypeIfReified);
        IrSymbolOwner irSymbolOwner = owner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (owner instanceof IrTypeParameter && ((IrTypeParameter)owner).isReified()) {
            IrType irType = getType2.invoke(((IrTypeParameter)owner).getSymbol());
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            return IrTypesKt.mergeNullability((IrSimpleType)irType, $this$getTypeIfReified);
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$getTypeIfReified).getArguments();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            IrTypeArgument irTypeArgument2 = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) {
                irTypeArgument = it;
            } else {
                IrSymbolOwner typeOwner;
                IrType type2;
                IrClassifierSymbol irClassifierSymbol2 = IrTypesKt.getClassifierOrNull(type2);
                IrSymbolOwner irSymbolOwner2 = typeOwner = irClassifierSymbol2 != null ? irClassifierSymbol2.getOwner() : null;
                if (typeOwner instanceof IrTypeParameter && !((IrTypeParameter)typeOwner).isReified()) {
                    irTypeArgument = it;
                } else {
                    IrType irType = UtilsKt.getTypeIfReified(type2, getType2);
                    Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeArgument");
                    irTypeArgument = (IrTypeArgument)((Object)irType);
                }
            }
            collection.add(irTypeArgument);
        }
        List newArguments2 = (List)destination$iv$iv;
        IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)$this$getTypeIfReified;
        boolean $i$f$buildSimpleType = false;
        Object $this$getTypeIfReified_u24lambda_u2418 = object = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        ((IrSimpleTypeBuilder)$this$getTypeIfReified_u24lambda_u2418).setArguments(newArguments2);
        return IrSimpleTypeImplKt.buildSimpleType((IrSimpleTypeBuilder)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<IrTypeParameterSymbol, KTypeState> loadReifiedTypeArguments(@NotNull IrInterpreterEnvironment $this$loadReifiedTypeArguments, @NotNull IrFunctionAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        IrTypeParameter it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$loadReifiedTypeArguments, "<this>");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Iterable $this$filter$iv = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getTypeParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return ksp.org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((List)destination$iv$iv, (Function1)new Function1<IrTypeParameterSymbol, KTypeState>(expression2, $this$loadReifiedTypeArguments){
            final /* synthetic */ IrFunctionAccessExpression $expression;
            final /* synthetic */ IrInterpreterEnvironment $this_loadReifiedTypeArguments;
            {
                this.$expression = $expression;
                this.$this_loadReifiedTypeArguments = $receiver;
                super(1);
            }

            public final KTypeState invoke(IrTypeParameterSymbol it) {
                Intrinsics.checkNotNullParameter(it, "it");
                IrType irType = this.$expression.getTypeArgument(((IrTypeParameter)it.getOwner()).getIndex());
                Intrinsics.checkNotNull(irType);
                IrType reifiedType = UtilsKt.getTypeIfReified(irType, this.$this_loadReifiedTypeArguments.getCallStack$ir_interpreter());
                return new KTypeState(reifiedType, (IrClass)this.$this_loadReifiedTypeArguments.getKTypeClass$ir_interpreter().getOwner());
            }
        });
    }

    public static final boolean hasFunInterfaceParent(@NotNull IrFunction $this$hasFunInterfaceParent) {
        Intrinsics.checkNotNullParameter($this$hasFunInterfaceParent, "<this>");
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$hasFunInterfaceParent);
        return irClass != null ? irClass.isFun() : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrFunction getSingleAbstractMethod(@NotNull IrClass $this$getSingleAbstractMethod) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getSingleAbstractMethod, "<this>");
        Iterable $this$filterIsInstance$iv = $this$getSingleAbstractMethod.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.ABSTRACT)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (IrFunction)((Object)iterable);
    }

    public static final boolean isAccessToNotNullableObject(@Nullable IrExpression $this$isAccessToNotNullableObject) {
        boolean bl;
        IrExpression irExpression = $this$isAccessToNotNullableObject;
        if (irExpression instanceof IrGetObjectValue) {
            bl = !IrTypeUtilsKt.isNullable($this$isAccessToNotNullableObject.getType());
        } else if (irExpression instanceof IrGetValue) {
            IrClass expectedClass;
            IrValueDeclaration owner = ((IrGetValue)$this$isAccessToNotNullableObject).getSymbol().getOwner();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isAccessToNotNullableObject.getType());
            IrClass irClass = expectedClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            if (expectedClass == null || !IrUtilsKt.isObject(expectedClass) || IrTypeUtilsKt.isNullable($this$isAccessToNotNullableObject.getType())) {
                return false;
            }
            bl = Intrinsics.areEqual(owner.getOrigin(), IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER()) || Intrinsics.areEqual(owner.getName().asString(), "<this>");
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isAccessorOfPropertyWithBackingField(@NotNull IrFunction $this$isAccessorOfPropertyWithBackingField) {
        Intrinsics.checkNotNullParameter($this$isAccessorOfPropertyWithBackingField, "<this>");
        IrDeclarationBase irDeclarationBase = UtilsKt.getProperty($this$isAccessorOfPropertyWithBackingField);
        return (irDeclarationBase != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getBackingField()) != null ? ((IrField)irDeclarationBase).getInitializer() : null) != null;
    }

    @NotNull
    public static final String unsignedToString(@NotNull State $this$unsignedToString) {
        String string2;
        Intrinsics.checkNotNullParameter($this$unsignedToString, "<this>");
        Object t = CollectionsKt.single((Iterable)$this$unsignedToString.getFields().values());
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        Object value2 = ((Primitive)t).getValue();
        if (value2 instanceof Byte) {
            string2 = UByte.toString-impl(UByte.constructor-impl(((Number)value2).byteValue()));
        } else if (value2 instanceof Short) {
            string2 = UShort.toString-impl(UShort.constructor-impl(((Number)value2).shortValue()));
        } else if (value2 instanceof Integer) {
            string2 = Integer.toUnsignedString(UInt.constructor-impl(((Number)value2).intValue()));
        } else {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            string2 = Long.toUnsignedString(ULong.constructor-impl(((Number)value2).longValue()));
        }
        return string2;
    }

    @NotNull
    public static final String specialToStringForJs(@Nullable Object $this$specialToStringForJs) {
        return $this$specialToStringForJs instanceof Float && !Float.isInfinite(((Number)$this$specialToStringForJs).floatValue()) && Intrinsics.areEqual((float)Math.floor(((Number)$this$specialToStringForJs).floatValue()), (Float)$this$specialToStringForJs) ? String.valueOf((int)((Number)$this$specialToStringForJs).floatValue()) : ($this$specialToStringForJs instanceof Double && !Double.isInfinite(((Number)$this$specialToStringForJs).doubleValue()) && Intrinsics.areEqual(Math.floor(((Number)$this$specialToStringForJs).doubleValue()), (Double)$this$specialToStringForJs) ? String.valueOf((long)((Number)$this$specialToStringForJs).doubleValue()) : String.valueOf($this$specialToStringForJs));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Common toState(@NotNull IrEnumEntry $this$toState, @NotNull IrBuiltIns irBuiltIns) {
        Primitive[] $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toState, "<this>");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)$this$toState.getSymbol().getOwner());
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(t);
        }
        List enumEntries2 = (List)destination$iv$iv;
        IrClass irClass = $this$toState.getCorrespondingClass();
        if (irClass == null) {
            irClass = enumClass2;
        }
        Common enumClassObject = new Common(irClass);
        if (!((Collection)enumEntries2).isEmpty()) {
            void $this$filterIsInstanceTo$iv$iv2;
            $this$filterIsInstanceTo$iv$iv = new Primitive[]{new Primitive<String>($this$toState.getName().asString(), irBuiltIns.getStringType()), new Primitive<Integer>(enumEntries2.indexOf($this$toState), irBuiltIns.getIntType())};
            List<Primitive> valueArguments = CollectionsKt.listOf($this$filterIsInstanceTo$iv$iv);
            Iterable $this$filterIsInstance$iv2 = ((IrClass)irBuiltIns.getEnumClass().getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv2), (Iterable)valueArguments);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                IrProperty property = (IrProperty)pair.component1();
                Primitive argument2 = (Primitive)pair.component2();
                enumClassObject.setField(property.getSymbol(), argument2);
            }
        }
        return enumClassObject;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrFunction $this$property) {
        Intrinsics.checkNotNullParameter($this$property, "<this>");
        Object object = $this$property instanceof IrSimpleFunction ? (IrSimpleFunction)$this$property : null;
        return object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrField $this$property) {
        Intrinsics.checkNotNullParameter($this$property, "<this>");
        IrPropertySymbol irPropertySymbol = $this$property.getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getCorrespondingProperty(@NotNull IrCall $this$correspondingProperty) {
        Intrinsics.checkNotNullParameter($this$correspondingProperty, "<this>");
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$correspondingProperty.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    public static final boolean isConst(@Nullable IrProperty $this$isConst) {
        IrProperty irProperty = $this$isConst;
        return irProperty != null ? irProperty.isConst() : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrFunction getFunctionThatContainsDefaults$lookup(IrValueParameter $this$getFunctionThatContainsDefaults_u24lookup) {
        IrElementBase irElementBase;
        block6: {
            Object object;
            IrSimpleFunction irSimpleFunction;
            block7: {
                irElementBase = $this$getFunctionThatContainsDefaults_u24lookup.getDefaultValue();
                if (irElementBase == null) break block7;
                IrExpressionBody it = irElementBase;
                boolean bl = false;
                IrDeclarationParent irDeclarationParent = $this$getFunctionThatContainsDefaults_u24lookup.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                IrFunction irFunction = (IrFunction)irDeclarationParent;
                irElementBase = irFunction;
                if (irFunction != null) break block6;
            }
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = (object = $this$getFunctionThatContainsDefaults_u24lookup.getParent()) instanceof IrSimpleFunction ? (IrSimpleFunction)object : null;
            if (irSimpleFunction != null && (object = irSimpleFunction.getOverriddenSymbols()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$map = false;
                IrFunction irFunction = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((IrSimpleFunction)it.getOwner()).getValueParameters().get($this$getFunctionThatContainsDefaults_u24lookup.getIndex()));
                }
                for (IrValueParameter it : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    irFunction = UtilsKt.getFunctionThatContainsDefaults$lookup(it);
                    if (irFunction == null) continue;
                    irElementBase = irFunction;
                    break block6;
                }
                irElementBase = null;
            } else {
                irElementBase = null;
            }
        }
        return irElementBase;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

