/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"resolveToPackageOrClass", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "symbolProvider", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "fqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "semantics"})
@SourceDebugExtension(value={"SMAP\nImportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ImportUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1547#2:47\n1618#2,3:48\n*S KotlinDebug\n*F\n+ 1 ImportUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ImportUtilsKt\n*L\n29#1:47\n29#1:48,3\n*E\n"})
public final class ImportUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PackageResolutionResult resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider, @NotNull FqName fqName2) {
        void $this$mapTo$iv$iv;
        int prefixSize;
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        FqName currentPackage = fqName2;
        List<Name> list2 = fqName2.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list2, "pathSegments(...)");
        List<Name> pathSegments = list2;
        for (prefixSize = pathSegments.size(); !currentPackage.isRoot() && prefixSize > 0 && symbolProvider.getPackage(currentPackage) == null; --prefixSize) {
            Intrinsics.checkNotNullExpressionValue(currentPackage.parent(), "parent(...)");
        }
        if (Intrinsics.areEqual(currentPackage, fqName2)) {
            return new PackageResolutionResult.PackageOrClass(currentPackage, null, null);
        }
        Iterable $this$map$iv = RangesKt.until(prefixSize, pathSegments.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(pathSegments.get((int)it).asString());
        }
        FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(fqName3, "fromSegments(...)");
        FqName relativeClassFqName = fqName3;
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new PackageResolutionResult.Error(new ConeUnresolvedParentInImport(classId));
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        return new PackageResolutionResult.PackageOrClass(currentPackage, relativeClassFqName, symbol2);
    }
}

