/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.PreliminaryLoopVisitor;
import ksp.org.jetbrains.kotlin.fir.util.MultimapKt;
import ksp.org.jetbrains.kotlin.fir.util.SetMultimap;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor;
import ksp.org.jetbrains.kotlin.name.Name;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000*\u0001\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor;", "", "()V", "reassignedVariablesPerElement", "Lksp/org/jetbrains/kotlin/fir/util/SetMultimap;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/name/Name;", "visitor", "ksp/org/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor$visitor$1", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor$visitor$1;", "enterCapturingStatement", "", "statement", "exitCapturingStatement", "resetState", "", "resolve"})
public final class PreliminaryLoopVisitor {
    @NotNull
    private final SetMultimap<FirStatement, Name> reassignedVariablesPerElement = MultimapKt.setMultimapOf();
    @NotNull
    private final visitor.1 visitor = new FirVisitor<Unit, FirStatement>(this){
        final /* synthetic */ PreliminaryLoopVisitor this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitElement(FirElement element2, FirStatement data2) {
            Intrinsics.checkNotNullParameter(element2, "element");
            element2.acceptChildren(this, data2);
        }

        public void visitVariableAssignment(FirVariableAssignment variableAssignment, FirStatement data2) {
            FirNamedReference reference2;
            Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
            KtSourceElement ktSourceElement = variableAssignment.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DesugaredIncrementOrDecrement.INSTANCE)) {
                return;
            }
            if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                return;
            }
            Object object = FirExpressionUtilKt.getCalleeReference(variableAssignment);
            FirNamedReference firNamedReference = reference2 = object instanceof FirNamedReference ? (FirNamedReference)object : null;
            if (reference2 != null) {
                if (data2 == null) {
                    object = "Required value was null.";
                    throw new IllegalArgumentException(object.toString());
                }
                PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).put(data2, reference2.getName());
            }
            this.visitElement((FirElement)variableAssignment, data2);
        }

        public void visitWhileLoop(FirWhileLoop whileLoop, FirStatement data2) {
            Intrinsics.checkNotNullParameter(whileLoop, "whileLoop");
            this.visitCapturingStatement(whileLoop, data2);
        }

        public void visitDoWhileLoop(FirDoWhileLoop doWhileLoop, FirStatement data2) {
            Intrinsics.checkNotNullParameter(doWhileLoop, "doWhileLoop");
            this.visitCapturingStatement(doWhileLoop, data2);
        }

        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, FirStatement data2) {
            Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            this.visitCapturingStatement(anonymousFunction, data2);
        }

        public void visitSimpleFunction(FirSimpleFunction simpleFunction, FirStatement data2) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            this.visitCapturingStatement(simpleFunction, data2);
        }

        public void visitRegularClass(FirRegularClass regularClass, FirStatement data2) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            this.visitCapturingStatement(regularClass, data2);
        }

        public void visitAnonymousObject(FirAnonymousObject anonymousObject, FirStatement data2) {
            Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
            this.visitCapturingStatement(anonymousObject, data2);
        }

        private final void visitCapturingStatement(FirStatement statement2, FirStatement parent2) {
            this.visitElement((FirElement)statement2, statement2);
            if (parent2 != null) {
                PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).putAll(parent2, PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).get(statement2));
            }
        }
    };

    @NotNull
    public final Set<Name> enterCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statement2, "statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.reassignedVariablesPerElement.contains(statement2)) {
            statement2.accept(this.visitor, null);
        }
        return (Set)this.reassignedVariablesPerElement.get(statement2);
    }

    @NotNull
    public final Set<Name> exitCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statement2, "statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return (Set)this.reassignedVariablesPerElement.removeKey(statement2);
    }

    public final void resetState() {
        this.reassignedVariablesPerElement.clear();
    }

    public static final /* synthetic */ SetMultimap access$getReassignedVariablesPerElement$p(PreliminaryLoopVisitor $this) {
        return $this.reassignedVariablesPerElement;
    }
}

