/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import ksp.org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeAttribute;
import ksp.org.jetbrains.kotlin.fir.types.ConeCapturedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import ksp.org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeStubType;
import ksp.org.jetbrains.kotlin.fir.types.ConeStubTypeForChainInference;
import ksp.org.jetbrains.kotlin.fir.types.ConeStubTypeForSyntheticFixation;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import ksp.org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0018JA\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00182\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u0019\b\u0002\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\u0002\b\u001fH\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020 H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u001eH\u0002J\f\u0010!\u001a\u00020\u0013*\u00020\u0018H\u0014J\f\u0010\"\u001a\u00020#*\u00020\u0015H\u0002J\f\u0010$\u001a\u00020\u0013*\u00020\u0018H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "", "attributeRenderer", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;", "(Lorg/jetbrains/kotlin/fir/renderer/ConeAttributeRenderer;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuilder", "()Ljava/lang/StringBuilder;", "setBuilder", "(Ljava/lang/StringBuilder;)V", "idRenderer", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "getIdRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "setIdRenderer", "(Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;)V", "render", "", "flexibleType", "Lksp/org/jetbrains/kotlin/fir/types/ConeFlexibleType;", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderAsPossibleFunctionType", "functionClassKindExtractor", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "renderType", "Lksp/org/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lkotlin/ExtensionFunctionType;", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "renderAttributes", "renderForSameLookupTags", "", "renderNonCompilerAttributes", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,235:1\n764#2:236\n855#2,2:237\n188#3:239\n*S KotlinDebug\n*F\n+ 1 ConeTypeRenderer.kt\norg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer\n*L\n192#1:236\n192#1:237,2\n193#1:239\n*E\n"})
public class ConeTypeRenderer {
    @NotNull
    private final ConeAttributeRenderer attributeRenderer;
    public StringBuilder builder;
    public ConeIdRenderer idRenderer;

    public ConeTypeRenderer(@NotNull ConeAttributeRenderer attributeRenderer) {
        Intrinsics.checkNotNullParameter(attributeRenderer, "attributeRenderer");
        this.attributeRenderer = attributeRenderer;
    }

    public /* synthetic */ ConeTypeRenderer(ConeAttributeRenderer coneAttributeRenderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coneAttributeRenderer = ConeAttributeRenderer.ToString.INSTANCE;
        }
        this(coneAttributeRenderer);
    }

    @NotNull
    public final StringBuilder getBuilder() {
        StringBuilder stringBuilder2 = this.builder;
        if (stringBuilder2 != null) {
            return stringBuilder2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("builder");
        return null;
    }

    public final void setBuilder(@NotNull StringBuilder stringBuilder2) {
        Intrinsics.checkNotNullParameter(stringBuilder2, "<set-?>");
        this.builder = stringBuilder2;
    }

    @NotNull
    public final ConeIdRenderer getIdRenderer() {
        ConeIdRenderer coneIdRenderer = this.idRenderer;
        if (coneIdRenderer != null) {
            return coneIdRenderer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("idRenderer");
        return null;
    }

    public final void setIdRenderer(@NotNull ConeIdRenderer coneIdRenderer) {
        Intrinsics.checkNotNullParameter(coneIdRenderer, "<set-?>");
        this.idRenderer = coneIdRenderer;
    }

    public void renderAsPossibleFunctionType(@NotNull ConeKotlinType type2, @NotNull Function1<? super ConeKotlinType, ? extends FunctionTypeKind> functionClassKindExtractor, @NotNull Function1<? super ConeTypeProjection, Unit> renderType) {
        FunctionTypeKind kind;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(functionClassKindExtractor, "functionClassKindExtractor");
        Intrinsics.checkNotNullParameter(renderType, "renderType");
        FunctionTypeKind functionTypeKind = kind = functionClassKindExtractor.invoke(type2);
        if (!(functionTypeKind != null ? !functionTypeKind.isReflectType() : false)) {
            renderType.invoke(type2);
            return;
        }
        this.renderNonCompilerAttributes(type2);
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append("(");
        }
        String string2 = kind.getPrefixForTypeRender();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.getBuilder().append(it);
            this.getBuilder().append(" ");
        }
        ConeTypeProjection[] typeArguments2 = type2.getTypeArguments();
        boolean isExtension = CompilerConeAttributesKt.isExtensionFunctionType(type2);
        Pair<Object, List<ConeTypeProjection>> pair = isExtension && !Intrinsics.areEqual(ArraysKt.first(typeArguments2), ConeStarProjection.INSTANCE) ? TuplesKt.to(ArraysKt.first(typeArguments2), ArraysKt.drop(typeArguments2, 1)) : TuplesKt.to(null, ArraysKt.toList(typeArguments2));
        ConeTypeProjection receiver = pair.component1();
        List<ConeTypeProjection> otherTypeArguments = pair.component2();
        List<ConeTypeProjection> arguments2 = otherTypeArguments.subList(0, otherTypeArguments.size() - 1);
        ConeTypeProjection returnType2 = CollectionsKt.last(otherTypeArguments);
        if (receiver != null) {
            this.render(receiver);
            this.getBuilder().append(".");
        }
        this.getBuilder().append("(");
        Iterator<ConeTypeProjection> iterator2 = arguments2.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            ConeTypeProjection argument2 = iterator2.next();
            if (index2 != 0) {
                this.getBuilder().append(", ");
            }
            this.render(argument2);
        }
        this.getBuilder().append(") -> ");
        this.render(returnType2);
        if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
            this.getBuilder().append(")?");
        }
    }

    public static /* synthetic */ void renderAsPossibleFunctionType$default(ConeTypeRenderer coneTypeRenderer, ConeKotlinType coneKotlinType, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderAsPossibleFunctionType");
        }
        if ((n & 4) != 0) {
            function12 = new Function1<ConeTypeProjection, Unit>(coneTypeRenderer){
                final /* synthetic */ ConeTypeRenderer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ConeTypeProjection $this$null) {
                    Intrinsics.checkNotNullParameter($this$null, "$this$null");
                    ConeTypeRenderer.access$render(this.this$0, $this$null);
                }
            };
        }
        coneTypeRenderer.renderAsPossibleFunctionType(coneKotlinType, function1, function12);
    }

    public final void render(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ConeKotlinType coneKotlinType = AbbreviatedTypeAttributeKt.getAbbreviatedType(type2);
        if (coneKotlinType != null) {
            ConeKotlinType it = coneKotlinType;
            boolean bl = false;
            this.render(it);
            return;
        }
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeDefinitelyNotNullType)) {
            this.renderAttributes(type2);
        }
        if ((coneKotlinType = type2) instanceof ConeTypeVariableType) {
            this.getBuilder().append("TypeVariable(");
            this.getBuilder().append(((ConeTypeVariableType)type2).getTypeConstructor().getName());
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.render(((ConeDefinitelyNotNullType)type2).getOriginal());
            this.getBuilder().append(" & Any");
        } else if (coneKotlinType instanceof ConeErrorType) {
            this.getBuilder().append("ERROR CLASS: " + ((ConeErrorType)type2).getDiagnostic().getReason());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            this.getBuilder().append("CapturedType(");
            this.render(((ConeCapturedType)type2).getConstructor().getProjection());
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            this.render((ConeClassLikeType)type2);
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            this.getBuilder().append(((ConeLookupTagBasedType)type2).getLookupTag().getName().asString());
        } else if (coneKotlinType instanceof ConeDynamicType) {
            this.getBuilder().append("dynamic");
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            this.render((ConeFlexibleType)type2);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.getBuilder().append("it(");
            Iterator<ConeKotlinType> iterator2 = ((ConeIntersectionType)type2).getIntersectedTypes().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                ConeKotlinType intersected = iterator2.next();
                if (index2 > 0) {
                    this.getBuilder().append(" & ");
                }
                this.render(intersected);
            }
            this.getBuilder().append(")");
        } else if (coneKotlinType instanceof ConeStubTypeForSyntheticFixation) {
            this.getBuilder().append("Stub (fixation): " + ((ConeStubTypeForSyntheticFixation)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeStubTypeForChainInference) {
            this.getBuilder().append("Stub (chain inference): " + ((ConeStubTypeForChainInference)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeStubType) {
            this.getBuilder().append("Stub (subtyping): " + ((ConeStubType)type2).getConstructor().getVariable());
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            this.render((ConeIntegerLiteralType)type2);
        }
        if (!(type2 instanceof ConeFlexibleType) && !(type2 instanceof ConeErrorType)) {
            this.getBuilder().append(type2.getNullability().getSuffix());
        }
    }

    private final void render(ConeClassLikeType $this$render) {
        this.getIdRenderer().renderClassId($this$render.getLookupTag().getClassId());
        if ($this$render.getTypeArguments().length == 0) {
            return;
        }
        this.getBuilder().append("<");
        ConeTypeProjection[] coneTypeProjectionArray = $this$render.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (index2 > 0) {
                this.getBuilder().append(", ");
            }
            this.render(typeArgument);
        }
        this.getBuilder().append(">");
    }

    private final boolean renderForSameLookupTags(ConeFlexibleType $this$renderForSameLookupTags) {
        if ($this$renderForSameLookupTags.getLowerBound() instanceof ConeLookupTagBasedType && $this$renderForSameLookupTags.getUpperBound() instanceof ConeLookupTagBasedType && Intrinsics.areEqual(((ConeLookupTagBasedType)$this$renderForSameLookupTags.getLowerBound()).getLookupTag(), ((ConeLookupTagBasedType)$this$renderForSameLookupTags.getUpperBound()).getLookupTag()) && $this$renderForSameLookupTags.getLowerBound().getNullability() == ConeNullability.NOT_NULL && $this$renderForSameLookupTags.getUpperBound().getNullability() == ConeNullability.NULLABLE && (!($this$renderForSameLookupTags.getLowerBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getLowerBound().getTypeArguments().length == 0) && (!($this$renderForSameLookupTags.getUpperBound() instanceof ConeClassLikeType) || $this$renderForSameLookupTags.getUpperBound().getTypeArguments().length == 0)) {
            this.render($this$renderForSameLookupTags.getLowerBound());
            this.getBuilder().append("!");
            return true;
        }
        return false;
    }

    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter(flexibleType, "flexibleType");
        if (this.renderForSameLookupTags(flexibleType)) {
            return;
        }
        this.getBuilder().append("ft<");
        this.render(flexibleType.getLowerBound());
        this.getBuilder().append(", ");
        this.render(flexibleType.getUpperBound());
        this.getBuilder().append(">");
    }

    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter($this$renderAttributes, "<this>");
        if (!CollectionsKt.any($this$renderAttributes.getAttributes())) {
            return;
        }
        this.getBuilder().append(this.attributeRenderer.render($this$renderAttributes.getAttributes()));
    }

    /*
     * WARNING - void declaration
     */
    protected final void renderNonCompilerAttributes(@NotNull ConeKotlinType $this$renderNonCompilerAttributes) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$renderNonCompilerAttributes, "<this>");
        Map<KClass<ConeAttribute<?>>, ClassId> compilerAttributes = CompilerConeAttributes.INSTANCE.getClassIdByCompilerAttributeKey();
        Iterable $this$filter$iv = $this$renderNonCompilerAttributes.getAttributes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConeAttribute it = (ConeAttribute)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !compilerAttributes.containsKey(it.getKey());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$ifNotEmpty$iv = (List)destination$iv$iv;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$renderNonCompilerAttributes_u24lambda_u243 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            this.getBuilder().append(this.attributeRenderer.render($this$renderNonCompilerAttributes_u24lambda_u243));
        }
    }

    private final void render(ConeTypeProjection $this$render) {
        ConeTypeProjection coneTypeProjection = $this$render;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            this.getBuilder().append("*");
        } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
            this.getBuilder().append("CONFLICTING-PROJECTION ");
            this.render(((ConeKotlinTypeConflictingProjection)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            this.getBuilder().append("in ");
            this.render(((ConeKotlinTypeProjectionIn)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            this.getBuilder().append("out ");
            this.render(((ConeKotlinTypeProjectionOut)$this$render).getType());
        } else if (coneTypeProjection instanceof ConeKotlinType) {
            this.render((ConeKotlinType)$this$render);
        }
    }

    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ConeIntegerLiteralType coneIntegerLiteralType = type2;
        if (coneIntegerLiteralType instanceof ConeIntegerLiteralConstantType) {
            this.getBuilder().append("ILT: " + ((ConeIntegerLiteralConstantType)type2).getValue());
        } else if (coneIntegerLiteralType instanceof ConeIntegerConstantOperatorType) {
            this.getBuilder().append("IOT");
        }
    }

    public ConeTypeRenderer() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$render(ConeTypeRenderer $this, ConeTypeProjection $receiver) {
        $this.render($receiver);
    }
}

