/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceFile;
import ksp.org.jetbrains.kotlin.KtSourceFileLinesMapping;
import ksp.org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import ksp.org.jetbrains.kotlin.backend.common.actualizer.FakeOverrideRebuilder;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirModuleData;
import ksp.org.jetbrains.kotlin.fir.FirModuleDataKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.backend.CodeFragmentConversionData;
import ksp.org.jetbrains.kotlin.fir.backend.CodeFragmentUtilsKt;
import ksp.org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrAnnotationsFromPluginRegistrar;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrFakeOverrideStrategy;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import ksp.org.jetbrains.kotlin.fir.backend.InjectedValue;
import ksp.org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import ksp.org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import ksp.org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import ksp.org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirScript;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import ksp.org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import ksp.org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import ksp.org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import ksp.org.jetbrains.kotlin.fir.java.FirJavaElementFinder;
import ksp.org.jetbrains.kotlin.fir.java.FirJavaElementFinderKt;
import ksp.org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import ksp.org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.IrFileEntry;
import ksp.org.jetbrains.kotlin.ir.IrLock;
import ksp.org.jetbrains.kotlin.ir.PsiIrFileEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import ksp.org.jetbrains.kotlin.ir.linkage.IrProvider;
import ksp.org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrConstructorPublicSymbolImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionPublicSymbolImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.KotlinMangler;
import ksp.org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.platform.TargetPlatform;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u009e\u00012\u00020\u0001:\u0002\u009e\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tJ\u0010\u0010u\u001a\u00020r2\u0006\u0010v\u001a\u00020wH\u0002J\u0014\u0010x\u001a\u00020r2\f\u0010y\u001a\b\u0012\u0004\u0012\u00020V0>J\u0016\u0010z\u001a\b\u0012\u0004\u0012\u00020{0>2\u0006\u0010|\u001a\u00020tH\u0002J\u0016\u0010}\u001a\u00020r2\u0006\u0010~\u001a\u00020\u007f2\u0006\u0010|\u001a\u00020tJ\u0012\u0010\u0080\u0001\u001a\u00020r2\u0007\u0010s\u001a\u00030\u0081\u0001H\u0002J\u0011\u0010\u0082\u0001\u001a\u00020r2\u0006\u0010v\u001a\u00020wH\u0002J \u0010\u0083\u0001\u001a\u00020t2\u0007\u0010s\u001a\u00030\u0081\u00012\u0006\u0010|\u001a\u00020tH\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u001b\u0010\u0085\u0001\u001a\u00020t2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0006\u0010|\u001a\u00020tH\u0002J\u0011\u0010\u0088\u0001\u001a\u00020r2\u0006\u0010v\u001a\u00020wH\u0002J\u001a\u0010\u0089\u0001\u001a\u00020t2\u0007\u0010s\u001a\u00030\u0081\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J\u001a\u0010\u008c\u0001\u001a\u00020t2\u0007\u0010s\u001a\u00030\u0081\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J(\u0010\u008d\u0001\u001a\u00020r2\u0007\u0010\u008e\u0001\u001a\u00020{2\n\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0081\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0002J\u0012\u0010\u0090\u0001\u001a\u00020r2\u0007\u0010s\u001a\u00030\u0081\u0001H\u0002J\u001c\u0010\u0091\u0001\u001a\u00020t2\u0007\u0010s\u001a\u00030\u0081\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0002J\u001b\u0010\u0092\u0001\u001a\u00020r2\u0006\u0010v\u001a\u00020w2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u001a\u0010\u0095\u0001\u001a\u00020r2\u0007\u0010s\u001a\u00030\u0081\u00012\u0006\u0010|\u001a\u00020tH\u0002J,\u0010\u0096\u0001\u001a\u00020r2\r\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u00020w0>2\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0002J\u001f\u0010\u009c\u0001\u001a\t\u0012\u0004\u0012\u00020{0\u009d\u00012\r\u0010y\u001a\t\u0012\u0004\u0012\u00020{0\u009d\u0001H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020.X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u000202X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0012\u00105\u001a\u000206X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0012\u00109\u001a\u00020:X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010@\u001a\u00020AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0012\u0010D\u001a\u00020EX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020I0>X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0012\u0010L\u001a\u00020MX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0012\u0010P\u001a\u00020QX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020V0UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010W\u001a\u00020XX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0012\u0010[\u001a\u00020\\X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b]\u0010^R\u0012\u0010_\u001a\u00020`X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0012\u0010c\u001a\u00020dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0012\u0010g\u001a\u00020hX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u0012\u0010k\u001a\u00020lX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR\u000e\u0010o\u001a\u00020pX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009f\u0001"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lksp/org/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "components", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrAnnotationsFromPluginRegistrar;", "builtIns", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideBuilder", "Lksp/org/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "fakeOverrideGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "generatorExtensions", "", "Lksp/org/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "irBuiltIns", "Lksp/org/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lksp/org/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lksp/org/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lock", "Lksp/org/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "postponedDeclarationsForFakeOverridesBinding", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lksp/org/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "wereSourcesFakeOverridesBound", "", "bindFakeOverridesInClass", "", "klass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "bindFakeOverridesInFile", "file", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "bindFakeOverridesOrPostpone", "declarations", "delegatedMembers", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "irClass", "processAnonymousObjectHeaders", "anonymousObject", "Lksp/org/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "processClassAndNestedClassHeaders", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "processClassHeaders", "processClassMembers", "processClassMembers$fir2ir", "processCodeFragmentMembers", "codeFragment", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "processFileAndClassMembers", "processLocalClassAndNestedClasses", "parent", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClassesOnTheFly", "processMemberDeclaration", "declaration", "containingClass", "processNestedClassHeaders", "registerClassAndNestedClasses", "registerFileAndClasses", "moduleFragment", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "registerNestedClasses", "runSourcesConversion", "allFirFiles", "irModuleFragment", "Lksp/org/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "fir2irVisitor", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "syntheticPropertiesLast", "", "Companion", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 Fir2IrDeclarationStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,699:1\n155#2,4:700\n1#3:704\n1#3:722\n1853#4,2:705\n764#4:709\n855#4,2:710\n1601#4,9:712\n1853#4:721\n1854#4:723\n1610#4:724\n1043#4:725\n1853#4,2:726\n1853#4,2:728\n1853#4,2:730\n1853#4,2:732\n54#5:707\n54#5:708\n54#5:734\n1174#6,4:735\n38#7:739\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n*L\n110#1:700,4\n390#1:722\n177#1:705,2\n388#1:709\n388#1:710,2\n390#1:712,9\n390#1:721\n390#1:723\n390#1:724\n399#1:725\n423#1:726,2\n429#1:728,2\n454#1:730,2\n460#1:732,2\n240#1:707\n242#1:708\n490#1:734\n501#1:735,4\n535#1:739\n*E\n"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;
    private boolean wereSourcesFakeOverridesBound;
    @NotNull
    private final List<IrDeclaration> postponedDeclarationsForFakeOverridesBinding;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(components2, "components");
        this.moduleDescriptor = moduleDescriptor;
        this.components = components2;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        this.postponedDeclarationsForFakeOverridesBinding = new ArrayList();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrAnnotationsFromPluginRegistrar getAnnotationsFromPluginRegistrar() {
        return this.components.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.components.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.components.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.components.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public IrFakeOverrideBuilder getFakeOverrideBuilder() {
        return this.components.getFakeOverrideBuilder();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.components.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    private final void runSourcesConversion(List<? extends FirFile> allFirFiles, IrModuleFragmentImpl irModuleFragment, Fir2IrVisitor fir2irVisitor) {
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.bindFakeOverridesInFile(firFile);
        }
        this.wereSourcesFakeOverridesBound = true;
        this.getFakeOverrideGenerator().bindOverriddenSymbols(this.postponedDeclarationsForFakeOverridesBinding);
        this.postponedDeclarationsForFakeOverridesBinding.clear();
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        this.getDelegatedMemberGenerator().generateBodies();
        for (FirFile firFile : allFirFiles) {
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                IrElement irElement = (IrElement)firFile.accept(fir2irVisitor, null);
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(firFile.getModuleData().getSession()).handleExceptionOnFileAnalysis(firFile, throwable$iv);
                throw null;
            }
        }
        Fir2IrConverter.Companion.evaluateConstants(irModuleFragment, this.components);
    }

    public final void bindFakeOverridesOrPostpone(@NotNull List<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, "declarations");
        if (this.wereSourcesFakeOverridesBound) {
            this.getFakeOverrideGenerator().bindOverriddenSymbols(declarations2);
        } else {
            CollectionsKt.addAll((Collection)this.postponedDeclarationsForFakeOverridesBinding, (Iterable)declarations2);
        }
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        this.processClassAndNestedClassHeaders(klass);
        return irClass;
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(parent2, "parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        this.processClassAndNestedClassHeaders(klass);
        this.processClassMembers$fir2ir(klass, irClass);
        this.bindFakeOverridesInClass(irClass);
        return irClass;
    }

    private final void registerFileAndClasses(FirFile file2, IrModuleFragment moduleFragment) {
        AbstractIrFileEntry abstractIrFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file2.getOrigin();
        if (Intrinsics.areEqual(firDeclarationOrigin, FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                abstractIrFileEntry = new PsiIrFileEntry((KtFile)it);
            } else {
                KtSourceFileLinesMapping linesMapping = file2.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLastOffset());
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    abstractIrFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 6, null);
                }
            }
        } else if (firDeclarationOrigin instanceof FirDeclarationOrigin.Synthetic) {
            abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl(file2.getName(), null, 0, 6, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin: " + file2.getOrigin()).toString());
        }
        AbstractIrFileEntry fileEntry = abstractIrFileEntry;
        IrFileImpl irFile = new IrFileImpl((IrFileEntry)fileEntry, CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file2)).getFragments()), moduleFragment);
        this.getDeclarationStorage().registerFile(file2, irFile);
        for (FirDeclaration declaration2 : file2.getDeclarations()) {
            FirDeclaration firDeclaration = declaration2;
            if (firDeclaration instanceof FirRegularClass) {
                this.registerClassAndNestedClasses((FirClass)declaration2, irFile);
                continue;
            }
            if (!(firDeclaration instanceof FirCodeFragment)) continue;
            this.getClassifierStorage().createAndCacheCodeFragmentClass((FirCodeFragment)declaration2, irFile);
        }
        ((Collection)moduleFragment.getFiles()).add(irFile);
    }

    private final void processClassHeaders(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)it, irFile);
        }
        irFile.getDeclarations().clear();
    }

    private final void processFileAndClassMembers(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (FirDeclaration declaration2 : file2.getDeclarations()) {
            this.processMemberDeclaration(declaration2, null, irFile);
        }
    }

    public final void processAnonymousObjectHeaders(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        this.registerNestedClasses(anonymousObject, irClass);
        this.processNestedClassHeaders(anonymousObject);
        irClass.getDeclarations().clear();
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirClass klass, @NotNull IrClass irClass) {
        IrConstructor irConstructor2;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        List list2 = new ArrayList();
        List $this$processClassMembers_u24lambda_u243 = list2;
        boolean bl = false;
        $this$processClassMembers_u24lambda_u243.addAll((Collection)klass.getDeclarations());
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$processClassMembers_u24lambda_u243.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)klass, this.getSession()));
            $this$processClassMembers_u24lambda_u243.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession()));
        }
        List allDeclarations2 = list2;
        irClass.getDeclarations().addAll((Collection<IrDeclaration>)this.getClassifierStorage().getFieldsWithContextReceiversForClass(irClass, klass));
        FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorIfAny(klass, this.getSession());
        if (firConstructorSymbol2 != null) {
            boolean $i$f$isLocal;
            FirClassLikeDeclaration $this$isLocal$iv;
            FirConstructorSymbol it = firConstructorSymbol2;
            boolean bl2 = false;
            if (klass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
                $this$isLocal$iv = klass;
                $i$f$isLocal = false;
                irConstructor2 = Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), irClass, null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
            } else {
                $this$isLocal$iv = klass;
                $i$f$isLocal = false;
                irConstructor2 = Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), new Function0<IrClass>(irClass){
                    final /* synthetic */ IrClass $irClass;
                    {
                        this.$irClass = $irClass;
                        super(0);
                    }

                    public final IrClass invoke() {
                        return this.$irClass;
                    }
                }, null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
            }
        } else {
            irConstructor2 = null;
        }
        IrConstructor irConstructor3 = irConstructor2;
        for (FirDeclaration declaration2 : this.syntheticPropertiesLast(allDeclarations2)) {
            this.processMemberDeclaration(declaration2, klass, irClass);
        }
        CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)this.delegatedMembers(irClass));
        if (klass instanceof FirRegularClass && irConstructor3 != null && (irClass.isValue() || irClass.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor3.getSymbol());
            DataClassMembersGenerator dataClassMembersGenerator = new DataClassMembersGenerator(this.components);
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateSingleFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateMultiFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (irClass.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateDataClassMembers((FirRegularClass)klass, irClass));
            }
            this.getDeclarationStorage().leaveScope(irConstructor3.getSymbol());
        }
        FakeOverrideGenerator $this$processClassMembers_u24lambda_u245 = this.getFakeOverrideGenerator();
        boolean bl3 = false;
        $this$processClassMembers_u24lambda_u245.computeFakeOverrides(irClass, klass, allDeclarations2);
        return irClass;
    }

    private final IrClass processCodeFragmentMembers(FirCodeFragment codeFragment, IrClass irClass) {
        CodeFragmentConversionData conversionData = CodeFragmentUtilsKt.getConversionData(codeFragment);
        this.getDeclarationStorage().enterScope(irClass.getSymbol());
        IdSignature idSignature = irClass.getSymbol().getSignature();
        Intrinsics.checkNotNull(idSignature);
        IdSignature signature = idSignature;
        this.getSymbolTable().declareConstructor(signature, (Function0<? extends IrConstructorSymbol>)new Function0<IrConstructorSymbol>(signature){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            public final IrConstructorSymbol invoke() {
                return new IrConstructorPublicSymbolImpl(this.$signature, null, 2, null);
            }
        }, (Function1<? super IrConstructorSymbol, ? extends IrConstructor>)new Function1<IrConstructorSymbol, IrConstructor>(this, irClass){
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ IrClass $irClass;
            {
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final IrConstructor invoke(IrConstructorSymbol irSymbol2) {
                void $this$invoke_u24lambda_u241_u24lambda_u240;
                IrBlockBody irBlockBody;
                Intrinsics.checkNotNullParameter(irSymbol2, "irSymbol");
                Object object = this.this$0.getIrFactory();
                Object object2 = IrDeclarationOrigin.Companion.getDEFINED();
                Object object3 = Name.special("<init>");
                DescriptorVisibility descriptorVisibility = this.$irClass.getVisibility();
                IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(this.$irClass);
                IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)object2;
                Intrinsics.checkNotNull(object3);
                object = IrFactory.DefaultImpls.createConstructor$default((IrFactory)object, -1, -1, irDeclarationOrigin, (Name)object3, descriptorVisibility, false, false, irSimpleType, irSymbol2, true, false, null, 2048, null);
                object2 = this.$irClass;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Fir2IrCallableDeclarationsGeneratorKt.setParent((IrDeclaration)$this$invoke_u24lambda_u241, (IrDeclarationParent)object2);
                Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent((IrDeclaration)$this$invoke_u24lambda_u241, (IrDeclarationParent)object2);
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((Fir2IrConverter)object3).getSession().getBuiltinTypes().getAnyType(), ((Fir2IrConverter)object3).getSession());
                Intrinsics.checkNotNull(firRegularClassSymbol);
                FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)firRegularClassSymbol.getFir(), ((Fir2IrConverter)object3).getSession());
                Intrinsics.checkNotNull(firConstructorSymbol2);
                FirConstructorSymbol firAnyConstructor = firConstructorSymbol2;
                IrConstructorSymbol irAnyConstructor = ((Fir2IrConverter)object3).getDeclarationStorage().getIrConstructorSymbol(firAnyConstructor);
                IrBlockBody irBlockBody2 = irBlockBody = ((Fir2IrConverter)object3).getIrFactory().createBlockBody(-1, -1);
                Object object4 = $this$invoke_u24lambda_u241;
                boolean bl2 = false;
                ((Collection)$this$invoke_u24lambda_u241_u24lambda_u240.getStatements()).add(new IrDelegatingConstructorCallImpl(-1, -1, ((Fir2IrConverter)object3).getIrBuiltIns().getUnitType(), irAnyConstructor, 0, 0));
                ((IrFunction)object4).setBody(irBlockBody);
                return object;
            }
        });
        this.getSymbolTable().declareSimpleFunction(signature, (Function0<? extends IrSimpleFunctionSymbol>)new Function0<IrSimpleFunctionSymbol>(signature){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            public final IrSimpleFunctionSymbol invoke() {
                return new IrSimpleFunctionPublicSymbolImpl(this.$signature, null, 2, null);
            }
        }, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(codeFragment, this, conversionData, irClass){
            final /* synthetic */ FirCodeFragment $codeFragment;
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ CodeFragmentConversionData $conversionData;
            final /* synthetic */ IrClass $irClass;
            {
                this.$codeFragment = $codeFragment;
                this.this$0 = $receiver;
                this.$conversionData = $conversionData;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final IrSimpleFunction invoke(IrSimpleFunctionSymbol irSymbol2) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter(irSymbol2, "irSymbol");
                FirStatement lastStatement = CollectionsKt.lastOrNull(this.$codeFragment.getBlock().getStatements());
                Object object = lastStatement instanceof FirExpression ? (FirExpression)lastStatement : null;
                if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = Fir2IrTypeConverterKt.toIrType$default((ConeKotlinType)object, this.this$0.getTypeConverter(), null, 2, null)) == null) {
                    object = this.this$0.getIrBuiltIns().getUnitType();
                }
                Object returnType2 = object;
                IrFactory irFactory = this.this$0.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
                Name name2 = this.$conversionData.getMethodName();
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PUBLIC");
                IrSimpleFunction irSimpleFunction = irFactory.createSimpleFunction(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, false, false, (IrType)returnType2, Modality.FINAL, irSymbol2, false, false, false, false, false, null, false);
                IrClass irClass = this.$irClass;
                CodeFragmentConversionData codeFragmentConversionData = this.$conversionData;
                Fir2IrConverter fir2IrConverter = this.this$0;
                IrSimpleFunction $this$invoke_u24lambda_u242 = irSimpleFunction;
                boolean bl = false;
                Fir2IrCallableDeclarationsGeneratorKt.setParent($this$invoke_u24lambda_u242, irClass);
                Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent($this$invoke_u24lambda_u242, irClass);
                Iterable iterable = codeFragmentConversionData.getInjectedValues();
                IrSimpleFunction irSimpleFunction2 = $this$invoke_u24lambda_u242;
                boolean $i$f$mapIndexed = false;
                void var13_13 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    IrValueParameter irValueParameter;
                    void index2;
                    void injectedValue;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    InjectedValue injectedValue2 = (InjectedValue)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    boolean isMutated = injectedValue.isMutated();
                    IrFactory irFactory2 = fir2IrConverter.getIrFactory();
                    IrDeclarationOrigin irDeclarationOrigin2 = isMutated ? IrDeclarationOrigin.Companion.getSHARED_VARIABLE_IN_EVALUATOR_FRAGMENT() : IrDeclarationOrigin.Companion.getDEFINED();
                    Name name3 = Name.identifier("" + 'p' + (int)index2);
                    Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
                    IrValueParameter $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = irValueParameter = irFactory2.createValueParameter(-1, -1, irDeclarationOrigin2, name3, Fir2IrTypeConverterKt.toIrType$default(injectedValue.getTypeRef(), fir2IrConverter.getTypeConverter(), null, 2, null), isMutated, injectedValue.getIrParameterSymbol(), (int)index2, null, false, false, false);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setParent($this$invoke_u24lambda_u242);
                    collection.add(irValueParameter);
                }
                irSimpleFunction2.setValueParameters((List)destination$iv$iv);
                return irSimpleFunction;
            }
        });
        this.getDeclarationStorage().leaveScope(irClass.getSymbol());
        return irClass;
    }

    private final void bindFakeOverridesInFile(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (IrDeclaration irDeclaration2 : irFile.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    public final void bindFakeOverridesInClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (!(!(klass instanceof Fir2IrLazyClass))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getFakeOverrideGenerator().bindOverriddenSymbols(klass.getDeclarations());
        this.getDelegatedMemberGenerator().bindDelegatedMembersOverriddenSymbols(klass);
        for (IrDeclaration irDeclaration2 : klass.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOrigin(), IrDeclarationOrigin.Companion.getDELEGATED_MEMBER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.components.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(Iterable<? extends FirDeclaration> declarations2) {
        Iterable<? extends FirDeclaration> $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                boolean bl;
                boolean bl2;
                FirDeclaration it = (FirDeclaration)a;
                boolean bl3 = false;
                FirDeclaration $this$isSynthetic$iv = it;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl2 = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl2 = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                it = (FirDeclaration)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl3 = false;
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                return ComparisonsKt.compareValues(comparable, bl);
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirClass klass, IrDeclarationParent parent2) {
        Object object;
        Object object2;
        IrClass irClass = this.getClassifierStorage().getCachedIrClass(klass);
        if (irClass != null) {
            object2 = irClass;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u249 = object2;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u249.setParent(parent2);
            object = object2;
        } else {
            object2 = klass;
            if (object2 instanceof FirRegularClass) {
                object = Fir2IrClassifierStorage.createAndCacheIrClass$default(this.getClassifierStorage(), (FirRegularClass)klass, parent2, null, 4, null);
            } else if (object2 instanceof FirAnonymousObject) {
                object = Fir2IrClassifierStorage.createAndCacheAnonymousObject$default(this.getClassifierStorage(), (FirAnonymousObject)klass, null, null, parent2, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object irClass2 = object;
        this.registerNestedClasses(klass, (IrClass)irClass2);
        return irClass2;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirClass)it, irClass);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirClass)it, irClass);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirClass klass) {
        Fir2IrClassifiersGenerator.processClassHeader$default(this.getClassifiersGenerator(), klass, null, 2, null);
        this.processNestedClassHeaders(klass);
        IrClass irClass = this.getClassifierStorage().getCachedIrClass(klass);
        Intrinsics.checkNotNull(irClass);
        IrClass irClass2 = irClass;
        irClass2.getDeclarations().clear();
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirClass)it);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirClass)it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent) {
        block24: {
            block27: {
                block26: {
                    block25: {
                        block23: {
                            if (containingClass == null) ** GOTO lbl-1000
                            if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
                            $this$isLocal$iv = containingClass;
                            $i$f$isLocal = false;
                            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
                            // 2 sources

                            {
                                v0 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = false;
                            }
                            isInLocalClass = v0;
                            var5_4 = declaration;
                            if (!(var5_4 instanceof FirRegularClass)) break block23;
                            v1 = this.getClassifierStorage().getCachedIrClass((FirClass)declaration);
                            Intrinsics.checkNotNull(v1);
                            irClass = v1;
                            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irClass);
                            this.processClassMembers$fir2ir((FirClass)declaration, irClass);
                            break block24;
                        }
                        if (!(var5_4 instanceof FirScript)) break block25;
                        if (!(parent instanceof IrFile)) {
                            var7_11 = "Failed requirement.";
                            throw new IllegalArgumentException(var7_11.toString());
                        }
                        irScript = this.getDeclarationStorage().getOrCreateIrScript((FirScript)declaration);
                        Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irScript);
                        var7_12 = this.getDeclarationStorage();
                        symbol$iv = irScript.getSymbol();
                        $i$f$withScope = false;
                        this_$iv.enterScope(symbol$iv);
                        $i$a$-withScope-Fir2IrConverter$processMemberDeclaration$1 = false;
                        irScript.setParent(parent);
                        for (FirStatement scriptStatement : ((FirScript)declaration).getStatements()) {
                            var13_21 = scriptStatement;
                            if (var13_21 instanceof FirRegularClass) {
                                Fir2IrConverter.access$registerClassAndNestedClasses(this, (FirClass)scriptStatement, irScript);
                                Fir2IrConverter.access$processClassAndNestedClassHeaders(this, (FirClass)scriptStatement);
                                continue;
                            }
                            if (!(var13_21 instanceof FirTypeAlias)) continue;
                            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)scriptStatement, irScript);
                        }
                        for (FirStatement scriptStatement : ((FirScript)declaration).getStatements()) {
                            if (!(scriptStatement instanceof FirDeclaration)) continue;
                            Fir2IrConverter.access$processMemberDeclaration(this, (FirDeclaration)scriptStatement, null, irScript);
                        }
                        this_$iv.leaveScope(symbol$iv);
                        break block24;
                    }
                    if (!(var5_4 instanceof FirSimpleFunction)) break block26;
                    Fir2IrDeclarationStorage.createAndCacheIrFunction$default(this.getDeclarationStorage(), (FirFunction)declaration, parent, null, isInLocalClass, null, 20, null);
                    break block24;
                }
                if (!(var5_4 instanceof FirProperty)) break block27;
                if (containingClass == null || !UtilsKt.isEnumEntries((FirVariable)declaration, containingClass) || FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.EnumEntries)) {
                    Fir2IrDeclarationStorage.getOrCreateIrProperty$default(this.getDeclarationStorage(), (FirProperty)declaration, parent, null, isInLocalClass, null, 20, null);
                }
                break block24;
            }
            if (!(var5_4 instanceof FirField)) ** GOTO lbl75
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) {
                v2 = this.getCallablesGenerator();
                v3 = (FirField)declaration;
                v4 = containingClass;
                Intrinsics.checkNotNull(v4);
                Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                v2.createIrFieldAndDelegatedMembers(v3, v4, (IrClass)parent);
            } else {
                throw new IllegalStateException(("Unexpected non-synthetic field: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
lbl75:
                // 1 sources

                if (var5_4 instanceof FirConstructor) {
                    if (!((FirConstructor)declaration).isPrimary()) {
                        v5 = containingClass;
                        if ((v5 != null ? v5.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                            v6 = this.getDeclarationStorage();
                            v7 = (FirConstructor)declaration;
                            Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                            Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(v6, v7, (IrClass)parent, null, isInLocalClass, 4, null);
                        } else {
                            Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)declaration, new Function0<IrClass>(parent){
                                final /* synthetic */ IrDeclarationParent $parent;
                                {
                                    this.$parent = $parent;
                                    super(0);
                                }

                                public final IrClass invoke() {
                                    IrDeclarationParent irDeclarationParent = this.$parent;
                                    Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                                    return (IrClass)irDeclarationParent;
                                }
                            }, null, isInLocalClass, 4, null);
                        }
                    }
                } else if (var5_4 instanceof FirEnumEntry) {
                    v8 = this.getClassifierStorage();
                    v9 = (FirEnumEntry)declaration;
                    Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    Fir2IrClassifierStorage.getOrCreateIrEnumEntry$default(v8, v9, (IrClass)parent, null, 4, null);
                } else if (var5_4 instanceof FirAnonymousInitializer) {
                    v10 = this.getDeclarationStorage();
                    v11 = (FirAnonymousInitializer)declaration;
                    Intrinsics.checkNotNull(parent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    v10.getOrCreateIrAnonymousInitializer(v11, (IrClass)parent);
                } else if (var5_4 instanceof FirTypeAlias) {
                    v12 = this.getClassifierStorage().getCachedTypeAlias$fir2ir((FirTypeAlias)declaration);
                    if (v12 != null) {
                        irTypeAlias = v12;
                        $i$a$-let-Fir2IrConverter$processMemberDeclaration$3 = false;
                        Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irTypeAlias);
                    }
                } else if (var5_4 instanceof FirCodeFragment) {
                    v13 = this.getClassifierStorage().getCachedIrCodeFragment((FirCodeFragment)declaration);
                    Intrinsics.checkNotNull(v13);
                    codeFragmentClass = v13;
                    this.processCodeFragmentMembers((FirCodeFragment)declaration, codeFragmentClass);
                    Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, codeFragmentClass);
                } else {
                    throw new IllegalStateException(("Unexpected member: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
                }
            }
        }
    }

    private static final void processMemberDeclaration$addDeclarationToParentIfNeeded(IrDeclarationParent $parent, IrDeclaration irDeclaration2) {
        IrDeclarationParent irDeclarationParent = $parent;
        if (irDeclarationParent instanceof IrFile) {
            ((Collection)((IrFile)$parent).getDeclarations()).add(irDeclaration2);
        } else if (irDeclarationParent instanceof IrClass) {
            ((Collection)((IrClass)$parent).getDeclarations()).add(irDeclaration2);
        }
    }

    public static final /* synthetic */ IrClass access$registerClassAndNestedClasses(Fir2IrConverter $this, FirClass klass, IrDeclarationParent parent2) {
        return $this.registerClassAndNestedClasses(klass, parent2);
    }

    public static final /* synthetic */ void access$processClassAndNestedClassHeaders(Fir2IrConverter $this, FirClass klass) {
        $this.processClassAndNestedClassHeaders(klass);
    }

    public static final /* synthetic */ void access$processMemberDeclaration(Fir2IrConverter $this, FirDeclaration declaration2, FirClass containingClass, IrDeclarationParent parent2) {
        $this.processMemberDeclaration(declaration2, containingClass, parent2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\"\u0010(\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\n0)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010+\u001a\u0004\u0018\u00010**\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00a8\u00061"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "()V", "createIrModuleFragment", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrResult;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "fir2IrExtensions", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fir2IrConfiguration", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "irMangler", "Lksp/org/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irFactory", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFactory;", "visibilityConverter", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "specialSymbolProvider", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrSpecialSymbolProvider;", "kotlinBuiltIns", "Lksp/org/jetbrains/kotlin/builtins/KotlinBuiltIns;", "commonMemberStorage", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "initializedIrBuiltIns", "Lksp/org/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "typeContextProvider", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/ir/IrBuiltIns;", "Lksp/org/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "evaluateConstants", "", "irModuleFragment", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "friendModulesMap", "", "", "evaluate", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "interpreter", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "mode", "Lksp/org/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,699:1\n1853#2,2:700\n1547#2:703\n1618#2,3:704\n1#3:702\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n*L\n595#1:700,2\n641#1:703\n641#1:704,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void evaluateConstants(IrModuleFragment irModuleFragment, Fir2IrComponents components2) {
            FirModuleDescriptor firModuleDescriptor;
            Fir2IrConfiguration fir2IrConfiguration = components2.getConfiguration();
            ModuleDescriptor moduleDescriptor = irModuleFragment.getDescriptor();
            FirModuleDescriptor firModuleDescriptor2 = firModuleDescriptor = moduleDescriptor instanceof FirModuleDescriptor ? (FirModuleDescriptor)moduleDescriptor : null;
            TargetPlatform targetPlatform = firModuleDescriptor2 != null ? firModuleDescriptor2.getPlatform() : null;
            Object object = firModuleDescriptor;
            if (object == null || (object = ((FirModuleDescriptor)object).getSession()) == null || (object = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)object)) == null) {
                return;
            }
            Object languageVersionSettings2 = object;
            boolean intrinsicConstEvaluation = languageVersionSettings2.supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
            IrInterpreterConfiguration configuration2 = new IrInterpreterConfiguration(targetPlatform, 0, 0, false, true, false, 46, null);
            IrInterpreter interpreter2 = new IrInterpreter(new IrInterpreterEnvironment(irModuleFragment.getIrBuiltins(), configuration2), null, 2, null);
            EvaluationMode mode = intrinsicConstEvaluation ? EvaluationMode.ONLY_INTRINSIC_CONST : EvaluationMode.ONLY_BUILTINS;
            FirJavaElementFinder firJavaElementFinder = FirJavaElementFinderKt.getJavaElementFinder(components2.getSession());
            if (firJavaElementFinder != null) {
                firJavaElementFinder.setPropertyEvaluator((Function1<? super FirProperty, String>)new Function1<FirProperty, String>(components2, interpreter2, mode){
                    final /* synthetic */ Fir2IrComponents $components;
                    final /* synthetic */ IrInterpreter $interpreter;
                    final /* synthetic */ EvaluationMode $mode;
                    {
                        this.$components = $components;
                        this.$interpreter = $interpreter;
                        this.$mode = $mode;
                        super(1);
                    }

                    public final String invoke(FirProperty it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.access$evaluate(Fir2IrConverter.Companion, it, this.$components, this.$interpreter, this.$mode);
                    }
                });
            }
            KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(fir2IrConfiguration.getDiagnosticReporter(), (LanguageVersionSettings)languageVersionSettings2);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                IrConstTransformerKt.transformConst$default(it, it, interpreter2, mode, fir2IrConfiguration.getEvaluatedConstTracker(), fir2IrConfiguration.getInlineConstTracker(), null, new Function3<IrFile, IrElement, IrErrorExpression, Unit>(ktDiagnosticReporter){
                    final /* synthetic */ KtDiagnosticReporterWithImplicitIrBasedContext $ktDiagnosticReporter;
                    {
                        this.$ktDiagnosticReporter = $ktDiagnosticReporter;
                        super(3);
                    }

                    public final void invoke(IrFile irFile, IrElement element2, IrErrorExpression error) {
                        Intrinsics.checkNotNullParameter(irFile, "irFile");
                        Intrinsics.checkNotNullParameter(element2, "element");
                        Intrinsics.checkNotNullParameter(error, "error");
                        this.$ktDiagnosticReporter.at(ksp.org.jetbrains.kotlin.backend.common.UtilsKt.sourceElement(element2), element2, irFile).report(CommonBackendErrors.INSTANCE.getEVALUATION_ERROR(), error.getDescription());
                    }
                }, false, 160, null);
            }
        }

        private final String evaluate(FirProperty $this$evaluate, Fir2IrComponents components2, IrInterpreter interpreter2, EvaluationMode mode) {
            IrProperty irProperty;
            Object object = Fir2IrDeclarationStorage.getCachedIrPropertySymbol$default(components2.getDeclarationStorage(), $this$evaluate, null, null, 4, null);
            if (object == null || (irProperty = (IrProperty)object.getOwner()) == null) {
                return null;
            }
            IrProperty irProperty2 = irProperty;
            object = ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irProperty2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(irProperty2);
            if (irFile == null) {
                return null;
            }
            IrFile irFile2 = irFile;
            IrElement evaluated = IrConstTransformerKt.transformConst$default(irProperty2, irFile2, interpreter2, mode, components2.getConfiguration().getEvaluatedConstTracker(), components2.getConfiguration().getInlineConstTracker(), null, null, false, 224, null);
            IrElementBase irElementBase = evaluated instanceof IrProperty ? (IrProperty)evaluated : null;
            return irElementBase != null && (irElementBase = ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irElementBase)) != null ? ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(irElementBase) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, List<String>> friendModulesMap(FirSession session2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = FirModuleDataKt.getModuleData(session2).getFriendDependencies();
            String string2 = FirModuleDataKt.getModuleData(session2).getName().asStringStripSpecialMarkers();
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirModuleData firModuleData = (FirModuleData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName().asStringStripSpecialMarkers());
            }
            return MapsKt.mapOf(TuplesKt.to(string2, (List)destination$iv$iv));
        }

        @NotNull
        public final Fir2IrResult createIrModuleFragment(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles, @NotNull Fir2IrExtensions fir2IrExtensions, @NotNull Fir2IrConfiguration fir2IrConfiguration, @NotNull KotlinMangler.IrMangler irMangler, @NotNull IrFactory irFactory, @NotNull Fir2IrVisibilityConverter visibilityConverter, @NotNull Fir2IrSpecialSymbolProvider specialSymbolProvider, @NotNull KotlinBuiltIns kotlinBuiltIns, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @Nullable IrBuiltInsOverFir initializedIrBuiltIns, @NotNull Function1<? super IrBuiltIns, ? extends IrTypeSystemContext> typeContextProvider) {
            List list2;
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            Intrinsics.checkNotNullParameter(firFiles, "firFiles");
            Intrinsics.checkNotNullParameter(fir2IrExtensions, "fir2IrExtensions");
            Intrinsics.checkNotNullParameter(fir2IrConfiguration, "fir2IrConfiguration");
            Intrinsics.checkNotNullParameter(irMangler, "irMangler");
            Intrinsics.checkNotNullParameter(irFactory, "irFactory");
            Intrinsics.checkNotNullParameter(visibilityConverter, "visibilityConverter");
            Intrinsics.checkNotNullParameter(specialSymbolProvider, "specialSymbolProvider");
            Intrinsics.checkNotNullParameter(kotlinBuiltIns, "kotlinBuiltIns");
            Intrinsics.checkNotNullParameter(commonMemberStorage, "commonMemberStorage");
            Intrinsics.checkNotNullParameter(typeContextProvider, "typeContextProvider");
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver(session2).disableLazyResolveContractChecks();
            FirModuleDescriptor moduleDescriptor = FirModuleDescriptor.Companion.createSourceModuleDescriptor(session2, kotlinBuiltIns);
            Fir2IrComponentsStorage components2 = new Fir2IrComponentsStorage(session2, scopeSession, irFactory, fir2IrExtensions, fir2IrConfiguration, visibilityConverter, (Function1<? super IrBuiltIns, IrFakeOverrideBuilder>)new Function1<IrBuiltIns, IrFakeOverrideBuilder>(typeContextProvider, session2, commonMemberStorage, irMangler, fir2IrExtensions){
                final /* synthetic */ Function1<IrBuiltIns, IrTypeSystemContext> $typeContextProvider;
                final /* synthetic */ FirSession $session;
                final /* synthetic */ Fir2IrCommonMemberStorage $commonMemberStorage;
                final /* synthetic */ KotlinMangler.IrMangler $irMangler;
                final /* synthetic */ Fir2IrExtensions $fir2IrExtensions;
                {
                    this.$typeContextProvider = $typeContextProvider;
                    this.$session = $session;
                    this.$commonMemberStorage = $commonMemberStorage;
                    this.$irMangler = $irMangler;
                    this.$fir2IrExtensions = $fir2IrExtensions;
                    super(1);
                }

                public final IrFakeOverrideBuilder invoke(IrBuiltIns irBuiltins) {
                    Intrinsics.checkNotNullParameter(irBuiltins, "irBuiltins");
                    return new IrFakeOverrideBuilder(this.$typeContextProvider.invoke(irBuiltins), new Fir2IrFakeOverrideStrategy(ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.access$friendModulesMap(Fir2IrConverter.Companion, this.$session), this.$commonMemberStorage.getSymbolTable(), this.$irMangler), this.$fir2IrExtensions.getExternalOverridabilityConditions());
                }
            }, moduleDescriptor, commonMemberStorage, irMangler, specialSymbolProvider, initializedIrBuiltIns);
            fir2IrExtensions.registerDeclarations(commonMemberStorage.getSymbolTable());
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(moduleDescriptor, components2.getIrBuiltIns(), null, 4, null);
            List $this$createIrModuleFragment_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createIrModuleFragment_u24lambda_u243.addAll(firFiles);
            $this$createIrModuleFragment_u24lambda_u243.addAll(ConversionUtilsKt.createFilesWithGeneratedDeclarations(session2));
            List allFirFiles = CollectionsKt.build(list2);
            components2.getConverter().runSourcesConversion(allFirFiles, irModuleFragment, components2.getFir2IrVisitor());
            if (fir2IrConfiguration.getUseIrFakeOverrideBuilder()) {
                FakeOverrideRebuilder rebuilder = new FakeOverrideRebuilder(commonMemberStorage.getSymbolTable(), components2.getFakeOverrideBuilder());
                rebuilder.rebuildFakeOverrides(irModuleFragment);
            }
            return new Fir2IrResult(irModuleFragment, components2, moduleDescriptor);
        }

        private static final IrConst<?> evaluate$tryToGetConst(IrProperty $this$evaluate_u24tryToGetConst) {
            IrElementBase irElementBase = $this$evaluate_u24tryToGetConst.getBackingField();
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            return irExpression instanceof IrConst ? (IrConst)irExpression : null;
        }

        private static final String evaluate$asString(IrConst<?> $this$evaluate_u24asString) {
            Object constVal = $this$evaluate_u24asString.getValue();
            return constVal instanceof Character ? String.valueOf((int)((Character)constVal).charValue()) : (constVal instanceof String ? "" + '\"' + constVal + '\"' : String.valueOf(constVal));
        }

        public static final /* synthetic */ String access$evaluate(Companion $this, FirProperty $receiver, Fir2IrComponents components2, IrInterpreter interpreter2, EvaluationMode mode) {
            return $this.evaluate($receiver, components2, interpreter2, mode);
        }

        public static final /* synthetic */ Map access$friendModulesMap(Companion $this, FirSession session2) {
            return $this.friendModulesMap(session2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

