/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.ObjCExportMetaAnnotations;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"findMetaAnnotations", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/ObjCExportMetaAnnotations;", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "checkers.native"})
public final class FirNativeObjCRefinementAnnotationCheckerKt {
    @NotNull
    public static final ObjCExportMetaAnnotations findMetaAnnotations(@NotNull List<? extends FirAnnotation> $this$findMetaAnnotations, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$findMetaAnnotations, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirAnnotation objCAnnotation = null;
        FirAnnotation swiftAnnotation = null;
        for (FirAnnotation firAnnotation : $this$findMetaAnnotations) {
            ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(firAnnotation, session2);
            if (Intrinsics.areEqual(classId, FirNativeObjCRefinementChecker.INSTANCE.getHidesFromObjCClassId())) {
                objCAnnotation = firAnnotation;
            } else if (Intrinsics.areEqual(classId, FirNativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftClassId())) {
                swiftAnnotation = firAnnotation;
            }
            if (objCAnnotation == null || swiftAnnotation == null) continue;
        }
        return new ObjCExportMetaAnnotations(objCAnnotation, swiftAnnotation);
    }
}

