/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isRenamableFunction", "", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "isValueClassThatRequiresMangling", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,70:1\n40#2:71\n34#2:72\n43#2:73\n*S KotlinDebug\n*F\n+ 1 FirJvmNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker\n*L\n51#1:71\n52#1:72\n67#1:73\n*E\n"})
public final class FirJvmNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmNameChecker INSTANCE = new FirJvmNameChecker();

    private FirJvmNameChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block9: {
            FirAnnotation jvmName2;
            block10: {
                block8: {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    FirAnnotation firAnnotation = JavaUtilsKt.findJvmNameAnnotation(declaration2);
                    if (firAnnotation == null) {
                        return;
                    }
                    jvmName2 = firAnnotation;
                    FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(jvmName2, StandardNames.NAME);
                    if (firExpression2 == null) {
                        return;
                    }
                    FirExpression name2 = firExpression2;
                    if (!Intrinsics.areEqual(FirTypeUtilsKt.getResolvedType(name2), context2.getSession().getBuiltinTypes().getStringType().getType())) {
                        return;
                    }
                    FirConstExpression firConstExpression = name2 instanceof FirConstExpression ? (FirConstExpression)name2 : null;
                    Object t = firConstExpression != null ? firConstExpression.getValue() : null;
                    String string2 = t instanceof String ? (String)t : null;
                    if (string2 == null) {
                        return;
                    }
                    String value2 = string2;
                    if (!Name.isValidIdentifier(value2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    }
                    if (!(declaration2 instanceof FirFunction) || this.isRenamableFunction(context2, (FirFunction)declaration2)) break block8;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    break block9;
                }
                if (!(declaration2 instanceof FirCallableDeclaration)) break block9;
                FirRegularClass containingClass = ResolveUtilsKt.getContainingClass((FirCallableDeclaration)declaration2, context2.getSession());
                FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isOverride = false;
                if ($this$isOverride$iv.getStatus().isOverride()) break block10;
                FirMemberDeclaration $this$isOverridable$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isOverridable = false;
                if ($this$isOverridable$iv.getStatus().getModality() != Modality.FINAL && !Intrinsics.areEqual($this$isOverridable$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) break block10;
                FirRegularClass firRegularClass = containingClass;
                boolean bl = firRegularClass != null ? this.isValueClassThatRequiresMangling(firRegularClass) : false;
                if (!bl) break block9;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isRenamableFunction(CheckerContext $this$isRenamableFunction, FirFunction function2) {
        FirClassLikeSymbol<?> containingClass = FirHelpersKt.getContainingClassSymbol(function2, $this$isRenamableFunction.getSession());
        return containingClass != null || !function2.getSymbol().getCallableId().isLocal();
    }

    private final boolean isValueClassThatRequiresMangling(FirRegularClass $this$isValueClassThatRequiresMangling) {
        FirMemberDeclaration $this$isInline$iv = $this$isValueClassThatRequiresMangling;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && !Intrinsics.areEqual($this$isValueClassThatRequiresMangling.getName(), StandardClassIds.INSTANCE.getResult().getShortClassName());
    }
}

