/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findFakeMethodOverridingExternalWithOptionalParams", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "isBuiltinFunctionalTypeOrSubtype", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isSuspendFunctionTypeOrSubtype", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1745#2,3:75\n798#2,11:79\n764#2:90\n855#2,2:91\n288#2,2:93\n1#3:78\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n*L\n43#1:75,3\n63#1:79,11\n64#1:90\n64#1:91,2\n69#1:93,2\n*E\n"})
public final class FirJsInheritanceClassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirJsInheritanceClassChecker INSTANCE = new FirJsInheritanceClassChecker();

    private FirJsInheritanceClassChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirNamedFunctionSymbol fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!FirJsHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration2.getSymbol(), context2) && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams(declaration2, context2)) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE(), (Object)fakeOverriddenMethod, (DiagnosticContext)context2, null, 16, null);
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface)) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(declaration2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl2 = false;
                        if (!(INSTANCE.isBuiltinFunctionalTypeOrSubtype(it, context2.getSession()) && !INSTANCE.isSuspendFunctionTypeOrSubtype(it, context2.getSession()))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getIMPLEMENTING_FUNCTION_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final boolean isBuiltinFunctionalTypeOrSubtype(ConeClassLikeType $this$isBuiltinFunctionalTypeOrSubtype, FirSession session2) {
        ConeInferenceContext $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u241 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u241.isBuiltinFunctionTypeOrSubtype($this$isBuiltinFunctionalTypeOrSubtype);
    }

    private final boolean isSuspendFunctionTypeOrSubtype(ConeClassLikeType $this$isSuspendFunctionTypeOrSubtype, FirSession session2) {
        ConeInferenceContext $this$isSuspendFunctionTypeOrSubtype_u24lambda_u242 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return $this$isSuspendFunctionTypeOrSubtype_u24lambda_u242.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, (Function1<? super ConeKotlinType, Boolean>)new Function1<ConeKotlinType, Boolean>(session2){
            final /* synthetic */ FirSession $session;
            {
                this.$session = $session;
                super(1);
            }

            public final Boolean invoke(ConeKotlinType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(it, this.$session);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirNamedFunctionSymbol findFakeMethodOverridingExternalWithOptionalParams(FirClass $this$findFakeMethodOverridingExternalWithOptionalParams, CheckerContext context2) {
        Object v1;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            FirTypeScope scope = FirHelpersKt.unsubstitutedScope($this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol(), context2);
            Iterable iterable = FirContainingNamesAwareScopeKt.collectAllFunctions(scope);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirIntersectionOverrideFunctionSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv$iv;
                boolean bl = false;
                FirClassLikeSymbol<?> container2 = FirHelpersKt.getContainingClassSymbol(it, context2.getSession());
                boolean bl2 = Intrinsics.areEqual(container2, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol()) && !it.getIntersections().isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv;
                boolean bl = false;
                if (!FirJsHelpersKt.isOverridingExternalWithOptionalParams(it, context2)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }
}

