/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirImport;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import ksp.org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/PlatformClassMappedToKotlinImportsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nPlatformClassMappedToKotlinImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformClassMappedToKotlinImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/PlatformClassMappedToKotlinImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1853#2,2:35\n*S KotlinDebug\n*F\n+ 1 PlatformClassMappedToKotlinImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/PlatformClassMappedToKotlinImportsChecker\n*L\n20#1:35,2\n*E\n"})
public final class PlatformClassMappedToKotlinImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final PlatformClassMappedToKotlinImportsChecker INSTANCE = new PlatformClassMappedToKotlinImportsChecker();

    private PlatformClassMappedToKotlinImportsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Iterable $this$forEach$iv = declaration2.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object classId;
            FqName importedFqName;
            FirImport firImport;
            block8: {
                block7: {
                    firImport = (FirImport)element$iv;
                    boolean bl = false;
                    if (firImport.getImportedFqName() == null) {
                        return;
                    }
                    if (importedFqName.isRoot()) break block7;
                    String string2 = importedFqName.shortName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    if (!(((CharSequence)string2).length() == 0)) break block8;
                }
                return;
            }
            Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
            if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
                object = ClassId.Companion.topLevel(importedFqName);
            }
            if (!Intrinsics.areEqual(((ClassId)(classId = object)).asSingleFqName(), importedFqName)) {
                return;
            }
            ClassId kotlinClass = FirPlatformClassMapperKt.getPlatformClassMapper(context2.getSession()).getCorrespondingKotlinClass((ClassId)classId);
            if (kotlinClass == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPLATFORM_CLASS_MAPPED_TO_KOTLIN(), (Object)importedFqName, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

