/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/ArrayEqualityCanBeReplacedWithEquals;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nArrayEqualityCanBeReplacedWithEquals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayEqualityCanBeReplacedWithEquals.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/ArrayEqualityCanBeReplacedWithEquals\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,35:1\n44#2:36\n*S KotlinDebug\n*F\n+ 1 ArrayEqualityCanBeReplacedWithEquals.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/ArrayEqualityCanBeReplacedWithEquals\n*L\n25#1:36\n*E\n"})
public final class ArrayEqualityCanBeReplacedWithEquals
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final ArrayEqualityCanBeReplacedWithEquals INSTANCE = new ArrayEqualityCanBeReplacedWithEquals();

    private ArrayEqualityCanBeReplacedWithEquals() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(expression2 instanceof FirEqualityOperatorCall)) {
            return;
        }
        if (((FirEqualityOperatorCall)expression2).getOperation() != FirOperation.EQ && ((FirEqualityOperatorCall)expression2).getOperation() != FirOperation.NOT_EQ) {
            return;
        }
        FirCall $this$arguments$iv = (FirCall)expression2;
        boolean $i$f$getArguments = false;
        List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
        FirExpression firExpression2 = CollectionsKt.getOrNull(arguments2, 0);
        if (firExpression2 == null) {
            return;
        }
        FirExpression left = firExpression2;
        FirExpression firExpression3 = CollectionsKt.getOrNull(arguments2, 1);
        if (firExpression3 == null) {
            return;
        }
        FirExpression right = firExpression3;
        if (!Intrinsics.areEqual(FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType(left), context2.getSession()), StandardClassIds.INSTANCE.getArray())) {
            return;
        }
        if (!Intrinsics.areEqual(FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType(right), context2.getSession()), StandardClassIds.INSTANCE.getArray())) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getARRAY_EQUALITY_OPERATOR_CAN_BE_REPLACED_WITH_EQUALS(), (DiagnosticContext)context2, null, 8, null);
    }
}

