/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirUselessTypeOperationCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isExactTypeCast", "", "lhsType", "Lksp/org/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "targetType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "isRefinementUseless", "arg", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUselessTypeOperationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUselessTypeOperationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUselessTypeOperationCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,83:1\n46#2:84\n*S KotlinDebug\n*F\n+ 1 FirUselessTypeOperationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUselessTypeOperationCallChecker\n*L\n23#1:84\n*E\n"})
public final class FirUselessTypeOperationCallChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirUselessTypeOperationCallChecker INSTANCE = new FirUselessTypeOperationCallChecker();

    private FirUselessTypeOperationCallChecker() {
    }

    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation())) {
            return;
        }
        FirCall $this$argument$iv = expression2;
        boolean $i$f$getArgument = false;
        FirExpression arg = CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
        ConeSimpleKotlinType lhsType = TypeExpansionUtilsKt.fullyExpandedType(ConeTypeUtilsKt.upperBoundIfFlexible(FirTypeUtilsKt.getResolvedType(arg)), context2.getSession());
        if (lhsType instanceof ConeErrorType) {
            return;
        }
        ConeKotlinType targetType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(expression2.getConversionTypeRef()), context2.getSession());
        if (targetType instanceof ConeErrorType) {
            return;
        }
        if (this.isRefinementUseless(context2, lhsType, targetType, expression2, arg)) {
            switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)true, (DiagnosticContext)context2, null, 16, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)false, (DiagnosticContext)context2, null, 16, null);
                    break;
                }
                case 3: 
                case 4: {
                    if (expression2.getArgFromStubType()) break;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CAST(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression2.getOperation())));
                }
            }
        }
    }

    private final boolean isRefinementUseless(CheckerContext context2, ConeSimpleKotlinType lhsType, ConeKotlinType targetType, FirTypeOperatorCall expression2, FirExpression arg) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 3: 
            case 4: {
                if (arg instanceof FirFunctionCall) {
                    FirFunctionSymbol functionSymbol;
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(arg);
                    FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
                    if (functionSymbol != null && FirHelpersKt.isFunctionForExpectTypeFromCastFeature(functionSymbol)) {
                        return false;
                    }
                }
                ConeKotlinType refinedTargetType = expression2.getOperation() == FirOperation.SAFE_AS && ConeTypeUtilsKt.isNullable(lhsType) ? TypeUtilsKt.withNullability$default(targetType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null) : targetType;
                bl = this.isExactTypeCast(context2, lhsType, refinedTargetType);
                break;
            }
            case 1: 
            case 2: {
                bl = FirCastDiagnosticsHelpersKt.isUpcast(context2, lhsType, targetType);
                break;
            }
            default: {
                throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression2.getOperation())));
            }
        }
        return bl;
    }

    private final boolean isExactTypeCast(CheckerContext context2, ConeSimpleKotlinType lhsType, ConeKotlinType targetType) {
        if (!AbstractTypeChecker.INSTANCE.equalTypes(TypeComponentsKt.getTypeContext(context2.getSession()), lhsType, targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(lhsType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

