/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirInaccessibleReceiverExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirReceiverAccessBeforeSuperCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirInaccessibleReceiverExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirInaccessibleReceiverChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirReceiverAccessBeforeSuperCallChecker
extends FirExpressionChecker<FirInaccessibleReceiverExpression> {
    @NotNull
    public static final FirReceiverAccessBeforeSuperCallChecker INSTANCE = new FirReceiverAccessBeforeSuperCallChecker();

    private FirReceiverAccessBeforeSuperCallChecker() {
    }

    @Override
    public void check(@NotNull FirInaccessibleReceiverExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirQualifiedAccessExpression containingCall;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirStatement firStatement = CollectionsKt.last(context2.getCallsOrAssignments());
        Intrinsics.checkNotNull(firStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression");
        FirQualifiedAccessExpression $this$check_u24lambda_u240 = containingCall = (FirQualifiedAccessExpression)firStatement;
        boolean bl = false;
        if (!(Intrinsics.areEqual(expression2, $this$check_u24lambda_u240.getDispatchReceiver()) || Intrinsics.areEqual(expression2, $this$check_u24lambda_u240.getExtensionReceiver()) || $this$check_u24lambda_u240.getContextReceiverArguments().contains(expression2))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingCall.getCalleeReference().getSource(), FirErrors.INSTANCE.getINSTANCE_ACCESS_BEFORE_SUPER_CALL(), (Object)"<this>", (DiagnosticContext)context2, null, 16, null);
    }
}

