/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOptInArgumentIsMarker", "classSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkOptInIsEnabled", "element", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,112:1\n22#2,4:113\n44#3:117\n51#4:118\n54#4:119\n*S KotlinDebug\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n*L\n35#1:113,4\n43#1:117\n66#1:118\n70#1:119\n*E\n"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
    }

    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        Object lookupTag2 = object;
        ClassId classId = ((ConeClassLikeLookupTag)lookupTag2).getClassId();
        boolean isRequiresOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
        boolean isOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
        boolean isSubclassOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID());
        if (isRequiresOptIn || isOptIn) {
            this.checkOptInIsEnabled(expression2.getSource(), context2, reporter);
            if (isOptIn) {
                FirCall $this$arguments$iv = expression2;
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context2, null, 8, null);
                } else {
                    FirExpression annotationClasses;
                    FirExpression firExpression2 = annotationClasses = FirAnnotationUtilsKt.findArgumentByName(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    List<FirRegularClassSymbol> list2 = firExpression2 != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression2, context2.getSession()) : null;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    for (FirRegularClassSymbol classSymbol2 : list2) {
                        this.checkOptInArgumentIsMarker(classSymbol2, expression2.getSource(), reporter, context2);
                    }
                }
            }
        } else if (isSubclassOptIn) {
            Object object2;
            FirClass declaration2;
            FirDeclaration annotationClasses = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirClass firClass = declaration2 = annotationClasses instanceof FirClass ? (FirClass)annotationClasses : null;
            if (declaration2 != null) {
                ClassKind kind = declaration2.getClassKind();
                if (kind == ClassKind.ENUM_CLASS || kind == ClassKind.OBJECT || kind == ClassKind.ANNOTATION_CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)kind.toString(), (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                Modality modality = FirHelpersKt.modality(declaration2);
                if (modality == Modality.FINAL || modality == Modality.SEALED) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)("" + (Object)((Object)modality) + ' ' + (Object)((Object)kind)), (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                FirMemberDeclaration $this$isFun$iv = declaration2;
                boolean $i$f$isFun = false;
                if ($this$isFun$iv.getStatus().isFun()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)"fun interface", (DiagnosticContext)context2, null, 16, null);
                    return;
                }
                FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)("local " + (Object)((Object)kind)), (DiagnosticContext)context2, null, 16, null);
                    return;
                }
            }
            if ((object2 = FirAnnotationUtilsKt.findArgumentByName(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS())) == null || (object2 = FirAnnotationHelpersKt.extractClassFromArgument((FirExpression)object2, context2.getSession())) == null) {
                return;
            }
            Object classSymbol3 = object2;
            this.checkOptInArgumentIsMarker((FirRegularClassSymbol)classSymbol3, expression2.getSource(), reporter, context2);
        }
    }

    private final void checkOptInIsEnabled(KtSourceElement element2, CheckerContext context2, DiagnosticReporter reporter) {
        LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        List<String> optInFqNames = languageVersionSettings2.getFlag(AnalysisFlags.getOptIn());
        if (!languageVersionSettings2.supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element2, FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkOptInArgumentIsMarker(FirRegularClassSymbol classSymbol2, KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        FirOptInUsageBaseChecker $this$checkOptInArgumentIsMarker_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default($this$checkOptInArgumentIsMarker_u24lambda_u240, classSymbol2, context2.getSession(), null, 2, null) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER(), (Object)classSymbol2.getClassId().asSingleFqName(), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

