/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithSingleCandidate;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeNullability;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u0006*\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "forEachClassLikeType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "action", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,72:1\n1#2:73\n1853#3,2:74\n1853#3,2:76\n26#4:78\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassChecker\n*L\n51#1:74,2\n66#1:76,2\n43#1:78\n*E\n"})
public final class FirMissingDependencyClassChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirMissingDependencyClassChecker INSTANCE = new FirMissingDependencyClassChecker();

    private FirMissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference) && !(((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic() instanceof ConeDiagnosticWithSingleCandidate)) {
            return;
        }
        Set missingTypes = new LinkedHashSet();
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        FirMissingDependencyClassChecker.check$consider(context2, missingTypes, FirTypeUtilsKt.getConeType(symbol2.getResolvedReturnTypeRef()));
        Object object2 = symbol2.getResolvedReceiverTypeRef();
        if (object2 != null && (object2 = FirTypeUtilsKt.getConeType((FirTypeRef)object2)) != null) {
            Object p0 = object2;
            boolean bl = false;
            FirMissingDependencyClassChecker.check$consider(context2, missingTypes, (ConeKotlinType)p0);
        }
        if ((object = symbol2 instanceof FirFunctionSymbol ? (FirFunctionSymbol)symbol2 : null) != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                FirMissingDependencyClassChecker.check$consider(context2, missingTypes, FirTypeUtilsKt.getConeType(it.getResolvedReturnTypeRef()));
            }
        }
        for (ConeKotlinType missingType : missingTypes) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)missingType, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void forEachClassLikeType(ConeKotlinType $this$forEachClassLikeType, Function1<? super ConeClassLikeType, Unit> action) {
        ConeKotlinType coneKotlinType = $this$forEachClassLikeType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getLowerBound(), action);
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.forEachClassLikeType(((ConeDefinitelyNotNullType)$this$forEachClassLikeType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachClassLikeType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.forEachClassLikeType(it, action);
            }
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            action.invoke((ConeClassLikeType)$this$forEachClassLikeType);
        }
    }

    private static final void check$consider(CheckerContext $context, Set<ConeKotlinType> missingTypes, ConeKotlinType type2) {
        Ref.BooleanRef hasError2 = new Ref.BooleanRef();
        Ref.BooleanRef hasMissingClass = new Ref.BooleanRef();
        INSTANCE.forEachClassLikeType(type2, (Function1<? super ConeClassLikeType, Unit>)new Function1<ConeClassLikeType, Unit>(hasError2, hasMissingClass, $context){
            final /* synthetic */ Ref.BooleanRef $hasError;
            final /* synthetic */ Ref.BooleanRef $hasMissingClass;
            final /* synthetic */ CheckerContext $context;
            {
                this.$hasError = $hasError;
                this.$hasMissingClass = $hasMissingClass;
                this.$context = $context;
                super(1);
            }

            public final void invoke(ConeClassLikeType it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it instanceof ConeErrorType) {
                    this.$hasError.element = true;
                } else {
                    this.$hasMissingClass.element = this.$hasMissingClass.element || LookupTagUtilsKt.toSymbol(it.getLookupTag(), this.$context.getSession()) == null;
                }
            }
        });
        if (hasMissingClass.element && !hasError2.element) {
            boolean $i$f$emptyArray = false;
            ConeKotlinType reportedType = TypeUtilsKt.withArguments(TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext($context.getSession()), null, false, 12, null), new ConeTypeProjection[0]);
            missingTypes.add(reportedType);
        }
    }
}

