/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirPureAbstractElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J/\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirIncompatibleClassExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSourceElement", "source", "Lksp/org/jetbrains/kotlin/descriptors/SourceElement;", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "checkType", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkType$checkers", "checkers"})
public final class FirIncompatibleClassExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirIncompatibleClassExpressionChecker INSTANCE = new FirIncompatibleClassExpressionChecker();

    private FirIncompatibleClassExpressionChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        this.checkType$checkers(symbol2.getResolvedReturnType(), expression2, context2, reporter);
        FirPureAbstractElement firPureAbstractElement = symbol2.getReceiverParameter();
        this.checkType$checkers(firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null, expression2, context2, reporter);
        if (symbol2 instanceof FirFunctionSymbol) {
            for (FirValueParameterSymbol parameter2 : ((FirFunctionSymbol)symbol2).getValueParameterSymbols()) {
                this.checkType$checkers(parameter2.getResolvedReturnTypeRef().getType(), expression2, context2, reporter);
            }
        }
        this.checkSourceElement(((FirCallableDeclaration)symbol2.getFir()).getContainerSource(), expression2, context2, reporter);
    }

    public final void checkType$checkers(@Nullable ConeKotlinType type2, @NotNull FirElement element2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol classSymbol2;
        Intrinsics.checkNotNullParameter(element2, "element");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType coneKotlinType = type2;
        FirRegularClassSymbol firRegularClassSymbol = classSymbol2 = coneKotlinType != null ? TypeUtilsKt.toRegularClassSymbol(coneKotlinType, context2.getSession()) : null;
        this.checkSourceElement(firRegularClassSymbol != null ? DeclarationAttributesKt.getSourceElement(firRegularClassSymbol) : null, element2, context2, reporter);
    }

    private final void checkSourceElement(SourceElement source, FirElement element2, CheckerContext context2, DiagnosticReporter reporter) {
        if (!(source instanceof DeserializedContainerSource)) {
            return;
        }
        IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
        if (incompatibility != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element2.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), incompatibility, (DiagnosticContext)context2, null, 32, null);
        }
        if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element2.getSource(), FirErrors.INSTANCE.getPRE_RELEASE_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), (DiagnosticContext)context2, null, 16, null);
        }
        if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.UNSTABLE) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element2.getSource(), FirErrors.INSTANCE.getIR_WITH_UNSTABLE_ABI_COMPILED_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

