/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import ksp.org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J2\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "()V", "isIfExpression", "", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "isWhenExpression", "missingCases", "", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)Ljava/util/List;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportElseMisplaced", "reportNoElseInWhen", "source", "whenExpression", "subjectClassSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "reportNotExhaustive", "AlgebraicTypeKind", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExhaustiveWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,117:1\n40#2:118\n48#2:119\n75#2:120\n37#3:121\n*S KotlinDebug\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n*L\n57#1:118\n78#1:119\n80#1:120\n80#1:121\n*E\n"})
public final class FirExhaustiveWhenChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirExhaustiveWhenChecker INSTANCE = new FirExhaustiveWhenChecker();

    private FirExhaustiveWhenChecker() {
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.reportNotExhaustive(expression2, context2, reporter);
        this.reportElseMisplaced(expression2, reporter, context2);
    }

    private final void reportNotExhaustive(FirWhenExpression whenExpression, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClassSymbol subjectClassSymbol;
        if (ExhaustivenessStatusKt.isExhaustive(whenExpression)) {
            return;
        }
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        Object object = whenExpression.getSubject();
        ConeSimpleKotlinType subjectType = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null ? ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)object) : null;
        ConeSimpleKotlinType coneSimpleKotlinType = subjectType;
        FirRegularClassSymbol firRegularClassSymbol = coneSimpleKotlinType != null && (coneSimpleKotlinType = TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, context2.getSession())) != null ? TypeUtilsKt.toRegularClassSymbol(coneSimpleKotlinType, context2.getSession()) : (subjectClassSymbol = null);
        if (whenExpression.getUsedAsExpression()) {
            if (this.isIfExpression(source)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            if (this.isWhenExpression(source)) {
                this.reportNoElseInWhen(reporter, source, whenExpression, subjectClassSymbol, context2);
            }
        } else {
            AlgebraicTypeKind algebraicTypeKind;
            if (subjectClassSymbol == null) {
                return;
            }
            FirClassLikeSymbol $this$modality$iv = subjectClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
                algebraicTypeKind = AlgebraicTypeKind.Sealed;
            } else if (subjectClassSymbol.getClassKind() == ClassKind.ENUM_CLASS) {
                algebraicTypeKind = AlgebraicTypeKind.Enum;
            } else if (ConeBuiltinTypeUtilsKt.isBooleanOrNullableBoolean(subjectType)) {
                algebraicTypeKind = AlgebraicTypeKind.Boolean;
            } else {
                return;
            }
            AlgebraicTypeKind kind = algebraicTypeKind;
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitNonExhaustiveWhenOnAlgebraicTypes)) {
                this.reportNoElseInWhen(reporter, source, whenExpression, subjectClassSymbol, context2);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_EXHAUSTIVE_WHEN_STATEMENT(), (Object)kind.getDisplayName(), this.getMissingCases(whenExpression), (DiagnosticContext)context2, null, 32, null);
            }
        }
    }

    private final void reportNoElseInWhen(DiagnosticReporter reporter, KtSourceElement source, FirWhenExpression whenExpression, FirRegularClassSymbol subjectClassSymbol, CheckerContext context2) {
        String string2;
        Boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = subjectClassSymbol;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = null;
        }
        if (Intrinsics.areEqual(bl, true)) {
            FirClassSymbol $this$isEnumClass$iv = subjectClassSymbol;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            String declarationType = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? "enum" : "sealed";
            string2 = " ('when' with expect " + declarationType + " subject cannot be exhaustive without else branch)";
        } else {
            string2 = "";
        }
        String description2 = string2;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), this.getMissingCases(whenExpression), (Object)description2, (DiagnosticContext)context2, null, 32, null);
    }

    private final List<WhenMissingCase> getMissingCases(FirWhenExpression $this$missingCases) {
        ExhaustivenessStatus exhaustivenessStatus = $this$missingCases.getExhaustivenessStatus();
        Intrinsics.checkNotNull(exhaustivenessStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus.NotExhaustive");
        return ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus).getReasons();
    }

    private final void reportElseMisplaced(FirWhenExpression expression2, DiagnosticReporter reporter, CheckerContext context2) {
        int branchesCount = expression2.getBranches().size();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)expression2.getBranches())) {
            FirWhenBranch branch = (FirWhenBranch)indexedValue.getValue();
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition) || indexedValue.getIndex() >= branchesCount - 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)branch.getSource(), FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isIfExpression(KtSourceElement $this$isIfExpression) {
        return Intrinsics.areEqual($this$isIfExpression.getElementType(), KtNodeTypes.IF);
    }

    private final boolean isWhenExpression(KtSourceElement $this$isWhenExpression) {
        return Intrinsics.areEqual($this$isWhenExpression.getElementType(), KtNodeTypes.WHEN);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker$AlgebraicTypeKind;", "", "displayName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "checkers"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value2) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value2);
        }

        @NotNull
        public static EnumEntries<AlgebraicTypeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

