/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeResolutionResultOverridesOtherToPreserveCompatibility;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationReferenceChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallableReferenceAccessChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCustomEnumEntriesMigrationReferenceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCustomEnumEntriesMigrationReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationReferenceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,27:1\n1745#2,3:28\n*S KotlinDebug\n*F\n+ 1 FirCustomEnumEntriesMigrationReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCustomEnumEntriesMigrationReferenceChecker\n*L\n21#1:28,3\n*E\n"})
public final class FirCustomEnumEntriesMigrationReferenceChecker
extends FirExpressionChecker<FirCallableReferenceAccess> {
    @NotNull
    public static final FirCustomEnumEntriesMigrationReferenceChecker INSTANCE = new FirCustomEnumEntriesMigrationReferenceChecker();

    private FirCustomEnumEntriesMigrationReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirCallableReferenceAccess expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.PrioritizedEnumEntries)) {
            return;
        }
        if (Intrinsics.areEqual(expression2.getCalleeReference().getName(), StandardNames.ENUM_ENTRIES)) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = expression2.getNonFatalDiagnostics();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeDiagnostic it = (ConeDiagnostic)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ConeResolutionResultOverridesOtherToPreserveCompatibility)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENUM_ENTRY_PROPERTY_AS_REFERENCE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

