/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.CastingType;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirCastOperatorsChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirCastOperatorsChecker INSTANCE = new FirCastOperatorsChecker();

    private FirCastOperatorsChecker() {
    }

    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isSafeAs;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSession session2 = context2.getSession();
        FirExpression firstArgument = expression2.getArgumentList().getArguments().get(0);
        ConeKotlinType actualType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getResolvedType(FirExpressionUtilKt.unwrapSmartcastExpression(firstArgument)), session2);
        FirTypeRef conversionTypeRef = expression2.getConversionTypeRef();
        ConeKotlinType targetType = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(conversionTypeRef), session2);
        if (FirOperation.Companion.getTYPES().contains((Object)expression2.getOperation()) && targetType instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conversionTypeRef.getSource(), FirErrors.INSTANCE.getDYNAMIC_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
        boolean bl = isSafeAs = expression2.getOperation() == FirOperation.SAFE_AS;
        if (expression2.getOperation() == FirOperation.AS || isSafeAs) {
            CastingType castType2 = FirCastDiagnosticsHelpersKt.checkCasting(actualType, targetType, isSafeAs, context2);
            if (castType2 == CastingType.Impossible) {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCAST_NEVER_SUCCEEDS(), (DiagnosticContext)context2, null, 8, null);
                }
            } else if (castType2 == CastingType.Always) {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CAST(), (DiagnosticContext)context2, null, 8, null);
                }
            } else if (FirCastDiagnosticsHelpersKt.isCastErased(actualType, targetType, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNCHECKED_CAST(), (Object)actualType, (Object)targetType, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (expression2.getOperation() == FirOperation.IS && !context2.isContractBody() && FirCastDiagnosticsHelpersKt.isCastErased(actualType, targetType, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conversionTypeRef.getSource(), FirErrors.INSTANCE.getCANNOT_CHECK_FOR_ERASED(), (Object)targetType, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

