/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DanglingTypeConstraint;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeConstraintsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeConstraintsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeConstraintsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeConstraintsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1853#2,2:35\n*S KotlinDebug\n*F\n+ 1 FirTypeConstraintsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeConstraintsChecker\n*L\n22#1:35,2\n*E\n"})
public final class FirTypeConstraintsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirTypeConstraintsChecker INSTANCE = new FirTypeConstraintsChecker();

    private FirTypeConstraintsChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirTypeParameterRefsOwner)) {
            return;
        }
        Iterable $this$forEach$iv = DeclarationAttributesKt.getDanglingTypeConstraintsOrEmpty(declaration2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DanglingTypeConstraint constraint = (DanglingTypeConstraint)element$iv;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constraint.getSource(), FirErrors.INSTANCE.getNAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER(), (Object)constraint.getName(), declaration2.getSymbol(), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

