/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000e\u001a\u00020\r*\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasGenericOuterDeclaration", "", "hasThrowableSupertype", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirThrowableSubclassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n38#2:61\n54#2:62\n54#2:66\n38#2:67\n1745#3,3:63\n*S KotlinDebug\n*F\n+ 1 FirThrowableSubclassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirThrowableSubclassChecker\n*L\n31#1:61\n31#1:62\n53#1:66\n53#1:67\n45#1:63,3\n*E\n"})
public final class FirThrowableSubclassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirThrowableSubclassChecker INSTANCE = new FirThrowableSubclassChecker();

    private FirThrowableSubclassChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!this.hasThrowableSupertype(declaration2, context2)) {
            return;
        }
        if (!((Collection)declaration2.getTypeParameters()).isEmpty()) {
            boolean bl;
            Object object = CollectionsKt.firstOrNull(declaration2.getTypeParameters());
            if (object != null && (object = object.getSource()) != null) {
                Object it = object;
                boolean bl2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context2, null, 8, null);
            }
            FirClass firClass = declaration2;
            if (firClass instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = declaration2;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) {
                    FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                    boolean $i$f$isLocal = false;
                    if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) return;
                }
                bl = true;
            } else {
                if (!(firClass instanceof FirAnonymousObject)) return;
                bl = true;
            }
            boolean shouldReport = bl;
            if (!shouldReport) return;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (!this.hasGenericOuterDeclaration(declaration2, context2)) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean hasThrowableSupertype(FirClass $this$hasThrowableSupertype, CheckerContext context2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes($this$hasThrowableSupertype);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof ConeErrorType) && FirHelpersKt.isSubtypeOfThrowable(it, context2.getSession()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasGenericOuterDeclaration(FirClass $this$hasGenericOuterDeclaration, CheckerContext context2) {
        if (!FirDeclarationUtilKt.getClassId($this$hasGenericOuterDeclaration).isLocal()) {
            return false;
        }
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (containingDeclaration instanceof FirTypeParameterRefsOwner && !((Collection)((FirTypeParameterRefsOwner)((Object)containingDeclaration)).getTypeParameters()).isEmpty()) {
                return true;
            }
            if (!(containingDeclaration instanceof FirRegularClass)) continue;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)containingDeclaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) continue;
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)containingDeclaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) continue;
            return false;
        }
        return false;
    }
}

