/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirImport;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportIfUnderscore", "isSingleUnderscoreAllowed", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReservedUnderscoreDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1853#2,2:88\n*S KotlinDebug\n*F\n+ 1 FirReservedUnderscoreDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker\n*L\n31#1:88,2\n*E\n"})
public final class FirReservedUnderscoreDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReservedUnderscoreDeclarationChecker INSTANCE = new FirReservedUnderscoreDeclarationChecker();

    private FirReservedUnderscoreDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter(declaration2, "declaration");
                        Intrinsics.checkNotNullParameter(context2, "context");
                        Intrinsics.checkNotNullParameter(reporter, "reporter");
                        if (!(declaration2 instanceof FirRegularClass) && (!(declaration2 instanceof FirProperty) || Intrinsics.areEqual(ClassMembersKt.isCatchParameter((FirProperty)declaration2), true)) && !(declaration2 instanceof FirTypeAlias)) break block4;
                        FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                        break block5;
                    }
                    if (!(declaration2 instanceof FirTypeParameter)) break block6;
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                    Iterable $this$forEach$iv = ((FirTypeParameter)declaration2).getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl = false;
                        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(it, context2, reporter);
                    }
                    break block5;
                }
                if (!(declaration2 instanceof FirFunction)) break block7;
                if (declaration2 instanceof FirSimpleFunction) {
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                }
                boolean isSingleUnderscoreAllowed = declaration2 instanceof FirAnonymousFunction || declaration2 instanceof FirPropertyAccessor;
                for (FirValueParameter parameter2 : ((FirFunction)declaration2).getValueParameters()) {
                    this.reportIfUnderscore(parameter2, context2, reporter, isSingleUnderscoreAllowed);
                }
                break block5;
            }
            if (!(declaration2 instanceof FirFile)) break block5;
            for (FirImport firImport : ((FirFile)declaration2).getImports()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(firImport.getAliasSource(), context2, reporter, false);
            }
        }
    }

    private final void reportIfUnderscore(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed) {
        FirDeclaration firDeclaration;
        KtSourceElement declarationSource = declaration2.getSource();
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind)) {
            FirProperty firProperty = declaration2 instanceof FirProperty ? (FirProperty)declaration2 : null;
            if (!Intrinsics.areEqual(firProperty != null ? firProperty.getName() : null, SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
                String rawName;
                SourceNavigator $this$reportIfUnderscore_u24lambda_u241 = SourceNavigator.Companion.forElement(declaration2);
                boolean bl = false;
                String string2 = rawName = $this$reportIfUnderscore_u24lambda_u241.getRawName(declaration2);
                boolean bl2 = string2 != null ? FirUnderscoreHelpersKt.isUnderscore(string2) : false;
                if (!(!bl2 || isSingleUnderscoreAllowed && Intrinsics.areEqual(rawName, "_"))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        if ((firDeclaration = declaration2) instanceof FirValueParameter) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(((FirValueParameter)declaration2).getReturnTypeRef(), context2, reporter);
        } else if (firDeclaration instanceof FirFunction) {
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(((FirFunction)declaration2).getReturnTypeRef(), context2, reporter);
            FirReceiverParameter firReceiverParameter = ((FirFunction)declaration2).getReceiverParameter();
            FirUnderscoreHelpersKt.checkTypeRefForUnderscore(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, context2, reporter);
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirReservedUnderscoreDeclarationChecker firReservedUnderscoreDeclarationChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        firReservedUnderscoreDeclarationChecker.reportIfUnderscore(firDeclaration, checkerContext, diagnosticReporter, bl);
    }
}

