/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyInitializationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirPropertyInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirPropertyInitializationChecker INSTANCE = new FirPropertyInitializationChecker();

    private FirPropertyInitializationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Set declaredLater = new LinkedHashSet();
        FirVisitorVoid visitor2 = new FirVisitorVoid(declaredLater, reporter, context2){
            final /* synthetic */ Set<FirPropertySymbol> $declaredLater;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaredLater = $declaredLater;
                this.$reporter = $reporter;
                this.$context = $context;
            }

            public void visitElement(FirElement element2) {
                Intrinsics.checkNotNullParameter(element2, "element");
                element2.acceptChildren(this);
            }

            public void visitConstructor(FirConstructor constructor2) {
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
            }

            public void visitSimpleFunction(FirSimpleFunction simpleFunction) {
                Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            }

            public void visitPropertyAccessor(FirPropertyAccessor propertyAccessor) {
                Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
            }

            public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction) {
                Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
            }

            public void visitRegularClass(FirRegularClass regularClass) {
                Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            }

            public void visitEnumEntry(FirEnumEntry enumEntry) {
                Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            }

            public void visitVariableAssignment(FirVariableAssignment variableAssignment) {
                Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
                variableAssignment.acceptChildren(this);
                FirReference firReference = FirExpressionUtilKt.getCalleeReference(variableAssignment);
                FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
                FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol propertySymbol = firPropertySymbol;
                if (!this.$declaredLater.contains(propertySymbol)) {
                    return;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)variableAssignment.getLValue().getSource(), FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), (Object)propertySymbol, (DiagnosticContext)this.$context, null, 16, null);
            }
        };
        for (FirDeclaration member2 : CollectionsKt.asReversed(declaration2.getDeclarations())) {
            if (!((Collection)declaredLater).isEmpty()) {
                member2.accept(visitor2);
            }
            if (!(member2 instanceof FirProperty)) continue;
            declaredLater.add(((FirProperty)member2).getSymbol());
        }
    }
}

