/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.Variance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "ProjectionRelation", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirProjectionRelationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProjectionRelationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n22#2,4:102\n1#3:106\n*S KotlinDebug\n*F\n+ 1 FirProjectionRelationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker\n*L\n48#1:102,4\n*E\n"})
public final class FirProjectionRelationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirProjectionRelationChecker INSTANCE = new FirProjectionRelationChecker();

    private FirProjectionRelationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration2 instanceof FirCallableDeclaration) {
            this.checkTypeRef(((FirCallableDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
        }
        if ((firDeclaration = declaration2) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration2).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeRef(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        ConeClassLikeType type2;
        ConeClassLikeType coneClassLikeType;
        Object object = typeRef.getSource();
        if (!(object != null && (object = ((KtSourceElement)object).getKind()) != null ? !((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((coneClassLikeType = (type2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)))) == null || (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, context2.getSession(), null, 2, null)) == null) {
            return;
        }
        ConeClassLikeType fullyExpandedType2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declaration2 = firRegularClassSymbol;
        List<FirTypeParameterSymbol> typeParameters2 = declaration2.getTypeParameterSymbols();
        ConeTypeProjection[] typeArguments2 = type2.getTypeArguments();
        int size = Math.min(typeParameters2.size(), typeArguments2.length);
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
        if (list2 == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        for (int it = 0; it < size; ++it) {
            FirTypeRef it2;
            FirTypeRefSource argTypeRefSource;
            ProjectionRelation projectionRelation;
            FirTypeParameterSymbol proto = typeParameters2.get(it);
            ConeTypeProjection actual = typeArguments2[it];
            ConeTypeProjection fullyExpandedProjection = fullyExpandedType2.getTypeArguments()[it];
            Variance protoVariance = proto.getVariance();
            ProjectionRelation projectionRelation2 = fullyExpandedProjection instanceof ConeKotlinTypeConflictingProjection || actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.OUT_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.IN_VARIANCE ? ProjectionRelation.Conflicting : (projectionRelation = actual instanceof ConeKotlinTypeProjectionIn && protoVariance == Variance.IN_VARIANCE || actual instanceof ConeKotlinTypeProjectionOut && protoVariance == Variance.OUT_VARIANCE ? ProjectionRelation.Redundant : ProjectionRelation.None);
            if (CollectionsKt.getOrNull(typeRefAndSourcesForArguments, it) == null) continue;
            if (projectionRelation != ProjectionRelation.None) {
                KtSourceElement ktSourceElement = typeRef.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                    KtSourceElement ktSourceElement2 = argTypeRefSource.getSource();
                    if (ktSourceElement2 == null) {
                        FirTypeRef firTypeRef = argTypeRefSource.getTypeRef();
                        ktSourceElement2 = firTypeRef != null ? firTypeRef.getSource() : null;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement2, projectionRelation == ProjectionRelation.Conflicting ? (!Intrinsics.areEqual(type2, fullyExpandedType2) ? FirErrors.INSTANCE.getCONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION() : FirErrors.INSTANCE.getCONFLICTING_PROJECTION()) : FirErrors.INSTANCE.getREDUNDANT_PROJECTION(), (Object)fullyExpandedType2, (DiagnosticContext)context2, null, 16, null);
                }
            }
            if (argTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkTypeRef(it2, context2, reporter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirProjectionRelationChecker$ProjectionRelation;", "", "(Ljava/lang/String;I)V", "Conflicting", "Redundant", "None", "checkers"})
    private static final class ProjectionRelation
    extends Enum<ProjectionRelation> {
        public static final /* enum */ ProjectionRelation Conflicting = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation Redundant = new ProjectionRelation();
        public static final /* enum */ ProjectionRelation None = new ProjectionRelation();
        private static final /* synthetic */ ProjectionRelation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProjectionRelation[] values() {
            return (ProjectionRelation[])$VALUES.clone();
        }

        public static ProjectionRelation valueOf(String value2) {
            return Enum.valueOf(ProjectionRelation.class, value2);
        }

        @NotNull
        public static EnumEntries<ProjectionRelation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = projectionRelationArray = new ProjectionRelation[]{ProjectionRelation.Conflicting, ProjectionRelation.Redundant, ProjectionRelation.None};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

