/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuperTypeNotInitialized", "primaryConstructorSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "regularClass", "checkSupertypeInitializedWithoutPrimaryConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrimaryConstructorSuperTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,118:1\n57#2:119\n34#3:120\n40#3:121\n56#4,11:122\n20#4,2:133\n*S KotlinDebug\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n*L\n31#1:119\n31#1:120\n42#1:121\n68#1:122,11\n68#1:133,2\n*E\n"})
public final class FirPrimaryConstructorSuperTypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirPrimaryConstructorSuperTypeChecker INSTANCE = new FirPrimaryConstructorSuperTypeChecker();

    private FirPrimaryConstructorSuperTypeChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirClass $this$isInterface$iv = declaration2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration2);
            boolean bl2 = false;
            for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
                if (!$this$check_u24lambda_u240.isInConstructorCallee(superTypeRef)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
            }
            return;
        }
        ClassKind $this$isEnumEntry$iv = declaration2.getClassKind();
        boolean $i$f$isEnumEntry = false;
        if ($this$isEnumEntry$iv == ClassKind.ENUM_ENTRY) {
            return;
        }
        FirConstructorSymbol primaryConstructorSymbol = ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if (primaryConstructorSymbol == null || FirDeclarationUtilKt.isErrorPrimaryConstructor(primaryConstructorSymbol)) {
            this.checkSupertypeInitializedWithoutPrimaryConstructor(declaration2, reporter, context2);
        } else {
            this.checkSuperTypeNotInitialized(primaryConstructorSymbol, declaration2, context2, reporter);
        }
    }

    private final void checkSuperTypeNotInitialized(FirConstructorSymbol primaryConstructorSymbol, FirClass regularClass, CheckerContext context2, DiagnosticReporter reporter) {
        Iterator<Object> iterator2;
        block14: {
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Iterator<Object> element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClass)) continue;
                        iterator2 = element$iv;
                        break block14;
                    } while (0 <= n);
                }
                iterator2 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed($this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClass)) continue;
                    iterator2 = (Iterator<Object>)element$iv$iv;
                    break block14;
                }
                iterator2 = null;
            }
        }
        FirRegularClass containingClass = (FirRegularClass)((Object)iterator2);
        FirDelegatedConstructorCall firDelegatedConstructorCall = primaryConstructorSymbol.getResolvedDelegatedConstructorCall();
        if (firDelegatedConstructorCall == null) {
            return;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = firDelegatedConstructorCall;
        FirTypeRef constructedTypeRef = delegatedConstructorCall.getConstructedTypeRef();
        if (constructedTypeRef instanceof FirImplicitAnyTypeRef) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(constructedTypeRef), context2.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol superClassSymbol = firRegularClassSymbol;
        if (superClassSymbol.getClassKind().isSingleton()) {
            return;
        }
        if (DeclarationUtilsKt.isEffectivelyExpect(regularClass, containingClass, context2) || DeclarationUtilsKt.isEffectivelyExternal(regularClass, containingClass, context2)) {
            return;
        }
        KtSourceElement ktSourceElement = delegatedConstructorCall.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement delegatedCallSource = ktSourceElement;
        if (!(delegatedCallSource.getKind() instanceof KtFakeSourceElementKind)) {
            return;
        }
        Set<ClassId> supertypesToSkip = FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt.getPrimaryConstructorSuperTypePlatformSupport(context2.getSession()).getSupertypesThatDontNeedInitializationInSubtypesConstructors();
        if (supertypesToSkip.contains(superClassSymbol.getClassId())) {
            return;
        }
        if (!Intrinsics.areEqual(delegatedCallSource.getElementType(), KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructedTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkSupertypeInitializedWithoutPrimaryConstructor(FirClass regularClass, DiagnosticReporter reporter, CheckerContext context2) {
        SourceNavigator $this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241 = SourceNavigator.Companion.forElement(regularClass);
        boolean bl = false;
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            if (!$this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u241.isInConstructorCallee(superTypeRef)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)regularClass.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

