/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "shouldReportOpenFromSource", "", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "getShouldReportOpenFromSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOpenMemberChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,52:1\n13#2:53\n40#2:54\n*S KotlinDebug\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n*L\n33#1:53\n33#1:54\n*E\n"})
public final class FirOpenMemberChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOpenMemberChecker INSTANCE = new FirOpenMemberChecker();

    private FirOpenMemberChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (DeclarationUtilsKt.getCanHaveOpenMembers(declaration2)) {
            return;
        }
        for (FirDeclaration memberDeclaration : declaration2.getDeclarations()) {
            KtSourceElement source;
            block7: {
                block6: {
                    if (!(memberDeclaration instanceof FirCallableDeclaration) || memberDeclaration instanceof FirConstructor || memberDeclaration.getSource() == null) continue;
                    FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)memberDeclaration;
                    boolean $i$f$isOpen = false;
                    if (!($this$isOpen$iv.getStatus().getModality() == Modality.OPEN)) break block6;
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)memberDeclaration;
                    boolean $i$f$isOverride = false;
                    if (!$this$isOverride$iv.getStatus().isOverride() && declaration2.getClassKind() == ClassKind.ANNOTATION_CLASS) break block7;
                }
                FirElement firElement = memberDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPEN_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken) || !this.getShouldReportOpenFromSource(source)) continue;
            }
            if (declaration2.getClassKind() == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean getShouldReportOpenFromSource(KtSourceElement $this$shouldReportOpenFromSource) {
        KtSourceElementKind ktSourceElementKind = $this$shouldReportOpenFromSource.getKind();
        return Intrinsics.areEqual(ktSourceElementKind, KtRealSourceElementKind.INSTANCE) ? true : Intrinsics.areEqual(ktSourceElementKind, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }
}

