/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinePropertyChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlinePropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlinePropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinePropertyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,34:1\n43#2:35\n*S KotlinDebug\n*F\n+ 1 FirInlinePropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlinePropertyChecker\n*L\n19#1:35\n*E\n"})
public final class FirInlinePropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInlinePropertyChecker INSTANCE = new FirInlinePropertyChecker();

    private FirInlinePropertyChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        boolean $i$f$isInline;
        FirMemberDeclaration $this$isInline$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirPropertyAccessor firPropertyAccessor = declaration2.getGetter();
        if (firPropertyAccessor != null) {
            $this$isInline$iv = firPropertyAccessor;
            $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        } else {
            bl = false;
        }
        if (!bl) {
            boolean bl2;
            FirPropertyAccessor firPropertyAccessor2 = declaration2.getSetter();
            if (firPropertyAccessor2 != null) {
                $this$isInline$iv = firPropertyAccessor2;
                $i$f$isInline = false;
                bl2 = $this$isInline$iv.getStatus().isInline();
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return;
            }
        }
        FirInlineDeclarationChecker.INSTANCE.checkCallableDeclaration(declaration2, context2, reporter);
        if (DeclarationAttributesKt.getHasBackingField(declaration2) || declaration2.getDelegate() != null) {
            KtSourceElement ktSourceElement = declaration2.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINLINE_PROPERTY_WITH_BACKING_FIELD_DEPRECATION(), (DiagnosticContext)context2, null, 8, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getINLINE_PROPERTY_WITH_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

