/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.BlockExitNode;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionReturnChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkHasReturnIfBlock", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunctionReturnChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunctionReturnChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionReturnChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n533#2,6:47\n*S KotlinDebug\n*F\n+ 1 FirFunctionReturnChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionReturnChecker\n*L\n41#1:47,6\n*E\n"})
public final class FirFunctionReturnChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirFunctionReturnChecker INSTANCE = new FirFunctionReturnChecker();

    private FirFunctionReturnChecker() {
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkHasReturnIfBlock(declaration2, reporter, context2);
    }

    private final void checkHasReturnIfBlock(FirFunction declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        CFGNode<?> cFGNode;
        block8: {
            if (declaration2 instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration2).isSetter()) {
                return;
            }
            if (declaration2 instanceof FirConstructor) {
                return;
            }
            if (declaration2 instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration2).isLambda()) {
                return;
            }
            ConeKotlinType returnType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession());
            if (ConeBuiltinTypeUtilsKt.isUnit(returnType2)) {
                return;
            }
            Object object = declaration2.getControlFlowGraphReference();
            if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
                return;
            }
            Object graph = object;
            List<CFGNode<?>> $this$lastOrNull$iv = ((ControlFlowGraph)graph).getExitNode().getPreviousNodes();
            boolean $i$f$lastOrNull = false;
            ListIterator<CFGNode<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                CFGNode<?> element$iv;
                CFGNode<?> it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof BlockExitNode)) continue;
                cFGNode = element$iv;
                break block8;
            }
            cFGNode = null;
        }
        CFGNode cFGNode2 = cFGNode;
        if (cFGNode2 == null) {
            return;
        }
        CFGNode blockExitNode = cFGNode2;
        if (!blockExitNode.isDead()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

