/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataObjectContentChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDataObjectContentChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirDataObjectContentChecker INSTANCE = new FirDataObjectContentChecker();

    private FirDataObjectContentChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElement source;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                FirElement firElement = declaration2;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OVERRIDE_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
                    return;
                }
                source = declaration2.getSource();
                if (source == null || source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass firClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
                if (firClass == null) {
                    return;
                }
                FirClass containingClass = firClass;
                if (containingClass.getClassKind() != ClassKind.OBJECT) break block7;
                FirElement firElement2 = containingClass;
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.DATA_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "DATA_KEYWORD");
                if (FirKeywordUtilsKt.hasModifier(firElement2, ktModifierKeywordToken2)) break block8;
            }
            return;
        }
        if (FirDeclarationUtilKt.isMethodOfAny(declaration2.getSymbol()) && !Intrinsics.areEqual(declaration2.getName(), OperatorNameConventions.TO_STRING)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

