/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a-\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0016H\u0082\b\u001a\u001e\u0010\u0017\u001a\u00020\u0001*\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u001e\u0010\u0019\u001a\u00020\u0001*\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u001b\u001a\u00020\u0001*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010\u001b\u001a\u00020\u0001*\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0018\u0010 \u001a\u0004\u0018\u00010!*\u0006\u0012\u0002\b\u00030\"2\u0006\u0010\u001d\u001a\u00020\u001e\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0019\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001c\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u001c\u0010\n\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000e\u00a8\u0006#"}, d2={"canHaveOpenMembers", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasExplicitReturnType", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getHasExplicitReturnType", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isExtensionMember", "isLocalMember", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isInsideExpectClass", "containingClass", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "Lksp/org/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isEffectivelyExternal", "isEffectivelyFinal", "needsMultiFieldValueClassFlattening", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "primaryConstructorSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\ndeclarationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,113:1\n35#1:114\n36#1:116\n35#1:120\n36#1:122\n37#2:115\n45#2:121\n17#2,2:129\n60#2:131\n17#2,2:133\n37#2:135\n45#2:136\n45#2:137\n1745#3,3:117\n1745#3,3:123\n1745#3,3:126\n37#4:132\n62#5:138\n82#5:139\n*S KotlinDebug\n*F\n+ 1 declarationUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationUtilsKt\n*L\n22#1:114\n22#1:116\n26#1:120\n26#1:122\n22#1:115\n26#1:121\n40#1:129,2\n42#1:131\n46#1:133,2\n53#1:135\n62#1:136\n72#1:137\n22#1:117,3\n26#1:123,3\n36#1:126,3\n42#1:132\n89#1:138\n90#1:139\n*E\n"})
public final class DeclarationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = klass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = klass;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = klass;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = klass;
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideSpecificClass(FirClass containingClass, CheckerContext context2, Function1<? super FirClass, Boolean> predicate) {
        boolean bl;
        boolean $i$f$isInsideSpecificClass = false;
        if (predicate.invoke(containingClass) != false) return true;
        Iterable $this$any$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if (it instanceof FirRegularClass && predicate.invoke((FirClass)it).booleanValue()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyFinal(@NotNull FirMemberDeclaration $this$isEffectivelyFinal, @NotNull CheckerContext context2) {
        Modality modality$iv;
        Object modality$iv2;
        Intrinsics.checkNotNullParameter($this$isEffectivelyFinal, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirMemberDeclaration $this$isFinal$iv = $this$isEffectivelyFinal;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (modality == null ? true : (modality$iv2 = modality) == Modality.FINAL) {
            return true;
        }
        modality$iv2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirRegularClass firRegularClass = modality$iv2 instanceof FirRegularClass ? (FirRegularClass)modality$iv2 : null;
        if (firRegularClass == null) {
            return true;
        }
        FirRegularClass containingClass = firRegularClass;
        FirClass $this$isEnumClass$iv = containingClass;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            return false;
        }
        FirMemberDeclaration $this$isFinal$iv2 = containingClass;
        boolean $i$f$isFinal2 = false;
        Modality modality2 = $this$isFinal$iv2.getStatus().getModality();
        return modality2 == null ? true : (modality$iv = modality2) == Modality.FINAL;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExpect, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExpectClass(containingClass, context2);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        block9: {
            block10: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isExternal;
                Intrinsics.checkNotNullParameter($this$isEffectivelyExternal, "<this>");
                Intrinsics.checkNotNullParameter(context2, "context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    FirDeclaration firDeclaration = CollectionsKt.last(context2.getContainingDeclarations());
                    Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirProperty");
                    FirProperty property = (FirProperty)firDeclaration;
                    return DeclarationUtilsKt.isEffectivelyExternal(property, containingClass, context2);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor != null) {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor2 != null) {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor2;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExternalClass(containingClass, context2);
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter($this$canHaveOpenMembers, "<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        return DeclarationUtilsKt.isLocalMember($this$isLocalMember.getSymbol());
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual($this$isLocal$iv.getRawStatus().getVisibility(), Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, "<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }

    @Nullable
    public static final FirConstructorSymbol primaryConstructorSymbol(@NotNull FirClassSymbol<?> $this$primaryConstructorSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$primaryConstructorSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny((FirClass)$this$primaryConstructorSymbol.getFir(), session2);
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull FirTypeRef $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$needsMultiFieldValueClassFlattening, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        return DeclarationUtilsKt.needsMultiFieldValueClassFlattening(FirTypeUtilsKt.getConeType($this$needsMultiFieldValueClassFlattening), session2);
    }

    public static final boolean needsMultiFieldValueClassFlattening(@NotNull ConeKotlinType $this$needsMultiFieldValueClassFlattening, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$needsMultiFieldValueClassFlattening, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ConeInferenceContext $this$needsMultiFieldValueClassFlattening_u24lambda_u243 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return $this$needsMultiFieldValueClassFlattening_u24lambda_u243.isMultiFieldValueClass($this$needsMultiFieldValueClassFlattening_u24lambda_u243.typeConstructor($this$needsMultiFieldValueClassFlattening)) && !ConeTypeUtilsKt.isNullable($this$needsMultiFieldValueClassFlattening);
    }

    public static final boolean getHasExplicitReturnType(@NotNull FirCallableSymbol<?> $this$hasExplicitReturnType) {
        Intrinsics.checkNotNullParameter($this$hasExplicitReturnType, "<this>");
        FirResolvedTypeRef returnTypeRef = $this$hasExplicitReturnType.getResolvedReturnTypeRef();
        return returnTypeRef.getDelegatedTypeRef() != null || returnTypeRef instanceof FirImplicitUnitTypeRef;
    }
}

