/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics.rendering;

import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0004j\b\u0012\u0004\u0012\u00020\u0001`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/diagnostics/rendering/RootDiagnosticRendererFactory;", "Lksp/org/jetbrains/kotlin/diagnostics/rendering/DiagnosticRendererFactory;", "()V", "factories", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "invoke", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "diagnostic", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnostic;", "registerFactory", "", "factory", "frontend.common"})
public final class RootDiagnosticRendererFactory
implements DiagnosticRendererFactory {
    @NotNull
    public static final RootDiagnosticRendererFactory INSTANCE = new RootDiagnosticRendererFactory();
    @NotNull
    private static final LinkedHashSet<DiagnosticRendererFactory> factories = new LinkedHashSet();
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();

    private RootDiagnosticRendererFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KtDiagnosticRenderer invoke(@NotNull KtDiagnostic diagnostic) {
        KtDiagnosticRenderer ktDiagnosticRenderer;
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Lock lock = RootDiagnosticRendererFactory.lock;
        lock.lock();
        try {
            boolean bl = false;
            for (DiagnosticRendererFactory factory2 : factories) {
                KtDiagnosticRenderer renderer2;
                KtDiagnosticRenderer ktDiagnosticRenderer2 = renderer2 = factory2.invoke(diagnostic);
                if (ktDiagnosticRenderer2 == null) continue;
                KtDiagnosticRenderer ktDiagnosticRenderer3 = ktDiagnosticRenderer2;
                return ktDiagnosticRenderer3;
            }
            ktDiagnosticRenderer = diagnostic.getFactory().getKtRenderer();
        }
        finally {
            lock.unlock();
        }
        return ktDiagnosticRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFactory(@NotNull DiagnosticRendererFactory factory2) {
        Intrinsics.checkNotNullParameter(factory2, "factory");
        Lock lock = RootDiagnosticRendererFactory.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = factories.add(factory2);
        }
        finally {
            lock.unlock();
        }
    }
}

