/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics;

import java.util.List;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import ksp.org.jetbrains.kotlin.diagnostics.Severity;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.annotations.NotNull;

public interface DiagnosticSink {
    public static final DiagnosticSink DO_NOTHING = new DiagnosticSink(){

        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        @Override
        public boolean wantsDiagnostics() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "ksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink$1", "report"));
        }
    };
    public static final DiagnosticSink THROW_EXCEPTION = new DiagnosticSink(){

        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                2.$$$reportNull$$$0(0);
            }
            if (diagnostic.getSeverity() == Severity.ERROR) {
                PsiFile psiFile = diagnostic.getPsiFile();
                List<TextRange> textRanges = diagnostic.getTextRanges();
                String diagnosticText = DefaultErrorMessages.render(diagnostic);
                throw new IllegalStateException(diagnostic.getFactory().getName() + ": " + diagnosticText + " " + PsiDiagnosticUtils.atLocation(psiFile, textRanges.get(0)));
            }
        }

        @Override
        public boolean wantsDiagnostics() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "ksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink$2", "report"));
        }
    };

    public void report(@NotNull Diagnostic var1);

    @Deprecated
    default public void setCallback(@NotNull DiagnosticsCallback callback) {
        if (callback == null) {
            DiagnosticSink.$$$reportNull$$$0(0);
        }
        this.setCallbackIfNotSet(callback);
    }

    default public boolean setCallbackIfNotSet(@NotNull DiagnosticsCallback callback) {
        if (callback == null) {
            DiagnosticSink.$$$reportNull$$$0(1);
        }
        return false;
    }

    default public void resetCallback() {
    }

    public boolean wantsDiagnostics();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "callback";
        objectArray2[1] = "ksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setCallback";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCallbackIfNotSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DiagnosticsCallback {
        public void callback(Diagnostic var1);
    }
}

