/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.ide.highlighter.JavaClassFileType;
import ksp.com.intellij.ide.highlighter.JavaFileType;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import ksp.org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import ksp.org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import ksp.org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import ksp.org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import ksp.org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration;
import ksp.org.jetbrains.kotlin.config.CompilerConfigurationKey;
import ksp.org.jetbrains.kotlin.config.JVMConfigurationKeys;
import ksp.org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import ksp.org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import ksp.org.jetbrains.kotlin.idea.KotlinFileType;
import ksp.org.jetbrains.kotlin.modules.Module;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u001c\u0010\u0012\u001a\u00020\t*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001ac\u0010\u0017\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102/\u0010\u0019\u001a+\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00180\u001aH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010!\u001a\u00020\u0018*\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b\u001a&\u0010\"\u001a\u00020\u0018*\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"messageCollector", "Lksp/org/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "createSourceFilesFromSourceRoots", "", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "configuration", "Lksp/org/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lksp/com/intellij/openapi/project/Project;", "sourceRoots", "", "Lksp/org/jetbrains/kotlin/cli/common/config/KotlinSourceRoot;", "reportLocation", "Lksp/org/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "getSourceRootsCheckingForDuplicates", "applyModuleProperties", "module", "Lksp/org/jetbrains/kotlin/modules/Module;", "buildFile", "Ljava/io/File;", "forAllFiles", "", "body", "Lkotlin/Function3;", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "", "", "Lkotlin/ParameterName;", "name", "moduleName", "registerPluginsSuppliedExtensionsIfNeeded", "report", "severity", "Lksp/org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "cli-base"})
@SourceDebugExtension(value={"SMAP\ncoreEnvironmentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n44#1,40:164\n84#1,10:205\n1#2:163\n1#2:204\n*S KotlinDebug\n*F\n+ 1 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n*L\n116#1:164,40\n116#1:205,10\n116#1:204\n*E\n"})
public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location2) {
        block0: {
            Intrinsics.checkNotNullParameter($this$report, "<this>");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            Intrinsics.checkNotNullParameter(message2, "message");
            MessageCollector messageCollector = $this$report.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector == null) break block0;
            messageCollector.report(severity, message2, location2);
        }
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string2, compilerMessageLocation);
    }

    public static final void forAllFiles(@NotNull List<KotlinSourceRoot> $this$forAllFiles, @NotNull CompilerConfiguration configuration2, @NotNull Project project, @Nullable CompilerMessageLocation reportLocation, @NotNull Function3<? super VirtualFile, ? super Boolean, ? super String, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$forAllFiles, "<this>");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$forAllFiles = false;
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        boolean pluginsConfigured = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            String sourceRootPath = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File(sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize(sourceRoot).getPath());
            if (vFile == null) {
                String message2 = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message2 + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default(buildFilePath, null, 1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message2, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && !Intrinsics.areEqual(vFile.getExtension(), "kt")) {
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile, project);
                    pluginsConfigured = true;
                }
                if (!Intrinsics.areEqual(vFile.getFileType(), KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath, reportLocation);
                    continue;
                }
            }
            Iterator<File> iterator2 = FilesKt.walkTopDown(sourceRoot).iterator();
            while (iterator2.hasNext()) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                File file2 = iterator2.next();
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue(file3, "getAbsoluteFile(...)");
                if (localFileSystem.findFileByPath(FilesKt.normalize(file3).getPath()) != null) {
                    VirtualFile p0;
                    boolean bl = false;
                    virtualFile3 = virtualFileCreator.create(p0);
                } else {
                    virtualFile3 = null;
                }
                if ((virtualFile2 = virtualFile3) == null || !processedFiles.add(virtualFile2)) continue;
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile2, project);
                    pluginsConfigured = true;
                }
                body2.invoke(virtualFile2, (Boolean)isCommon, hmppModuleName);
            }
        }
    }

    public static /* synthetic */ void forAllFiles$default(List $this$forAllFiles_u24default, CompilerConfiguration configuration2, Project project, CompilerMessageLocation reportLocation, Function3 body2, int n, Object object) {
        if ((n & 4) != 0) {
            reportLocation = null;
        }
        Intrinsics.checkNotNullParameter($this$forAllFiles_u24default, "<this>");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$forAllFiles = false;
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        boolean pluginsConfigured = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles_u24default) {
            String sourceRootPath = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File(sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize(sourceRoot).getPath());
            if (vFile == null) {
                String message2 = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message2 + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default(buildFilePath, null, 1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message2, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && !Intrinsics.areEqual(vFile.getExtension(), "kt")) {
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile, project);
                    pluginsConfigured = true;
                }
                if (!Intrinsics.areEqual(vFile.getFileType(), KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath, reportLocation);
                    continue;
                }
            }
            Iterator<File> iterator2 = FilesKt.walkTopDown(sourceRoot).iterator();
            while (iterator2.hasNext()) {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                File file2 = iterator2.next();
                if (!file2.isFile()) continue;
                File file3 = file2.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue(file3, "getAbsoluteFile(...)");
                if (localFileSystem.findFileByPath(FilesKt.normalize(file3).getPath()) != null) {
                    VirtualFile p0;
                    boolean bl = false;
                    virtualFile3 = virtualFileCreator.create(p0);
                } else {
                    virtualFile3 = null;
                }
                if ((virtualFile2 = virtualFile3) == null || !processedFiles.add(virtualFile2)) continue;
                if (!pluginsConfigured) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile2, project);
                    pluginsConfigured = true;
                }
                body2.invoke(virtualFile2, isCommon, hmppModuleName);
            }
        }
    }

    public static final void registerPluginsSuppliedExtensionsIfNeeded(@NotNull VirtualFile $this$registerPluginsSuppliedExtensionsIfNeeded, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$registerPluginsSuppliedExtensionsIfNeeded, "<this>");
        Intrinsics.checkNotNullParameter(project, "project");
        if ($this$registerPluginsSuppliedExtensionsIfNeeded.getExtension() == null || Intrinsics.areEqual($this$registerPluginsSuppliedExtensionsIfNeeded.getExtension(), "kt") || Intrinsics.areEqual($this$registerPluginsSuppliedExtensionsIfNeeded.getExtension(), JavaFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual($this$registerPluginsSuppliedExtensionsIfNeeded.getExtension(), JavaClassFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual($this$registerPluginsSuppliedExtensionsIfNeeded.getFileType(), KotlinFileType.INSTANCE)) {
            return;
        }
        for (CompilerConfigurationExtension extension : CompilerConfigurationExtension.Companion.getInstances(project)) {
            extension.updateFileRegistry();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration2, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        PsiManager psiManager2 = PsiManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue(psiManager2, "getInstance(...)");
        PsiManager psiManager3 = psiManager2;
        List result2 = new ArrayList();
        List<KotlinSourceRoot> $this$forAllFiles$iv = sourceRoots;
        boolean $i$f$forAllFiles = false;
        VirtualFileSystem localFileSystem$iv = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles$iv = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator$iv = new PreprocessedFileCreator(project);
        boolean pluginsConfigured$iv = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles$iv) {
            String sourceRootPath$iv = kotlinSourceRoot.component1();
            boolean isCommon$iv = kotlinSourceRoot.component2();
            String hmppModuleName$iv = kotlinSourceRoot.component3();
            File sourceRoot$iv = new File(sourceRootPath$iv);
            VirtualFile vFile$iv = localFileSystem$iv.findFileByPath(FilesKt.normalize(sourceRoot$iv).getPath());
            if (vFile$iv == null) {
                String message$iv = "Source file or directory not found: " + sourceRootPath$iv;
                File buildFilePath$iv = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath$iv != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message$iv + "\n\nbuild file path: " + buildFilePath$iv + "\ncontent:\n" + FilesKt.readText$default(buildFilePath$iv, null, 1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message$iv, reportLocation);
                continue;
            }
            if (!vFile$iv.isDirectory() && !Intrinsics.areEqual(vFile$iv.getExtension(), "kt")) {
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                if (!Intrinsics.areEqual(vFile$iv.getFileType(), KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath$iv, reportLocation);
                    continue;
                }
            }
            Iterator<File> iterator2 = FilesKt.walkTopDown(sourceRoot$iv).iterator();
            while (iterator2.hasNext()) {
                void moduleName;
                void isCommon;
                PsiFile it;
                VirtualFile virtualFile$iv;
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                File file$iv = iterator2.next();
                if (!file$iv.isFile()) continue;
                File file2 = file$iv.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue(file2, "getAbsoluteFile(...)");
                VirtualFile virtualFile4 = virtualFile3 = localFileSystem$iv.findFileByPath(FilesKt.normalize(file2).getPath());
                if (virtualFile4 != null) {
                    Intrinsics.checkNotNull(virtualFile4);
                    VirtualFile p0$iv = virtualFile3;
                    boolean bl = false;
                    virtualFile2 = virtualFileCreator$iv.create(p0$iv);
                } else {
                    virtualFile2 = null;
                }
                if ((virtualFile$iv = virtualFile2) == null || !processedFiles$iv.add(virtualFile$iv)) continue;
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                String string2 = hmppModuleName$iv;
                boolean bl = isCommon$iv;
                VirtualFile virtualFile5 = virtualFile$iv;
                boolean bl2 = false;
                if (psiManager3.findFile(virtualFile5) == null) continue;
                boolean bl3 = false;
                if (!(it instanceof KtFile)) continue;
                IsCommonSourceKt.setCommonSource((KtFile)it, (boolean)isCommon);
                if (moduleName != null) {
                    IsCommonSourceKt.setHmppModuleName((KtFile)it, (String)moduleName);
                }
                result2.add(it);
            }
        }
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list2, CompilerMessageLocation compilerMessageLocation, int n, Object object) {
        if ((n & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list2, compilerMessageLocation);
    }

    @NotNull
    public static final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $this$messageCollector) {
        Intrinsics.checkNotNullParameter($this$messageCollector, "<this>");
        MessageCollector messageCollector = $this$messageCollector.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "getNotNull(...)");
        return messageCollector;
    }

    @NotNull
    public static final CompilerConfiguration applyModuleProperties(@NotNull CompilerConfiguration $this$applyModuleProperties, @NotNull Module module2, @Nullable File buildFile) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter($this$applyModuleProperties, "<this>");
        Intrinsics.checkNotNullParameter(module2, "module");
        CompilerConfiguration $this$applyModuleProperties_u24lambda_u243 = compilerConfiguration = $this$applyModuleProperties.copy();
        boolean bl = false;
        if (buildFile != null) {
            CompilerConfigurationKey<File> compilerConfigurationKey = JVMConfigurationKeys.OUTPUT_DIRECTORY;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$3$checkKeyIsNull($this$applyModuleProperties_u24lambda_u243, compilerConfigurationKey, "OUTPUT_DIRECTORY");
            CompilerConfigurationKey<File> compilerConfigurationKey2 = JVMConfigurationKeys.OUTPUT_JAR;
            Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, "OUTPUT_JAR");
            CoreEnvironmentUtilsKt.applyModuleProperties$lambda$3$checkKeyIsNull($this$applyModuleProperties_u24lambda_u243, compilerConfigurationKey2, "OUTPUT_JAR");
            $this$applyModuleProperties_u24lambda_u243.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(module2.getOutputDirectory()));
        }
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        Intrinsics.checkNotNullExpressionValue(compilerConfiguration2, "apply(...)");
        return compilerConfiguration2;
    }

    @NotNull
    public static final List<KotlinSourceRoot> getSourceRootsCheckingForDuplicates(@NotNull CompilerConfiguration configuration2, @Nullable MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        HashSet<String> uniqueSourceRoots = new HashSet<String>();
        List result2 = new ArrayList();
        for (KotlinSourceRoot root : ContentRootsKt.getKotlinSourceRoots(configuration2)) {
            if (!uniqueSourceRoots.add(root.getPath())) {
                MessageCollector messageCollector2 = messageCollector;
                if (messageCollector2 != null) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "Duplicate source root: " + root.getPath(), null, 4, null);
                }
            }
            result2.add(root);
        }
        return result2;
    }

    private static final void applyModuleProperties$lambda$3$checkKeyIsNull(CompilerConfiguration $this_apply, CompilerConfigurationKey<?> key, String name2) {
        boolean bl;
        boolean bl2 = bl = $this_apply.get(key) == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = name2 + " should be null, when buildFile is used";
            throw new AssertionError((Object)string2);
        }
    }
}

