/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.builtins.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.FqNameUnsafe;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J1\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0082\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J)\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper;", "Lksp/org/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "()V", "convertMutableToReadOnly", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "mutable", "convertReadOnlyToMutable", "readOnly", "convertToOppositeMutability", "descriptor", "mutabilityKindName", "", "oppositeNameExtractor", "Lkotlin/Function1;", "Lksp/org/jetbrains/kotlin/name/FqNameUnsafe;", "Lksp/org/jetbrains/kotlin/name/FqName;", "isMutable", "", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "isReadOnly", "mapJavaToKotlin", "fqName", "builtIns", "Lksp/org/jetbrains/kotlin/builtins/KotlinBuiltIns;", "functionTypeArity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mapPlatformClass", "", "classDescriptor", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\nJavaToKotlinClassMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n1#1,80:1\n75#1,3:81\n75#1,3:84\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n59#1:81,3\n65#1:84,3\n*E\n"})
public final class JavaToKotlinClassMapper
implements PlatformToKotlinClassMapper {
    @NotNull
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor2) {
        Collection<ClassDescriptor> collection;
        Intrinsics.checkNotNullParameter(classDescriptor2, "classDescriptor");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classDescriptor2);
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "getFqName(...)");
        FqNameUnsafe className2 = fqNameUnsafe;
        if (className2.isSafe()) {
            FqName fqName2 = className2.toSafe();
            Intrinsics.checkNotNullExpressionValue(fqName2, "toSafe(...)");
            collection = this.mapPlatformClass(fqName2, DescriptorUtilsKt.getBuiltIns(classDescriptor2));
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(builtIns2, "builtIns");
        ClassDescriptor classDescriptor2 = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, fqName2, builtIns2, null, 4, null);
        if (classDescriptor2 == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor2;
        FqName fqName3 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf(kotlinAnalog);
        }
        FqName kotlinMutableAnalogFqName = fqName3;
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[2];
        classDescriptorArray[0] = kotlinAnalog;
        Intrinsics.checkNotNullExpressionValue(builtIns2.getBuiltInClassByFqName(kotlinMutableAnalogFqName), "getBuiltInClassByFqName(...)");
        return CollectionsKt.listOf(classDescriptorArray);
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns2, @Nullable Integer functionTypeArity) {
        ClassId kotlinClassId;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(builtIns2, "builtIns");
        ClassId classId = kotlinClassId = functionTypeArity != null && Intrinsics.areEqual(fqName2, JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(functionTypeArity) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        return classId != null ? builtIns2.getBuiltInClassByFqName(classId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter(mutable, "mutable");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        return classDescriptor2 != null && this.isMutable(classDescriptor2);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter(readOnly, "readOnly");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        return classDescriptor2 != null && this.isReadOnly(classDescriptor2);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter(mutable, "mutable");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "mutable";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(mutable);
        boolean bl = false;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly(it);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(mutable).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getBuiltInClassByFqName(...)");
        return classDescriptor2;
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter(readOnly, "readOnly");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        String mutabilityKindName$iv = "read-only";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName(readOnly);
        boolean bl = false;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(it);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(readOnly).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getBuiltInClassByFqName(...)");
        return classDescriptor2;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, String mutabilityKindName, Function1<? super FqNameUnsafe, FqName> oppositeNameExtractor) {
        boolean $i$f$convertToOppositeMutability = false;
        FqName fqName2 = oppositeNameExtractor.invoke(DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getBuiltInClassByFqName(...)");
        return classDescriptor2;
    }
}

