/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.kotlin.backend.common.BackendContext;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$run$;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "backend.jvm.lower"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public EnumClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        if (!IrUtilsKt.isEnumClass(irClass)) {
            return;
        }
        new EnumClassTransformer(irClass, this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)).run();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020&R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000ej\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000ej\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0005*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u0005*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "supportsEnumEntries", "", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Z)V", "declarationToEnumEntry", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumArrayType", "Lksp/org/jetbrains/kotlin/ir/types/IrSimpleType;", "enumEntryOrdinals", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "loweredEnumConstructorParameters", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "loweredEnumConstructors", "Lksp/org/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "hasGetEntriesFunction", "getHasGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isGetEntriesFunction", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Z", "buildEntriesField", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "valuesField", "buildEnumEntryField", "enumEntry", "buildValuesField", "valuesHelperFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "buildValuesHelperFunction", "run", "", "EnumClassCallTransformer", "EnumClassDeclarationsTransformer", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n*L\n1#1,322:1\n473#2:323\n1313#2:324\n1314#2:326\n1#3:325\n1#3:343\n1745#4,3:327\n798#4,11:344\n249#5:330\n243#5:331\n237#5,10:332\n80#5:355\n74#5,10:356\n80#5:366\n74#5,10:367\n20#6:342\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer\n*L\n103#1:323\n103#1:324\n103#1:326\n157#1:343\n139#1:327,3\n158#1:344,11\n150#1:330\n150#1:331\n150#1:332,10\n165#1:355\n165#1:356,10\n180#1:366\n180#1:367,10\n157#1:342\n*E\n"})
    private final class EnumClassTransformer {
        @NotNull
        private final IrClass irClass;
        private final boolean supportsEnumEntries;
        @NotNull
        private final HashMap<IrConstructorSymbol, IrConstructor> loweredEnumConstructors;
        @NotNull
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        @NotNull
        private final HashMap<IrEnumEntry, Integer> enumEntryOrdinals;
        @NotNull
        private final Map<IrDeclaration, IrEnumEntry> declarationToEnumEntry;
        @NotNull
        private final IrSimpleType enumArrayType;

        public EnumClassTransformer(IrClass irClass, boolean supportsEnumEntries) {
            Intrinsics.checkNotNullParameter(irClass, "irClass");
            this.irClass = irClass;
            this.supportsEnumEntries = supportsEnumEntries;
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntryOrdinals = new HashMap();
            this.declarationToEnumEntry = new LinkedHashMap();
            IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType(this.irClass)};
            this.enumArrayType = IrTypesKt.typeWith((IrClassifierSymbol)EnumClassLowering.this.context.getIrBuiltIns().getArrayClass(), irTypeArray);
        }

        public final void run() {
            IrField irField;
            Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, EnumClassTransformer$run$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = SequencesKt.withIndex(sequence2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                IndexedValue element$iv;
                IndexedValue indexedValue = element$iv = iterator2.next();
                boolean bl = false;
                int index2 = indexedValue.component1();
                IrEnumEntry enumEntry = (IrEnumEntry)indexedValue.component2();
                Integer n = index2;
                ((Map)this.enumEntryOrdinals).put(enumEntry, n);
                if (enumEntry.getCorrespondingClass() != null) {
                    IrClass entryClass;
                    boolean bl2 = false;
                    this.declarationToEnumEntry.put(entryClass, enumEntry);
                }
                this.declarationToEnumEntry.put(this.buildEnumEntryField(enumEntry), enumEntry);
            }
            CollectionsKt.removeAll(this.irClass.getDeclarations(), (Function1)run.2.INSTANCE);
            CollectionsKt.addAll((Collection)this.irClass.getDeclarations(), (Iterable)this.declarationToEnumEntry.keySet());
            IrFunction valuesHelperFunction = this.buildValuesHelperFunction();
            IrField valuesField = this.buildValuesField(valuesHelperFunction);
            if (!this.getHasGetEntriesFunction(this.irClass)) {
                irField = null;
            } else {
                if (!this.supportsEnumEntries) {
                    throw new IllegalStateException("The frontend must have checked if the feature is supported while emitting the IR".toString());
                }
                irField = this.buildEntriesField(valuesField);
            }
            IrField entriesField = irField;
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassDeclarationsTransformer(valuesField, entriesField));
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassCallTransformer());
        }

        private final boolean getHasGetEntriesFunction(IrClass $this$hasGetEntriesFunction) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = $this$hasGetEntriesFunction.getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrDeclaration it = (IrDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!this.isGetEntriesFunction(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isGetEntriesFunction(IrDeclaration $this$isGetEntriesFunction) {
            return $this$isGetEntriesFunction instanceof IrFunction && Intrinsics.areEqual(((IrFunction)$this$isGetEntriesFunction).getName(), SpecialNames.ENUM_GET_ENTRIES) && Intrinsics.areEqual($this$isGetEntriesFunction.getOrigin(), IrDeclarationOrigin.Companion.getENUM_CLASS_SPECIAL_MEMBER());
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEnumEntryField(IrEnumEntry enumEntry) {
            IrExpressionBodyImpl irExpressionBodyImpl;
            IrField irField;
            IrField $this$buildEnumEntryField_u24lambda_u244 = irField = EnumClassLowering.this.context.getCachedDeclarations().getFieldForEnumEntry(enumEntry);
            boolean bl = false;
            IrField irField2 = $this$buildEnumEntryField_u24lambda_u244;
            IrExpressionBody irExpressionBody = enumEntry.getInitializerExpression();
            if (irExpressionBody != null) {
                void it;
                IrExpressionBody irExpressionBody2 = irExpressionBody;
                IrField irField3 = irField2;
                boolean bl2 = false;
                irExpressionBodyImpl = new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)it.getExpression(), $this$buildEnumEntryField_u24lambda_u244));
                irField2 = irField3;
            } else {
                irExpressionBodyImpl = null;
            }
            irField2.setInitializer(irExpressionBodyImpl);
            $this$buildEnumEntryField_u24lambda_u244.setAnnotations(CollectionsKt.plus((Collection)$this$buildEnumEntryField_u24lambda_u244.getAnnotations(), (Iterable)enumEntry.getAnnotations()));
            return irField;
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction buildValuesHelperFunction() {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$irArray$iv;
            IrArrayBuilder irArrayBuilder;
            void $this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247;
            IrClass $this$addFunction$iv = this.irClass;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
            boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = false;
            IrFunctionBuilder $this$buildValuesHelperFunction_u24lambda_u245 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
            boolean bl = false;
            Name name2 = Name.identifier("$values");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            $this$buildValuesHelperFunction_u24lambda_u245.setName(name2);
            $this$buildValuesHelperFunction_u24lambda_u245.setReturnType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
            $this$buildValuesHelperFunction_u24lambda_u245.setVisibility(descriptorVisibility);
            $this$buildValuesHelperFunction_u24lambda_u245.setOrigin(IrDeclarationOrigin.Companion.getSYNTHETIC_HELPER_FOR_ENUM_VALUES());
            Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2420$iv$iv$iv);
            boolean bl2 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object object = $this$buildFun$iv$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildValuesHelperFunction_u24lambda_u248 = object;
            boolean bl3 = false;
            $this$buildFun$iv$iv$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrSimpleFunction)$this$buildValuesHelperFunction_u24lambda_u248).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildValuesHelperFunction_u24lambda_u248;
            boolean bl4 = false;
            void $i$a$-run-DeclarationBuildersKt$buildFun$1$iv$iv$iv22 = $this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247;
            IrType arrayType$iv = ((IrFunction)$this$buildValuesHelperFunction_u24lambda_u248).getReturnType();
            boolean $i$f$irArray = false;
            IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl5 = false;
            IrArrayBuilder irArrayBuilder2 = $this$irArray_u24lambda_u240$iv;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247;
            boolean bl6 = false;
            Iterable $this$filterIsInstance$iv = this.declarationToEnumEntry.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrField)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrField irField : (List)destination$iv$iv) {
                void $this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                $this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247_u24lambda_u246.unaryPlus(ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$buildValuesHelperFunction_u24lambda_u248_u24lambda_u247, null, irField, null, 4, null));
            }
            ((IrFunction)object2).setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irArrayBuilder.build()));
            return (IrFunction)object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildValuesField(IrFunction valuesHelperFunction) {
            void $this$buildValuesField_u24lambda_u2411_u24lambda_u2410;
            IrClass $this$addField$iv = this.irClass;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildValuesField_u24lambda_u249 = $this$buildField_u24lambda_u244$iv$iv;
            boolean bl2 = false;
            Name name2 = Name.identifier("$VALUES");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            $this$buildValuesField_u24lambda_u249.setName(name2);
            $this$buildValuesField_u24lambda_u249.setType(this.enumArrayType);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
            $this$buildValuesField_u24lambda_u249.setVisibility(descriptorVisibility);
            $this$buildValuesField_u24lambda_u249.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_VALUES());
            $this$buildValuesField_u24lambda_u249.setFinal(true);
            $this$buildValuesField_u24lambda_u249.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
            boolean $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = false;
            field$iv.setParent($this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            Object object = $this$buildField$iv$iv;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            Object $this$buildValuesField_u24lambda_u2411 = object;
            boolean bl3 = false;
            JvmIrBuilder $i$a$-also-DeclarationBuildersKt$addField$1$iv22 = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildValuesField_u24lambda_u2411).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildValuesField_u24lambda_u2411;
            boolean bl4 = false;
            ((IrField)object2).setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2411_u24lambda_u2410, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildValuesField_u24lambda_u2411_u24lambda_u2410, valuesHelperFunction.getSymbol())));
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrField buildEntriesField(IrField valuesField) {
            void $this$buildEntriesField_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413;
            void $this$buildEntriesField_u24lambda_u2415_u24lambda_u2414;
            IrCall irCall;
            void $this$addField$iv;
            Object object = this.irClass;
            EnumClassLowering enumClassLowering = EnumClassLowering.this;
            boolean $i$f$addField = false;
            Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
            boolean bl = false;
            IrFieldBuilder $this$buildEntriesField_u24lambda_u2412 = $this$buildField_u24lambda_u244$iv$iv;
            boolean $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = false;
            Name name2 = Name.identifier("$ENTRIES");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            $this$buildEntriesField_u24lambda_u2412.setName(name2);
            $this$buildEntriesField_u24lambda_u2412.setType(IrTypesKt.getDefaultType(enumClassLowering.context.getIr().getSymbols().getEnumEntries()));
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PRIVATE");
            $this$buildEntriesField_u24lambda_u2412.setVisibility(descriptorVisibility);
            $this$buildEntriesField_u24lambda_u2412.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRIES());
            $this$buildEntriesField_u24lambda_u2412.setFinal(true);
            $this$buildEntriesField_u24lambda_u2412.setStatic(true);
            Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
            boolean bl2 = false;
            field$iv.setParent((IrDeclarationParent)$this$addField$iv);
            $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
            object = $this$buildField$iv$iv;
            enumClassLowering = EnumClassLowering.this;
            Object $this$buildEntriesField_u24lambda_u2415 = object;
            boolean bl3 = false;
            field$iv = JvmIrBuilderKt.createJvmIrBuilder$default(enumClassLowering.context, ((IrField)$this$buildEntriesField_u24lambda_u2415).getSymbol(), 0, 0, 6, null);
            Object object2 = $this$buildEntriesField_u24lambda_u2415;
            boolean bl4 = false;
            IrCall $i$a$-addField-EnumClassLowering$EnumClassTransformer$buildEntriesField$22 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2415_u24lambda_u2414, enumClassLowering.context.getIr().getSymbols().getCreateEnumEntries());
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2415_u24lambda_u2414;
            boolean bl5 = false;
            $this$buildEntriesField_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.putValueArgument(0, ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$buildEntriesField_u24lambda_u2415_u24lambda_u2414, null, valuesField, null, 4, null));
            ((IrField)object2).setInitializer(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irCall));
            return object;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer;", "Lksp/org/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "visitClassNew", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitGetValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrSetValue;", "passConstructorArguments", "", "Lksp/org/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "call", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "original", "enumEntry", "Lksp/org/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassCallTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
        private final class EnumClassCallTransformer
        extends IrElementTransformerVoidWithContext {
            @Override
            @NotNull
            public IrStatement visitClassNew(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrUtilsKt.isEnumEntry(declaration2) ? super.visitClassNew(declaration2) : (IrStatement)declaration2;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }

            @Override
            @NotNull
            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                IrValueParameter irValueParameter = (IrValueParameter)((Map)EnumClassTransformer.this.loweredEnumConstructorParameters).get(expression2.getSymbol());
                if (irValueParameter != null) {
                    IrValueParameter it = irValueParameter;
                    boolean bl = false;
                    irExpression = new IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getValue(), expression2.getOrigin());
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }

            @Override
            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull(scopeWithIr);
                IrSymbol scopeOwnerSymbol = scopeWithIr.getScope().getScopeOwnerSymbol();
                IrBuilder irBuilder = LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(EnumClassLowering.this.context, scopeOwnerSymbol, 0, 0, 6, null), expression2);
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                DeclarationIrBuilder $this$visitEnumConstructorCall_u24lambda_u243 = (DeclarationIrBuilder)irBuilder;
                boolean bl = false;
                IrConstructor irConstructor2 = (IrConstructor)enumClassTransformer.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor2 == null) {
                    irConstructor2 = (IrConstructor)expression2.getSymbol().getOwner();
                }
                IrElementBase irElementBase = irConstructor2;
                Intrinsics.checkNotNull(irElementBase);
                IrConstructor constructor2 = irElementBase;
                IrElementBase it = irElementBase = scopeOwnerSymbol instanceof IrConstructorSymbol ? (IrFunctionAccessExpression)ExpressionHelpersKt.irDelegatingConstructorCall($this$visitEnumConstructorCall_u24lambda_u243, constructor2) : ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitEnumConstructorCall_u24lambda_u243, constructor2);
                boolean bl2 = false;
                IrBuilderWithScope irBuilderWithScope = $this$visitEnumConstructorCall_u24lambda_u243;
                IrFunctionAccessExpression irFunctionAccessExpression = expression2;
                Map map = enumClassTransformer.declarationToEnumEntry;
                IrSymbolOwner irSymbolOwner = scopeOwnerSymbol.getOwner();
                Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                this.passConstructorArguments(irBuilderWithScope, (IrFunctionAccessExpression)it, irFunctionAccessExpression, (IrEnumEntry)map.get((IrDeclaration)irSymbolOwner));
                return (IrExpression)irElementBase;
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCall irDelegatingConstructorCall2;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor irConstructor2 = (IrConstructor)EnumClassTransformer.this.loweredEnumConstructors.get(expression2.getSymbol());
                if (irConstructor2 == null) {
                    return expression2;
                }
                IrConstructor replacement = irConstructor2;
                BackendContext backendContext = EnumClassLowering.this.context;
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull(scopeWithIr);
                DeclarationIrBuilder $this$visitDelegatingConstructorCall_u24lambda_u245 = (DeclarationIrBuilder)LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), 0, 0, 6, null), expression2);
                boolean bl = false;
                IrDelegatingConstructorCall it = irDelegatingConstructorCall2 = ExpressionHelpersKt.irDelegatingConstructorCall($this$visitDelegatingConstructorCall_u24lambda_u245, replacement);
                boolean bl2 = false;
                EnumClassCallTransformer.passConstructorArguments$default(this, $this$visitDelegatingConstructorCall_u24lambda_u245, it, expression2, null, 4, null);
                return irDelegatingConstructorCall2;
            }

            private final void passConstructorArguments(IrBuilderWithScope $this$passConstructorArguments, IrFunctionAccessExpression call2, IrFunctionAccessExpression original, IrEnumEntry enumEntry) {
                IrExpressionsKt.copyTypeArgumentsFrom$default(call2, original, 0, 2, null);
                if (enumEntry != null) {
                    String string2 = enumEntry.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    call2.putValueArgument(0, ExpressionHelpersKt.irString($this$passConstructorArguments, string2));
                    Object v = EnumClassTransformer.this.enumEntryOrdinals.get(enumEntry);
                    Intrinsics.checkNotNull(v);
                    call2.putValueArgument(1, ExpressionHelpersKt.irInt$default($this$passConstructorArguments, ((Number)v).intValue(), null, 2, null));
                } else {
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull(scopeWithIr);
                    IrSymbol irSymbol2 = scopeWithIr.getScope().getScopeOwnerSymbol();
                    Intrinsics.checkNotNull(irSymbol2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
                    IrConstructorSymbol constructor2 = (IrConstructorSymbol)irSymbol2;
                    call2.putValueArgument(0, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(0)));
                    call2.putValueArgument(1, ExpressionHelpersKt.irGet($this$passConstructorArguments, ((IrConstructor)constructor2.getOwner()).getValueParameters().get(1)));
                }
                int n = original.getValueArgumentsCount();
                for (int index2 = 0; index2 < n; ++index2) {
                    IrExpression it;
                    if (original.getValueArgument(index2) == null) continue;
                    boolean bl = false;
                    call2.putValueArgument(index2 + 2, it);
                }
            }

            static /* synthetic */ void passConstructorArguments$default(EnumClassCallTransformer enumClassCallTransformer, IrBuilderWithScope irBuilderWithScope, IrFunctionAccessExpression irFunctionAccessExpression, IrFunctionAccessExpression irFunctionAccessExpression2, IrEnumEntry irEnumEntry, int n, Object object) {
                if ((n & 4) != 0) {
                    irEnumEntry = null;
                }
                enumClassCallTransformer.passConstructorArguments(irBuilderWithScope, irFunctionAccessExpression, irFunctionAccessExpression2, irEnumEntry);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "valuesField", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "entriesField", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrField;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "visitClass", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitSimpleFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
        @SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n283#2,4:323\n1547#3:327\n1618#3,3:328\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer\n*L\n205#1:323,4\n218#1:327\n218#1:328,3\n*E\n"})
        private final class EnumClassDeclarationsTransformer
        extends IrElementTransformerVoid {
            @NotNull
            private final IrField valuesField;
            @Nullable
            private final IrField entriesField;

            public EnumClassDeclarationsTransformer(@Nullable IrField valuesField, IrField entriesField) {
                Intrinsics.checkNotNullParameter(valuesField, "valuesField");
                this.valuesField = valuesField;
                this.entriesField = entriesField;
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                return IrUtilsKt.isEnumEntry(declaration2) ? super.visitClass(declaration2) : (IrStatement)declaration2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2) {
                Collection<IrValueParameter> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                IrFactory $this$buildConstructor$iv = EnumClassLowering.this.context.getIrFactory();
                boolean $i$f$buildConstructor = false;
                IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
                boolean bl = false;
                IrFunctionBuilder $this$visitConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u2424$iv;
                boolean $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = false;
                $this$visitConstructor_u24lambda_u240.updateFrom(declaration2);
                $this$visitConstructor_u24lambda_u240.setReturnType(declaration2.getReturnType());
                IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2424$iv);
                EnumClassLowering enumClassLowering = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                IrConstructor $this$visitConstructor_u24lambda_u243 = irConstructor2;
                boolean bl2 = false;
                $this$visitConstructor_u24lambda_u243.setParent(declaration2.getParent());
                $this$visitConstructor_u24lambda_u243.setAnnotations(declaration2.getAnnotations());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u243, "$enum$name", enumClassLowering.context.getIrBuiltIns().getStringType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER());
                DeclarationBuildersKt.addValueParameter((IrFunction)$this$visitConstructor_u24lambda_u243, "$enum$ordinal", enumClassLowering.context.getIrBuiltIns().getIntType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getENUM_CONSTRUCTOR_SYNTHETIC_PARAMETER());
                Iterable $i$a$-buildConstructor-EnumClassLowering$EnumClassTransformer$EnumClassDeclarationsTransformer$visitConstructor$22 = declaration2.getValueParameters();
                Collection collection2 = $this$visitConstructor_u24lambda_u243.getValueParameters();
                IrConstructor irConstructor3 = $this$visitConstructor_u24lambda_u243;
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void param;
                    IrValueParameter irValueParameter;
                    IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    IrValueParameter newParam = irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)param, $this$visitConstructor_u24lambda_u243, null, param.getIndex() + 2, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
                    boolean bl4 = false;
                    ((Map)enumClassTransformer.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                    collection.add(irValueParameter);
                }
                collection = (List)destination$iv$iv;
                irConstructor3.setValueParameters(CollectionsKt.plus(collection2, (Iterable)collection));
                IrBody irBody = declaration2.getBody();
                $this$visitConstructor_u24lambda_u243.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, $this$visitConstructor_u24lambda_u243) : null);
                ((Map)enumClassTransformer.loweredEnumConstructors).put(declaration2.getSymbol(), $this$visitConstructor_u24lambda_u243);
                $this$visitConstructor_u24lambda_u243.setMetadata(declaration2.getMetadata());
                return irConstructor2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrDeclarationReference irDeclarationReference;
                void $this$visitSimpleFunction_u24lambda_u246;
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Object object = declaration2.getBody();
                IrSyntheticBody irSyntheticBody = object instanceof IrSyntheticBody ? (IrSyntheticBody)object : null;
                if (irSyntheticBody == null) {
                    return declaration2;
                }
                IrSyntheticBody body2 = irSyntheticBody;
                JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(EnumClassLowering.this.context, declaration2.getSymbol(), 0, 0, 6, null);
                object = EnumClassLowering.this;
                EnumClassTransformer enumClassTransformer = EnumClassTransformer.this;
                JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
                IrSimpleFunction irSimpleFunction = declaration2;
                boolean bl = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                switch (WhenMappings.$EnumSwitchMapping$0[body2.getKind().ordinal()]) {
                    case 1: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244;
                        IrCall irCall;
                        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, ((EnumClassLowering)object).context.getIr().getSymbols().getObjectCloneFunction(), declaration2.getReturnType(), 0, 0, null, 28, null);
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        boolean bl2 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244.setDispatchReceiver(ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, null, this.valuesField, null, 4, null));
                        irBuilderWithScope = irBuilderWithScope2;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 2: {
                        void $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245;
                        IrCall irCall;
                        IrCall $this$visitSimpleFunction_u24lambda_u246_u24lambda_u244 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, $this$visitSimpleFunction_u24lambda_u246.getBackendContext().getIr().getSymbols().getEnumValueOfFunction());
                        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
                        boolean bl3 = false;
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(0, JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$visitSimpleFunction_u24lambda_u246, IrUtilsKt.getDefaultType(enumClassTransformer.irClass)));
                        $this$visitSimpleFunction_u24lambda_u246_u24lambda_u245.putValueArgument(1, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246, declaration2.getValueParameters().get(0)));
                        irBuilderWithScope = irBuilderWithScope3;
                        irDeclarationReference = irCall;
                        break;
                    }
                    case 3: {
                        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$visitSimpleFunction_u24lambda_u246;
                        IrField irField = this.entriesField;
                        Intrinsics.checkNotNull(irField);
                        irDeclarationReference = ExpressionHelpersKt.irGetField$default(irBuilderWithScope4, null, irField, null, 4, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irDeclarationReference));
                return declaration2;
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[IrSyntheticBodyKind.values().length];
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_VALUEOF.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[IrSyntheticBodyKind.ENUM_ENTRIES.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

